/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.connection;

import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.github.wrdlbrnft.simplerest.connection.BackendConnection;
import com.github.wrdlbrnft.simplerest.connection.CookiesImpl;
import com.github.wrdlbrnft.simplerest.connection.ResponseImpl;
import com.github.wrdlbrnft.simplerest.connection.exception.BackendConnectionException;
import com.github.wrdlbrnft.simplerest.connection.request.Request;
import com.github.wrdlbrnft.simplerest.connection.response.Cookies;
import com.github.wrdlbrnft.simplerest.connection.response.Response;
import com.github.wrdlbrnft.simplerest.util.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbsBackendConnection
implements BackendConnection {
    private static final String LOG_TAG = AbsBackendConnection.class.getSimpleName();

    @Override
    public Response perform(Request request) {
        LogUtils.Block block = LogUtils.newBlock();
        try {
            LogUtils.logRequest(block, request);
            HttpURLConnection connection = this.openConnection(request);
            Response response = this.readResponse(connection);
            LogUtils.logResponse(block, response);
            Response response2 = response;
            return response2;
        }
        catch (IOException e) {
            throw new BackendConnectionException("Connection to backend failed!", e);
        }
        finally {
            String log = block.build();
            Log.i((String)LOG_TAG, (String)("|\n" + log));
        }
    }

    private Response readResponse(HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        Map<String, String> headers = this.parseResponseHeaders(connection);
        Cookies cookies = this.parseCookieFromHeaders(headers);
        InputStream inputStream = status < 400 ? connection.getInputStream() : connection.getErrorStream();
        String responseData = connection.getDoOutput() ? this.readDataFromStream(inputStream) : null;
        return new ResponseImpl(status, responseData, headers, cookies, connection.getURL());
    }

    private Cookies parseCookieFromHeaders(Map<String, String> headers) {
        String cookieString = headers.get("Set-Cookie");
        if (cookieString == null) {
            return new CookiesImpl(Collections.emptyList(), Collections.emptyMap());
        }
        List<String> cookies = Arrays.asList(cookieString.split(";"));
        ArrayMap keyValueCookies = new ArrayMap();
        for (String cookie : cookies) {
            if (!cookie.contains("=")) continue;
            String[] split = cookie.split("=");
            keyValueCookies.put(split[0], split[1]);
        }
        return new CookiesImpl(cookies, (Map<String, String>)keyValueCookies);
    }

    private Map<String, String> parseResponseHeaders(HttpURLConnection connection) {
        ArrayMap headers = new ArrayMap();
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        for (String key : headerFields.keySet()) {
            List<String> values = headerFields.get(key);
            if (values.size() > 1) continue;
            headers.put(key, values.get(0));
        }
        return headers;
    }

    @Override
    public HttpURLConnection openConnection(Request request) throws BackendConnectionException {
        try {
            String json = request.getData();
            HttpURLConnection connection = this.performConnect(request);
            if (json != null && json.length() > 0) {
                OutputStream outputStream = connection.getOutputStream();
                this.writeDataToStream(outputStream, json);
            }
            return connection;
        }
        catch (IOException e) {
            throw new BackendConnectionException("Connection to backend failed!", e);
        }
    }

    private void writeDataToStream(OutputStream stream, String data) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        writer.write(data);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    private String readDataFromStream(InputStream stream) throws IOException {
        String line;
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder builder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            builder.append(line);
        }
        return builder.toString();
    }

    protected abstract HttpURLConnection performConnect(Request var1) throws BackendConnectionException;
}

