/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.taskrunners;

import com.github.wrdlbrnft.simplerest.BaseApi;
import com.github.wrdlbrnft.simplerest.callbacks.ApiCallback;
import com.github.wrdlbrnft.simplerest.taskrunners.ApiTaskImpl;
import com.github.wrdlbrnft.simplerest.tasks.ApiTask;
import com.github.wrdlbrnft.simplerest.tasks.Result;
import com.github.wrdlbrnft.simpletasks.runners.TaskRunner;
import com.github.wrdlbrnft.simpletasks.tasks.ErrorCallback;
import com.github.wrdlbrnft.simpletasks.tasks.ResultCallback;
import com.github.wrdlbrnft.simpletasks.tasks.Task;
import java.util.concurrent.Callable;

public class ApiTaskRunner {
    private final TaskRunner mRunner;

    public ApiTaskRunner(TaskRunner runner) {
        this.mRunner = runner;
    }

    public <T> ApiTask<T> queueTask(Callable<Result<T>> callable) {
        Task task = this.mRunner.queue(callable);
        return new ApiTaskImpl(task);
    }

    public <T> ApiTask<T> queueTask(Callable<Result<T>> callable, final ApiCallback<T> internalCallback) {
        Task task = this.mRunner.queue(callable);
        task.onResult(new ResultCallback<Result<T>>(){

            public void onResult(Result<T> result) {
                internalCallback.onResult(result.getStatusCode(), result.getData());
            }
        });
        task.onError(new ErrorCallback(){

            public void onError(Throwable throwable) {
                internalCallback.onError();
            }
        });
        return new ApiTaskImpl(task);
    }

    public <T> ApiTask<T> cacheTask(final T result) {
        return this.queueTask(new Callable<Result<T>>(){

            @Override
            public Result<T> call() throws Exception {
                return new BaseApi.ResultImpl<Object>(200, result);
            }
        });
    }

    public void start() {
        this.mRunner.start();
    }

    public void stop() {
        this.mRunner.stop();
    }

    public boolean isRunning() {
        return this.mRunner.getState() == 1;
    }
}

