/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplejson.parsers;

import com.github.wrdlbrnft.simplejson.exceptions.SimpleJsonException;
import com.github.wrdlbrnft.simplejson.parsers.ElementParser;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class ParserExtension<I, O>
implements ElementParser<O> {
    private final ElementParser<I> mBaseParser;

    public ParserExtension(ElementParser<I> baseParser) {
        this.mBaseParser = baseParser;
    }

    @Override
    public final O fromJsonObject(JSONObject object, String key) throws SimpleJsonException {
        I input = this.mBaseParser.fromJsonObject(object, key);
        return this.convertUp(input);
    }

    @Override
    public final void toJsonObject(JSONObject object, String key, O value) throws SimpleJsonException {
        I input = this.convertDown(value);
        this.mBaseParser.toJsonObject(object, key, input);
    }

    @Override
    public final O fromJsonArray(JSONArray array, int index) throws SimpleJsonException {
        I input = this.mBaseParser.fromJsonArray(array, index);
        return this.convertUp(input);
    }

    @Override
    public final void toJsonArray(JSONArray array, O value) throws SimpleJsonException {
        I input = this.convertDown(value);
        this.mBaseParser.toJsonArray(array, input);
    }

    protected abstract O convertUp(I var1);

    protected abstract I convertDown(O var1);
}

