package com.github.wrdlbrnft.simplejson.parsers.base;

import com.github.wrdlbrnft.simplejson.exceptions.SimpleJsonException;
import com.github.wrdlbrnft.simplejson.parsers.ElementParser;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by kapeller on 21/04/15.
 */
public class FloatParser implements ElementParser<Float> {

    @Override
    public Float fromJsonObject(JSONObject object, String key) throws SimpleJsonException {
        try {
            return (float) object.getDouble(key);
        } catch (JSONException e) {
            throw new SimpleJsonException("Failed to get float value with key \"" + key + "\" from json: " + object, e);
        }
    }

    @Override
    public void toJsonObject(JSONObject object, String key, Float value) throws SimpleJsonException {
        try {
            object.put(key, value);
        } catch (JSONException e) {
            throw new SimpleJsonException("Failed to add float value " + value + " with key \"" + key + "\" to json: " + object, e);
        }
    }

    @Override
    public Float fromJsonArray(JSONArray array, int index) throws SimpleJsonException {
        try {
            return (float) array.getDouble(index);
        } catch (JSONException e) {
            throw new SimpleJsonException("Failed to get float value with index " + index + " from json array: " + array, e);
        }
    }

    @Override
    public void toJsonArray(JSONArray array, Float value) throws SimpleJsonException {
        array.put(value);
    }
}
