/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplejson.parsers.base.date;

import android.annotation.SuppressLint;
import com.github.wrdlbrnft.simplejson.parsers.base.date.DateFormatter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PatternDateFormatter
implements DateFormatter {
    private final SimpleDateFormat mDateFormat;

    @SuppressLint(value={"SimpleDateFormat"})
    public PatternDateFormatter(String pattern) {
        this.mDateFormat = new SimpleDateFormat(pattern);
    }

    @Override
    public Date fromJsonObject(JSONObject object, String key) throws JSONException, ParseException {
        String dateString = object.getString(key);
        return this.mDateFormat.parse(dateString);
    }

    @Override
    public void toJsonObject(JSONObject object, String key, Date value) throws JSONException {
        object.put(key, (Object)this.mDateFormat.format(value));
    }

    @Override
    public Date fromJsonArray(JSONArray array, int index) throws JSONException, ParseException {
        String dateString = array.getString(index);
        return this.mDateFormat.parse(dateString);
    }

    @Override
    public void toJsonArray(JSONArray array, Date value) {
        array.put((Object)this.mDateFormat.format(value));
    }
}

