/*
 * Decompiled with CFR 0.152.
 */
package worker8.com.github.radiogroupplus;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.IdRes;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;

public class RadioGroupPlus
extends LinearLayout {
    private int mCheckedId = -1;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private boolean mProtectFromCheckedChange = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;

    public RadioGroupPlus(Context context) {
        super(context);
        this.setOrientation(1);
        this.init();
    }

    public RadioGroupPlus(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.mPassThroughListener);
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        RadioButton button;
        if (child instanceof RadioButton && (button = (RadioButton)child).isChecked()) {
            this.mProtectFromCheckedChange = true;
            if (this.mCheckedId != -1) {
                this.setCheckedStateForView(this.mCheckedId, false);
            }
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(button.getId());
        }
        super.addView(child, index, params);
    }

    public void check(@IdRes int id) {
        if (id != -1 && id == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (id != -1) {
            this.setCheckedStateForView(id, true);
        }
        this.setCheckedId(id);
    }

    private void setCheckedId(@IdRes int id) {
        this.mCheckedId = id;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView != null && checkedView instanceof RadioButton) {
            ((RadioButton)checkedView).setChecked(checked);
        }
    }

    @IdRes
    public int getCheckedRadioButtonId() {
        return this.mCheckedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof RadioGroup.LayoutParams;
    }

    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public CharSequence getAccessibilityClassName() {
        return RadioGroup.class.getName();
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        public void traverseTree(View view) {
            Log.d((String)"ddw", (String)("traverseTree: " + view));
            if (view instanceof RadioButton) {
                int id = view.getId();
                if (id == -1) {
                    id = View.generateViewId();
                    view.setId(id);
                }
                ((RadioButton)view).setOnCheckedChangeListener(RadioGroupPlus.this.mChildOnCheckedChangeListener);
            }
            if (!(view instanceof ViewGroup)) {
                return;
            }
            ViewGroup viewGroup = (ViewGroup)view;
            if (viewGroup.getChildCount() == 0) {
                return;
            }
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.traverseTree(viewGroup.getChildAt(i));
            }
        }

        public void onChildViewAdded(View parent, View child) {
            Log.d((String)"ddw", (String)("onChildViewAdded: " + child));
            this.traverseTree(child);
            if (parent == RadioGroupPlus.this && child instanceof RadioButton) {
                int id = child.getId();
                if (id == -1) {
                    id = View.generateViewId();
                    child.setId(id);
                }
                ((RadioButton)child).setOnCheckedChangeListener(RadioGroupPlus.this.mChildOnCheckedChangeListener);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == RadioGroupPlus.this && child instanceof RadioButton) {
                ((RadioButton)child).setOnCheckedChangeListener(null);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            Log.d((String)"ddw", (String)"onCheckedChanged: ");
            if (RadioGroupPlus.this.mProtectFromCheckedChange) {
                return;
            }
            RadioGroupPlus.this.mProtectFromCheckedChange = true;
            if (RadioGroupPlus.this.mCheckedId != -1) {
                RadioGroupPlus.this.setCheckedStateForView(RadioGroupPlus.this.mCheckedId, false);
            }
            RadioGroupPlus.this.mProtectFromCheckedChange = false;
            int id = buttonView.getId();
            RadioGroupPlus.this.setCheckedId(id);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RadioGroupPlus var1, @IdRes int var2);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, float initWeight) {
            super(w, h, initWeight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.hasValue(widthAttr) ? a.getLayoutDimension(widthAttr, "layout_width") : -2;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }
    }
}

