/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.os.Handler;
import android.os.Looper;
import android.widget.EditText;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.IHistoryListener;
import org.wordpress.aztec.source.SourceViewEditText;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u00019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020+J\u001a\u0010/\u001a\u00020+2\u0006\u0010!\u001a\u00020\u00102\b\u0010,\u001a\u0004\u0018\u00010-H\u0004J\u000e\u00100\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0006\u00101\u001a\u00020\u0003J\u000e\u00102\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u0016J\u0010\u00105\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u000e\u00106\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0006\u00107\u001a\u00020\u0003J\u0006\u00108\u001a\u00020+R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0018\u00010\u0018R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/wordpress/aztec/History;", "", "historyEnabled", "", "historySize", "", "(ZI)V", "historyCursor", "getHistoryCursor", "()I", "setHistoryCursor", "(I)V", "getHistoryEnabled", "()Z", "historyList", "Ljava/util/LinkedList;", "", "getHistoryList", "()Ljava/util/LinkedList;", "setHistoryList", "(Ljava/util/LinkedList;)V", "historyListener", "Lorg/wordpress/aztec/IHistoryListener;", "historyRunnable", "Lorg/wordpress/aztec/History$HistoryRunnable;", "getHistorySize", "historyThrottleTime", "", "getHistoryThrottleTime", "()J", "setHistoryThrottleTime", "(J)V", "historyWorking", "inputBefore", "inputLast", "getInputLast", "()Ljava/lang/String;", "setInputLast", "(Ljava/lang/String;)V", "mainHandler", "Landroid/os/Handler;", "textChangedPending", "beforeTextChanged", "", "editText", "Landroid/widget/EditText;", "clearHistory", "doHandleHistory", "redo", "redoValid", "refreshLastHistoryItem", "setHistoryListener", "listener", "setTextFromHistory", "undo", "undoValid", "updateActions", "HistoryRunnable", "aztec_release"})
public final class History {
    private int historyCursor;
    @NotNull
    private LinkedList<String> historyList;
    @NotNull
    private String inputLast;
    private IHistoryListener historyListener;
    private boolean historyWorking;
    private String inputBefore;
    private final Handler mainHandler;
    private final HistoryRunnable historyRunnable;
    private boolean textChangedPending;
    private long historyThrottleTime;
    private final boolean historyEnabled;
    private final int historySize;

    public final int getHistoryCursor() {
        return this.historyCursor;
    }

    public final void setHistoryCursor(int n) {
        this.historyCursor = n;
    }

    @NotNull
    public final LinkedList<String> getHistoryList() {
        return this.historyList;
    }

    public final void setHistoryList(@NotNull LinkedList<String> linkedList) {
        Intrinsics.checkParameterIsNotNull(linkedList, (String)"<set-?>");
        this.historyList = linkedList;
    }

    @NotNull
    public final String getInputLast() {
        return this.inputLast;
    }

    public final void setInputLast(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.inputLast = string2;
    }

    public final long getHistoryThrottleTime() {
        return this.historyThrottleTime;
    }

    public final void setHistoryThrottleTime(long l) {
        this.historyThrottleTime = l;
    }

    public final void beforeTextChanged(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        if (this.historyEnabled && !this.historyWorking) {
            this.mainHandler.removeCallbacks((Runnable)this.historyRunnable);
            if (!this.textChangedPending) {
                this.textChangedPending = true;
                HistoryRunnable historyRunnable = this.historyRunnable;
                if (historyRunnable != null) {
                    EditText editText2 = editText;
                    historyRunnable.setText(editText2 instanceof AztecText ? ((AztecText)editText).toFormattedHtml() : (editText2 instanceof SourceViewEditText ? String.valueOf(((SourceViewEditText)editText).getText()) : ""));
                }
                HistoryRunnable historyRunnable2 = this.historyRunnable;
                if (historyRunnable2 != null) {
                    historyRunnable2.setEditText(editText);
                }
            }
            this.mainHandler.postDelayed((Runnable)this.historyRunnable, this.historyThrottleTime);
        }
    }

    protected final void doHandleHistory(@NotNull String inputBefore, @Nullable EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)inputBefore, (String)"inputBefore");
        this.textChangedPending = false;
        EditText editText2 = editText;
        String string2 = editText2 instanceof AztecText ? ((AztecText)editText).toFormattedHtml() : (this.inputLast = editText2 instanceof SourceViewEditText ? String.valueOf(((SourceViewEditText)editText).getText()) : "");
        if (Intrinsics.areEqual((Object)this.inputLast, (Object)inputBefore)) {
            return;
        }
        while (this.historyCursor != this.historyList.size() && this.historyCursor >= 0) {
            this.historyList.remove(this.historyCursor);
        }
        if (this.historyList.size() >= this.historySize) {
            this.historyList.remove(0);
            int n = this.historyCursor;
            this.historyCursor = n + -1;
        }
        this.historyList.add(inputBefore);
        this.historyCursor = this.historyList.size();
        this.updateActions();
    }

    public final void refreshLastHistoryItem(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        if (!this.historyEnabled || this.historyWorking) {
            return;
        }
        if (editText instanceof AztecText) {
            this.inputLast = ((AztecText)editText).toFormattedHtml();
        } else if (editText instanceof SourceViewEditText) {
            this.inputLast = String.valueOf(((SourceViewEditText)editText).getText());
        }
    }

    public final void redo(@NotNull EditText editText) {
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
            if (!this.redoValid()) {
                return;
            }
            this.historyWorking = true;
            editText.setFocusable(false);
            editText.setFocusableInTouchMode(false);
            if (this.historyCursor >= this.historyList.size() - 1) {
                this.historyCursor = this.historyList.size();
                if (editText instanceof AztecText) {
                    AztecText.fromHtml$default((AztecText)editText, this.inputLast, false, 2, null);
                } else if (editText instanceof SourceViewEditText) {
                    ((SourceViewEditText)editText).displayStyledHtml(this.inputLast);
                }
            } else {
                int n = this.historyCursor;
                this.historyCursor = n + 1;
                this.setTextFromHistory(editText);
            }
            this.historyWorking = false;
            editText.setFocusable(true);
            editText.setFocusableInTouchMode(true);
            editText.requestFocus();
            this.updateActions();
            IHistoryListener iHistoryListener = this.historyListener;
            if (iHistoryListener == null) break block6;
            iHistoryListener.onRedo();
        }
    }

    public final void undo(@NotNull EditText editText) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
            if (!this.undoValid()) {
                return;
            }
            this.historyWorking = true;
            int n = this.historyCursor;
            this.historyCursor = n + -1;
            editText.setFocusable(false);
            editText.setFocusableInTouchMode(false);
            this.setTextFromHistory(editText);
            this.historyWorking = false;
            editText.setFocusable(true);
            editText.setFocusableInTouchMode(true);
            editText.requestFocus();
            this.updateActions();
            IHistoryListener iHistoryListener = this.historyListener;
            if (iHistoryListener == null) break block1;
            iHistoryListener.onUndo();
        }
    }

    private final void setTextFromHistory(EditText editText) {
        if (editText instanceof AztecText) {
            AztecText aztecText = (AztecText)editText;
            String string2 = this.historyList.get(this.historyCursor);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"historyList[historyCursor]");
            AztecText.fromHtml$default(aztecText, string2, false, 2, null);
        } else if (editText instanceof SourceViewEditText) {
            SourceViewEditText sourceViewEditText = (SourceViewEditText)editText;
            String string3 = this.historyList.get(this.historyCursor);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"historyList[historyCursor]");
            sourceViewEditText.displayStyledHtml(string3);
        }
    }

    public final boolean redoValid() {
        if (!this.historyEnabled || this.historySize <= 0 || this.historyList.size() <= 0 || this.historyWorking) {
            return false;
        }
        return this.historyCursor < this.historyList.size();
    }

    public final boolean undoValid() {
        if (!this.historyEnabled || this.historySize <= 0 || this.historyWorking) {
            return false;
        }
        return this.historyList.size() > 0 && this.historyCursor > 0;
    }

    public final void clearHistory() {
        this.inputLast = "";
        this.historyList.clear();
    }

    public final void setHistoryListener(@NotNull IHistoryListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.historyListener = listener;
    }

    public final void updateActions() {
        block1: {
            IHistoryListener iHistoryListener = this.historyListener;
            if (iHistoryListener != null) {
                iHistoryListener.onRedoEnabled();
            }
            IHistoryListener iHistoryListener2 = this.historyListener;
            if (iHistoryListener2 == null) break block1;
            iHistoryListener2.onUndoEnabled();
        }
    }

    public final boolean getHistoryEnabled() {
        return this.historyEnabled;
    }

    public final int getHistorySize() {
        return this.historySize;
    }

    public History(boolean historyEnabled, int historySize) {
        this.historyEnabled = historyEnabled;
        this.historySize = historySize;
        this.historyList = new LinkedList();
        this.inputLast = "";
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.historyThrottleTime = 500L;
        this.historyRunnable = this.historyEnabled ? new HistoryRunnable(this) : (HistoryRunnable)null;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/wordpress/aztec/History$HistoryRunnable;", "Ljava/lang/Runnable;", "history", "Lorg/wordpress/aztec/History;", "(Lorg/wordpress/aztec/History;Lorg/wordpress/aztec/History;)V", "editText", "Landroid/widget/EditText;", "getEditText", "()Landroid/widget/EditText;", "setEditText", "(Landroid/widget/EditText;)V", "getHistory", "()Lorg/wordpress/aztec/History;", "text", "", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "run", "", "aztec_release"})
    public final class HistoryRunnable
    implements Runnable {
        @NotNull
        private String text;
        @Nullable
        private EditText editText;
        @NotNull
        private final History history;

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
            this.text = string2;
        }

        @Nullable
        public final EditText getEditText() {
            return this.editText;
        }

        public final void setEditText(@Nullable EditText editText) {
            this.editText = editText;
        }

        @Override
        public void run() {
            this.history.doHandleHistory(this.text, this.editText);
        }

        @NotNull
        public final History getHistory() {
            return this.history;
        }

        public HistoryRunnable(History history) {
            Intrinsics.checkParameterIsNotNull((Object)history, (String)"history");
            this.history = history;
            this.text = "";
        }
    }
}

