/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.source;

import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.text.Editable;
import android.text.Layout;
import android.text.style.ForegroundColorSpan;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.spans.IAztecAttributedSpan;
import org.wordpress.aztec.spans.IAztecParagraphStyle;
import org.wordpress.aztec.util.ColorConverter;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/wordpress/aztec/source/CssStyleFormatter;", "", "()V", "Companion", "aztec_release"})
public final class CssStyleFormatter {
    @NotNull
    private static final String STYLE_ATTRIBUTE = "style";
    @NotNull
    private static final String CSS_TEXT_DECORATION_ATTRIBUTE = "text-decoration";
    @NotNull
    private static final String CSS_TEXT_ALIGN_ATTRIBUTE = "text-align";
    @NotNull
    private static final String CSS_COLOR_ATTRIBUTE = "color";
    public static final Companion Companion = new Companion(null);

    static {
        STYLE_ATTRIBUTE = STYLE_ATTRIBUTE;
        CSS_TEXT_DECORATION_ATTRIBUTE = CSS_TEXT_DECORATION_ATTRIBUTE;
        CSS_TEXT_ALIGN_ATTRIBUTE = CSS_TEXT_ALIGN_ATTRIBUTE;
        CSS_COLOR_ATTRIBUTE = CSS_COLOR_ATTRIBUTE;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J&\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0016\u0010\"\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J(\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J(\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0016\u0010*\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006+"}, d2={"Lorg/wordpress/aztec/source/CssStyleFormatter$Companion;", "", "()V", "CSS_COLOR_ATTRIBUTE", "", "getCSS_COLOR_ATTRIBUTE", "()Ljava/lang/String;", "CSS_TEXT_ALIGN_ATTRIBUTE", "getCSS_TEXT_ALIGN_ATTRIBUTE", "CSS_TEXT_DECORATION_ATTRIBUTE", "getCSS_TEXT_DECORATION_ATTRIBUTE", "STYLE_ATTRIBUTE", "getSTYLE_ATTRIBUTE", "addStyleAttribute", "", "attributes", "Lorg/wordpress/aztec/AztecAttributes;", "styleAttributeName", "styleAttributeValue", "applyInlineStyleAttributes", "text", "Landroid/text/Editable;", "attributedSpan", "Lorg/wordpress/aztec/spans/IAztecAttributedSpan;", "start", "", "end", "containsStyleAttribute", "", "getMatcher", "Ljava/util/regex/Matcher;", "getPattern", "Ljava/util/regex/Pattern;", "styleAttr", "getStyleAttribute", "mergeStyleAttributes", "firstStyle", "secondStyle", "processAlignment", "blockSpan", "Lorg/wordpress/aztec/spans/IAztecParagraphStyle;", "processColor", "removeStyleAttribute", "aztec_release"})
    public static final class Companion {
        @NotNull
        public final String getSTYLE_ATTRIBUTE() {
            return STYLE_ATTRIBUTE;
        }

        @NotNull
        public final String getCSS_TEXT_DECORATION_ATTRIBUTE() {
            return CSS_TEXT_DECORATION_ATTRIBUTE;
        }

        @NotNull
        public final String getCSS_TEXT_ALIGN_ATTRIBUTE() {
            return CSS_TEXT_ALIGN_ATTRIBUTE;
        }

        @NotNull
        public final String getCSS_COLOR_ATTRIBUTE() {
            return CSS_COLOR_ATTRIBUTE;
        }

        public final void applyInlineStyleAttributes(@NotNull Editable text, @NotNull IAztecAttributedSpan attributedSpan, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)attributedSpan, (String)"attributedSpan");
            if (attributedSpan.getAttributes().hasAttribute(this.getSTYLE_ATTRIBUTE()) && start != end) {
                this.processColor(attributedSpan.getAttributes(), text, start, end);
                if (attributedSpan instanceof IAztecParagraphStyle) {
                    this.processAlignment((IAztecParagraphStyle)attributedSpan, text, start, end);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void processAlignment(IAztecParagraphStyle blockSpan, Editable text, int start, int end) {
            block4: {
                block5: {
                    alignment = this.getStyleAttribute(blockSpan.getAttributes(), this.getCSS_TEXT_ALIGN_ATTRIBUTE());
                    if (StringsKt.isBlank((CharSequence)alignment)) break block4;
                    direction = TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
                    isRtl = direction.isRtl((CharSequence)text, start, end - start);
                    var9_8 = alignment;
                    switch (var9_8.hashCode()) {
                        case -1364013995: {
                            if (!var9_8.equals("center")) ** break;
                            break;
                        }
                        case 108511772: {
                            if (!var9_8.equals("right")) ** break;
                            v0 = isRtl ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_OPPOSITE;
                            break block5;
                        }
                    }
                    v0 = Layout.Alignment.ALIGN_CENTER;
                    break block5;
                    v0 = isRtl == false ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_OPPOSITE;
                }
                align = v0;
                blockSpan.setAlign(align);
            }
        }

        private final Pattern getPattern(String styleAttr) {
            Pattern pattern = Pattern.compile("(?:;|\\A)" + styleAttr + ":(.+?)(?:;|$)", 10);
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\n       \u2026IVE or Pattern.MULTILINE)");
            return pattern;
        }

        private final Matcher getMatcher(AztecAttributes attributes, String styleAttributeName) {
            String string2 = attributes.getValue(this.getSTYLE_ATTRIBUTE());
            if (string2 == null) {
                string2 = "";
            }
            CharSequence charSequence = string2;
            String string3 = "\\s";
            string3 = new Regex(string3);
            String string4 = "";
            String style2 = string3.replace(charSequence, string4);
            Matcher matcher = this.getPattern(styleAttributeName).matcher(style2);
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher, (String)"getPattern(styleAttributeName).matcher(style)");
            return matcher;
        }

        private final void processColor(AztecAttributes attributes, Editable text, int start, int end) {
            int colorInt;
            String colorAttrValue = this.getStyleAttribute(attributes, this.getCSS_COLOR_ATTRIBUTE());
            if (!StringsKt.isBlank((CharSequence)colorAttrValue) && (colorInt = ColorConverter.Companion.getColorInt(colorAttrValue)) != -1) {
                text.setSpan((Object)new ForegroundColorSpan(colorInt), start, end, 33);
            }
        }

        public final boolean containsStyleAttribute(@NotNull AztecAttributes attributes, @NotNull String styleAttributeName) {
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            Intrinsics.checkParameterIsNotNull((Object)styleAttributeName, (String)"styleAttributeName");
            return attributes.hasAttribute(this.getSTYLE_ATTRIBUTE()) && this.getMatcher(attributes, styleAttributeName).find();
        }

        public final void removeStyleAttribute(@NotNull AztecAttributes attributes, @NotNull String styleAttributeName) {
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            Intrinsics.checkParameterIsNotNull((Object)styleAttributeName, (String)"styleAttributeName");
            if (attributes.hasAttribute(this.getSTYLE_ATTRIBUTE())) {
                String newStyle;
                Matcher m = this.getMatcher(attributes, styleAttributeName);
                String string2 = newStyle = m.replaceAll("");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"newStyle");
                if (StringsKt.isBlank((CharSequence)string2)) {
                    attributes.removeAttribute(this.getSTYLE_ATTRIBUTE());
                } else {
                    CharSequence charSequence = newStyle;
                    String string3 = ";";
                    string3 = new Regex(string3);
                    String string4 = "; ";
                    newStyle = string3.replace(charSequence, string4);
                    charSequence = newStyle;
                    string3 = ":";
                    string3 = new Regex(string3);
                    string4 = ": ";
                    newStyle = string3.replace(charSequence, string4);
                    charSequence = newStyle;
                    String string5 = this.getSTYLE_ATTRIBUTE();
                    AztecAttributes aztecAttributes = attributes;
                    CharSequence charSequence2 = charSequence;
                    if (charSequence2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string6 = ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
                    aztecAttributes.setValue(string5, string6);
                }
            }
        }

        @NotNull
        public final String getStyleAttribute(@NotNull AztecAttributes attributes, @NotNull String styleAttributeName) {
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            Intrinsics.checkParameterIsNotNull((Object)styleAttributeName, (String)"styleAttributeName");
            Matcher m = this.getMatcher(attributes, styleAttributeName);
            String styleAttributeValue = "";
            if (m.find()) {
                String string2 = m.group(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"m.group(1)");
                styleAttributeValue = string2;
            }
            return styleAttributeValue;
        }

        public final void addStyleAttribute(@NotNull AztecAttributes attributes, @NotNull String styleAttributeName, @NotNull String styleAttributeValue) {
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            Intrinsics.checkParameterIsNotNull((Object)styleAttributeName, (String)"styleAttributeName");
            Intrinsics.checkParameterIsNotNull((Object)styleAttributeValue, (String)"styleAttributeValue");
            String string2 = attributes.getValue(this.getSTYLE_ATTRIBUTE());
            if (string2 == null) {
                string2 = "";
            }
            String style2 = string2;
            CharSequence charSequence = style2;
            String string3 = charSequence;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            style2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            charSequence = style2;
            if (!(charSequence.length() == 0) && !StringsKt.endsWith$default((String)style2, (String)";", (boolean)false, (int)2, null)) {
                style2 = style2 + ";";
            }
            style2 = style2 + ' ' + styleAttributeName + ": " + styleAttributeValue + ';';
            charSequence = style2;
            String string4 = this.getSTYLE_ATTRIBUTE();
            AztecAttributes aztecAttributes = attributes;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string5 = ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
            aztecAttributes.setValue(string4, string5);
        }

        @NotNull
        public final String mergeStyleAttributes(@NotNull String firstStyle, @NotNull String secondStyle) {
            Intrinsics.checkParameterIsNotNull((Object)firstStyle, (String)"firstStyle");
            Intrinsics.checkParameterIsNotNull((Object)secondStyle, (String)"secondStyle");
            CharSequence charSequence = firstStyle;
            String style2 = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            charSequence = style2;
            if (!(charSequence.length() == 0) && !StringsKt.endsWith$default((String)style2, (String)";", (boolean)false, (int)2, null)) {
                style2 = style2 + "; ";
            }
            return style2 + secondStyle;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

