/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Paint;
import android.text.Editable;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.UpdateLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.IAztecBlockSpan;
import org.wordpress.aztec.spans.IAztecNestable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010%\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0006J\u001e\u0010&\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u0013\u00a8\u0006*"}, d2={"Lorg/wordpress/aztec/spans/AztecListSpan;", "Landroid/text/style/LeadingMarginSpan$Standard;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/UpdateLayout;", "Lorg/wordpress/aztec/spans/IAztecBlockSpan;", "nestingLevel", "", "verticalPadding", "align", "Landroid/text/Layout$Alignment;", "(IILandroid/text/Layout$Alignment;)V", "getAlign", "()Landroid/text/Layout$Alignment;", "setAlign", "(Landroid/text/Layout$Alignment;)V", "endBeforeBleed", "getEndBeforeBleed", "()I", "setEndBeforeBleed", "(I)V", "getNestingLevel", "setNestingLevel", "startBeforeCollapse", "getStartBeforeCollapse", "setStartBeforeCollapse", "getVerticalPadding", "setVerticalPadding", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "getIndexOfProcessedLine", "nestingDepth", "Landroid/text/Spanned;", "index", "nextIndex", "aztec_release"})
public abstract class AztecListSpan
extends LeadingMarginSpan.Standard
implements LineHeightSpan,
UpdateLayout,
IAztecBlockSpan {
    private int endBeforeBleed;
    private int startBeforeCollapse;
    private int nestingLevel;
    private int verticalPadding;
    @Nullable
    private Layout.Alignment align;

    @Override
    public int getEndBeforeBleed() {
        return this.endBeforeBleed;
    }

    @Override
    public void setEndBeforeBleed(int n) {
        this.endBeforeBleed = n;
    }

    @Override
    public int getStartBeforeCollapse() {
        return this.startBeforeCollapse;
    }

    @Override
    public void setStartBeforeCollapse(int n) {
        this.startBeforeCollapse = n;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        Spanned spanned = (Spanned)text;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.verticalPadding;
            fm.top -= this.verticalPadding;
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.verticalPadding;
            fm.bottom += this.verticalPadding;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getIndexOfProcessedLine(@NotNull CharSequence text, int end) {
        void $receiver$iv$iv;
        void $receiver$iv;
        boolean isValidListItem;
        Spanned textBeforeBeforeEnd;
        Spanned listText;
        block9: {
            boolean bl;
            void $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            int spanStart = ((Spanned)text).getSpanStart((Object)this);
            int spanEnd = ((Spanned)text).getSpanEnd((Object)this);
            CharSequence charSequence = text.subSequence(spanStart, spanEnd);
            if (charSequence == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
            }
            listText = (Spanned)charSequence;
            if (end - spanStart - 1 >= 0 && end - spanStart <= listText.length()) {
                boolean hasSublist;
                block8: {
                    boolean bl2;
                    void $receiver$iv3;
                    Object[] objectArray = listText.getSpans(end - spanStart - 1, end - spanStart, AztecListSpan.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"listText.getSpans(end - \u2026ztecListSpan::class.java)");
                    Object[] objectArray2 = objectArray;
                    for (void element$iv : $receiver$iv3) {
                        AztecListSpan it = (AztecListSpan)element$iv;
                        if (!(it.getNestingLevel() > this.getNestingLevel())) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = hasSublist = false;
                }
                if (hasSublist) {
                    return -1;
                }
            }
            CharSequence charSequence2 = listText.subSequence(0, end - spanStart);
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
            }
            textBeforeBeforeEnd = (Spanned)charSequence2;
            int startOfLine = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)textBeforeBeforeEnd), (char)Constants.INSTANCE.getNEWLINE(), (int)0, (boolean)false, (int)6, null) + 1;
            Object[] objectArray = listText.getSpans(0, listText.length(), AztecListItemSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"listText.getSpans(0, lis\u2026ListItemSpan::class.java)");
            Object[] objectArray3 = objectArray;
            for (void element$iv : $receiver$iv2) {
                AztecListItemSpan it = (AztecListItemSpan)element$iv;
                if (!(it.getNestingLevel() == this.getNestingLevel() + 1 && listText.getSpanStart((Object)it) == startOfLine)) continue;
                bl = true;
                break block9;
            }
            bl = isValidListItem = false;
        }
        if (!isValidListItem) {
            return -1;
        }
        int checkEnd = Math.min(textBeforeBeforeEnd.length() + 1, listText.length());
        Object[] objectArray = listText.getSpans(0, checkEnd, AztecListItemSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"listText.getSpans(0, che\u2026ListItemSpan::class.java)");
        Object[] objectArray4 = objectArray;
        void element$iv = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            AztecListItemSpan it = (AztecListItemSpan)element$iv$iv;
            if (!(it.getNestingLevel() == this.getNestingLevel() + 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size();
    }

    public final int nestingDepth(@NotNull Spanned text, int index, int nextIndex) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int finalNextIndex = nextIndex > text.length() ? index : nextIndex;
        return IAztecNestable.Companion.getNestingLevelAt(text, index, finalNextIndex);
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    public final int getVerticalPadding() {
        return this.verticalPadding;
    }

    public final void setVerticalPadding(int n) {
        this.verticalPadding = n;
    }

    @Override
    @Nullable
    public Layout.Alignment getAlign() {
        return this.align;
    }

    @Override
    public void setAlign(@Nullable Layout.Alignment alignment) {
        this.align = alignment;
    }

    public AztecListSpan(int nestingLevel, int verticalPadding, @Nullable Layout.Alignment align) {
        super(0);
        this.nestingLevel = nestingLevel;
        this.verticalPadding = verticalPadding;
        this.align = align;
        this.endBeforeBleed = -1;
        this.startBeforeCollapse = -1;
    }

    public /* synthetic */ AztecListSpan(int n, int n2, Layout.Alignment alignment, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            alignment = null;
        }
        this(n, n2, alignment);
    }

    @Override
    @NotNull
    public Layout.Alignment getAlignment() {
        return IAztecBlockSpan.DefaultImpls.getAlignment(this);
    }

    @Override
    public boolean shouldParseAlignmentToHtml() {
        return IAztecBlockSpan.DefaultImpls.shouldParseAlignmentToHtml(this);
    }

    @Override
    @NotNull
    public String getStartTag() {
        return IAztecBlockSpan.DefaultImpls.getStartTag(this);
    }

    @Override
    @NotNull
    public String getEndTag() {
        return IAztecBlockSpan.DefaultImpls.getEndTag(this);
    }

    @Override
    public void applyInlineStyleAttributes(@NotNull Editable output, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        IAztecBlockSpan.DefaultImpls.applyInlineStyleAttributes(this, output, start, end);
    }

    @Override
    public void clearStartBeforeCollapse() {
        IAztecBlockSpan.DefaultImpls.clearStartBeforeCollapse(this);
    }

    @Override
    public boolean hasCollapsed() {
        return IAztecBlockSpan.DefaultImpls.hasCollapsed(this);
    }

    @Override
    public void clearEndBeforeBleed() {
        IAztecBlockSpan.DefaultImpls.clearEndBeforeBleed(this);
    }

    @Override
    public boolean hasBled() {
        return IAztecBlockSpan.DefaultImpls.hasBled(this);
    }
}

