/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.handlers;

import android.text.Spannable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.handlers.BlockHandler;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.watchers.TextDeleter;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/wordpress/aztec/handlers/HeadingHandler;", "Lorg/wordpress/aztec/handlers/BlockHandler;", "Lorg/wordpress/aztec/spans/AztecHeadingSpan;", "()V", "handleEndOfBufferMarker", "", "handleNewlineAtEmptyBody", "handleNewlineAtEmptyLineAtBlockEnd", "handleNewlineAtStartOfBlock", "handleNewlineInBody", "Companion", "aztec_release"})
public final class HeadingHandler
extends BlockHandler<AztecHeadingSpan> {
    public static final Companion Companion = new Companion(null);

    @Override
    public void handleNewlineAtStartOfBlock() {
        this.getBlock().setStart(this.getNewlineIndex() + 1);
    }

    @Override
    public void handleNewlineAtEmptyLineAtBlockEnd() {
        this.getBlock().remove();
        TextDeleter.Companion.mark(this.getText(), this.getNewlineIndex(), this.getNewlineIndex() + 1);
    }

    @Override
    public void handleNewlineAtEmptyBody() {
        this.getBlock().remove();
        TextDeleter.Companion.mark(this.getText(), this.getNewlineIndex(), this.getNewlineIndex() + 1);
    }

    @Override
    public void handleNewlineInBody() {
        boolean atEndOfBlock;
        boolean bl = atEndOfBlock = this.getNewlineIndex() == this.getBlock().getEnd() - 2 && (this.getText().charAt(this.getBlock().getEnd() - 1) == Constants.INSTANCE.getNEWLINE() || this.getText().charAt(this.getBlock().getEnd() - 1) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER()) || this.getNewlineIndex() == this.getText().length() - 1;
        if (!atEndOfBlock) {
            Companion.cloneHeading(this.getText(), (AztecHeadingSpan)this.getBlock().getSpan(), this.getNewlineIndex() + 1, this.getBlock().getEnd());
        }
        this.getBlock().setEnd(this.getNewlineIndex() + 1);
    }

    @Override
    public void handleEndOfBufferMarker() {
        if (this.getBlock().getStart() == this.getMarkerIndex()) {
            return;
        }
        this.getBlock().setEnd(this.getMarkerIndex());
    }

    public HeadingHandler() {
        super(AztecHeadingSpan.class);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/wordpress/aztec/handlers/HeadingHandler$Companion;", "", "()V", "cloneHeading", "", "text", "Landroid/text/Spannable;", "block", "Lorg/wordpress/aztec/spans/AztecHeadingSpan;", "start", "", "end", "aztec_release"})
    public static final class Companion {
        public final void cloneHeading(@NotNull Spannable text, @NotNull AztecHeadingSpan block, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            BlockHandler.Companion.set(text, new AztecHeadingSpan(block.getNestingLevel(), block.getTextFormat(), block.getAttributes(), null, null, 24, null), start, end);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

