/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers.event.sequence;

import android.text.SpannableStringBuilder;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.android.util.AppLog;
import org.wordpress.aztec.spans.AztecCodeSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.AztecPreformatSpan;
import org.wordpress.aztec.watchers.event.sequence.EventSequence;
import org.wordpress.aztec.watchers.event.sequence.ObservationQueue;
import org.wordpress.aztec.watchers.event.text.BeforeTextChangedEventData;
import org.wordpress.aztec.watchers.event.text.TextWatcherEvent;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00142\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u0014\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lorg/wordpress/aztec/watchers/event/sequence/UserOperationEvent;", "", "sequence", "Lorg/wordpress/aztec/watchers/event/sequence/EventSequence;", "Lorg/wordpress/aztec/watchers/event/text/TextWatcherEvent;", "(Lorg/wordpress/aztec/watchers/event/sequence/EventSequence;)V", "getSequence", "()Lorg/wordpress/aztec/watchers/event/sequence/EventSequence;", "setSequence", "addSequenceStep", "", "event", "buildReplacementEventWithSequenceData", "clear", "isEventFoundWithinABlock", "", "data", "Lorg/wordpress/aztec/watchers/event/text/BeforeTextChangedEventData;", "isFound", "resultType", "Lorg/wordpress/aztec/watchers/event/sequence/UserOperationEvent$ObservedOperationResultType;", "isUserOperationObservedInSequence", "isUserOperationPartiallyObservedInSequence", "needsClear", "ObservedOperationResultType", "aztec_release"})
public abstract class UserOperationEvent {
    @NotNull
    private EventSequence<TextWatcherEvent> sequence;

    public final boolean isFound(@NotNull ObservedOperationResultType resultType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)resultType), (String)"resultType");
        return Intrinsics.areEqual((Object)((Object)resultType), (Object)((Object)ObservedOperationResultType.SEQUENCE_FOUND));
    }

    public final boolean needsClear(@NotNull ObservedOperationResultType resultType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)resultType), (String)"resultType");
        return Intrinsics.areEqual((Object)((Object)resultType), (Object)((Object)ObservedOperationResultType.SEQUENCE_FOUND_CLEAR_QUEUE));
    }

    public final void addSequenceStep(@NotNull TextWatcherEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.sequence.add(event);
    }

    public final void clear() {
        this.sequence.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isUserOperationPartiallyObservedInSequence(@NotNull EventSequence<TextWatcherEvent> sequence) {
        Intrinsics.checkParameterIsNotNull(sequence, (String)"sequence");
        int n = 0;
        int n2 = ((Collection)sequence).size();
        while (n < n2) {
            void i;
            TextWatcherEvent eventHolder = (TextWatcherEvent)this.sequence.get((int)i);
            TextWatcherEvent observableEvent = (TextWatcherEvent)sequence.get((int)i);
            if (i > 0) {
                long timestampForPreviousEvent = ((TextWatcherEvent)sequence.get((int)(i - true))).getTimestamp();
                long timeDistance = observableEvent.getTimestamp() - timestampForPreviousEvent;
                if (timeDistance > (long)ObservationQueue.Companion.getMAXIMUM_TIME_BETWEEN_EVENTS_IN_PATTERN_MS()) {
                    return false;
                }
            }
            eventHolder.setBeforeEventData(observableEvent.getBeforeEventData());
            eventHolder.setOnEventData(observableEvent.getOnEventData());
            eventHolder.setAfterEventData(observableEvent.getAfterEventData());
            if (!eventHolder.testFitsBeforeOnAndAfter()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean isEventFoundWithinABlock(@NotNull BeforeTextChangedEventData data) {
        boolean insideHeading;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int inputStart = data.getStart() + data.getCount();
        int inputEnd = data.getStart() + data.getCount() + 1;
        SpannableStringBuilder spannableStringBuilder = data.getTextBefore();
        if (spannableStringBuilder == null) {
            Intrinsics.throwNpe();
        }
        SpannableStringBuilder text = spannableStringBuilder;
        Object[] objectArray2 = text.getSpans(inputStart, inputEnd, AztecListItemSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"text.getSpans(inputStart\u2026ListItemSpan::class.java)");
        Object[] objectArray3 = objectArray = objectArray2;
        boolean isInsideList = !(objectArray3.length == 0);
        Object[] objectArray4 = text.getSpans(inputStart, inputEnd, AztecPreformatSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray4, (String)"text.getSpans(inputStart\u2026reformatSpan::class.java)");
        Object[] objectArray5 = objectArray3 = objectArray4;
        boolean isInsidePre = !(objectArray5.length == 0);
        Object[] objectArray6 = text.getSpans(inputStart, inputEnd, AztecCodeSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray6, (String)"text.getSpans(inputStart\u2026ztecCodeSpan::class.java)");
        Object[] objectArray7 = objectArray5 = objectArray6;
        boolean isInsideCode = !(objectArray7.length == 0);
        Object[] objectArray8 = text.getSpans(inputStart, inputEnd, AztecHeadingSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray8, (String)"text.getSpans(inputStart\u2026cHeadingSpan::class.java)");
        Object[] objectArray9 = objectArray7 = objectArray8;
        boolean bl = insideHeading = !(objectArray9.length == 0);
        if (insideHeading && text.length() > inputEnd && text.charAt(inputEnd) == '\n') {
            insideHeading = false;
        }
        AppLog.d((AppLog.T)AppLog.T.EDITOR, (String)("SEQUENCE OBSERVED COMPLETELY, IS IT WITHIN BLOCK?: " + (isInsideList || insideHeading || isInsidePre || isInsideCode)));
        return isInsideList || insideHeading || isInsidePre || isInsideCode;
    }

    @NotNull
    public abstract ObservedOperationResultType isUserOperationObservedInSequence(@NotNull EventSequence<TextWatcherEvent> var1);

    @NotNull
    public abstract TextWatcherEvent buildReplacementEventWithSequenceData(@NotNull EventSequence<TextWatcherEvent> var1);

    @NotNull
    public final EventSequence<TextWatcherEvent> getSequence() {
        return this.sequence;
    }

    public final void setSequence(@NotNull EventSequence<TextWatcherEvent> eventSequence) {
        Intrinsics.checkParameterIsNotNull(eventSequence, (String)"<set-?>");
        this.sequence = eventSequence;
    }

    public UserOperationEvent(@NotNull EventSequence<TextWatcherEvent> sequence) {
        Intrinsics.checkParameterIsNotNull(sequence, (String)"sequence");
        this.sequence = sequence;
    }

    public /* synthetic */ UserOperationEvent(EventSequence eventSequence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            eventSequence = new EventSequence();
        }
        this(eventSequence);
    }

    public UserOperationEvent() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/wordpress/aztec/watchers/event/sequence/UserOperationEvent$ObservedOperationResultType;", "", "(Ljava/lang/String;I)V", "SEQUENCE_FOUND", "SEQUENCE_NOT_FOUND", "SEQUENCE_FOUND_CLEAR_QUEUE", "aztec_release"})
    public static final class ObservedOperationResultType
    extends Enum<ObservedOperationResultType> {
        public static final /* enum */ ObservedOperationResultType SEQUENCE_FOUND;
        public static final /* enum */ ObservedOperationResultType SEQUENCE_NOT_FOUND;
        public static final /* enum */ ObservedOperationResultType SEQUENCE_FOUND_CLEAR_QUEUE;
        private static final /* synthetic */ ObservedOperationResultType[] $VALUES;

        static {
            ObservedOperationResultType[] observedOperationResultTypeArray = new ObservedOperationResultType[3];
            ObservedOperationResultType[] observedOperationResultTypeArray2 = observedOperationResultTypeArray;
            observedOperationResultTypeArray[0] = SEQUENCE_FOUND = new ObservedOperationResultType();
            observedOperationResultTypeArray[1] = SEQUENCE_NOT_FOUND = new ObservedOperationResultType();
            observedOperationResultTypeArray[2] = SEQUENCE_FOUND_CLEAR_QUEUE = new ObservedOperationResultType();
            $VALUES = observedOperationResultTypeArray;
        }

        public static ObservedOperationResultType[] values() {
            return (ObservedOperationResultType[])$VALUES.clone();
        }

        public static ObservedOperationResultType valueOf(String string2) {
            return Enum.valueOf(ObservedOperationResultType.class, string2);
        }
    }
}

