/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.android.util.AppLog;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.AztecPart;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.AztecTextFormat;
import org.wordpress.aztec.Constants;
import org.wordpress.aztec.ITextFormat;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.spans.AztecCodeSpan;
import org.wordpress.aztec.spans.AztecStrikethroughSpan;
import org.wordpress.aztec.spans.AztecStyleBoldSpan;
import org.wordpress.aztec.spans.AztecStyleItalicSpan;
import org.wordpress.aztec.spans.AztecStyleSpan;
import org.wordpress.aztec.spans.AztecUnderlineSpan;
import org.wordpress.aztec.spans.IAztecInlineSpan;
import org.wordpress.aztec.util.AztecLog;
import org.wordpress.aztec.watchers.TextChangedEvent;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J \u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014J\u0016\u0010 \u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u001e\u0010!\u001a\u00020\u00142\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u000e\u0010!\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010$\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eJ\"\u0010%\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eJ\"\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00142\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010(\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010)\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006+"}, d2={"Lorg/wordpress/aztec/formatting/InlineFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "codeStyle", "Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "(Lorg/wordpress/aztec/AztecText;Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;)V", "getCodeStyle", "()Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "applyInlineStyle", "", "textFormat", "Lorg/wordpress/aztec/ITextFormat;", "start", "", "end", "attrs", "Lorg/wordpress/aztec/AztecAttributes;", "applySpan", "span", "Lorg/wordpress/aztec/spans/IAztecInlineSpan;", "type", "clearInlineStyles", "ignoreSelectedStyles", "", "containsInlineStyle", "handleInlineStyling", "textChangedEvent", "Lorg/wordpress/aztec/watchers/TextChangedEvent;", "isSameInlineSpanType", "firstSpan", "secondSpan", "joinStyleSpans", "makeInlineSpan", "spanType", "Ljava/lang/Class;", "removeInlineCssStyle", "removeInlineStyle", "spanToRemove", "spanToTextFormat", "toggle", "tryRemoveLeadingInlineStyle", "CodeStyle", "aztec_release"})
public final class InlineFormatter
extends AztecFormatter {
    @NotNull
    private final CodeStyle codeStyle;

    public final void toggle(@NotNull ITextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        if (!InlineFormatter.containsInlineStyle$default(this, textFormat, 0, 0, 6, null)) {
            InlineFormatter.applyInlineStyle$default(this, textFormat, 0, 0, null, 14, null);
        } else {
            InlineFormatter.removeInlineStyle$default(this, textFormat, 0, 0, 6, null);
        }
    }

    public final void handleInlineStyling(@NotNull TextChangedEvent textChangedEvent) {
        Intrinsics.checkParameterIsNotNull((Object)textChangedEvent, (String)"textChangedEvent");
        if (textChangedEvent.isEndOfBufferMarker()) {
            return;
        }
        this.clearInlineStyles(textChangedEvent.getInputStart(), textChangedEvent.getInputEnd(), textChangedEvent.isNewLine());
        if (textChangedEvent.isNewLine()) {
            return;
        }
        if (this.getEditor().formattingIsApplied()) {
            for (ITextFormat item : this.getEditor().getSelectedStyles()) {
                ITextFormat iTextFormat = item;
                if (!Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_BOLD) && !Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ITALIC) && !Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_STRIKETHROUGH) && !Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNDERLINE) && !Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_CODE)) continue;
                ITextFormat iTextFormat2 = item;
                Intrinsics.checkExpressionValueIsNotNull((Object)iTextFormat2, (String)"item");
                InlineFormatter.applyInlineStyle$default(this, iTextFormat2, textChangedEvent.getInputStart(), textChangedEvent.getInputEnd(), null, 8, null);
            }
        }
        this.getEditor().setFormattingChangesApplied();
    }

    /*
     * WARNING - void declaration
     */
    private final void clearInlineStyles(int start, int end, boolean ignoreSelectedStyles) {
        int newStart;
        int n = newStart = start > end ? end : start;
        if (start > end) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object[] objectArray = this.getEditableText().getSpans(newStart, end, IAztecInlineSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(ne\u2026ecInlineSpan::class.java)");
            Object[] objectArray2 = objectArray;
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                IAztecInlineSpan it = (IAztecInlineSpan)element$iv$iv;
                if (!(this.getEditableText().getSpanStart((Object)it) == this.getEditableText().getSpanEnd((Object)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                this.getEditableText().removeSpan((Object)it);
            }
            return;
        }
        Object[] objectArray = this.getEditableText().getSpans(newStart, end, IAztecInlineSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(ne\u2026ecInlineSpan::class.java)");
        for (Object element$iv : objectArray) {
            IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
            Iterable iterable = this.getEditor().getSelectedStyles();
            IAztecInlineSpan iAztecInlineSpan = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
            if (CollectionsKt.contains((Iterable)iterable, (Object)this.spanToTextFormat(iAztecInlineSpan)) && !ignoreSelectedStyles && (newStart != 0 || end != 0) && (newStart <= end || this.getEditableText().length() <= end || this.getEditableText().charAt(end) != '\n')) continue;
            this.removeInlineStyle(it, newStart, end);
        }
    }

    public final void applyInlineStyle(@NotNull ITextFormat textFormat, int start, int end, @NotNull AztecAttributes attrs) {
        IAztecInlineSpan it;
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        IAztecInlineSpan spanToApply = this.makeInlineSpan(textFormat);
        spanToApply.setAttributes(attrs);
        if (start >= end) {
            return;
        }
        IAztecInlineSpan precedingSpan = null;
        IAztecInlineSpan followingSpan = null;
        if (start >= 1) {
            IAztecInlineSpan[] previousSpans = (IAztecInlineSpan[])this.getEditableText().getSpans(start - 1, start, IAztecInlineSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)previousSpans, (String)"previousSpans");
            for (Object element$iv : (Object[])previousSpans) {
                IAztecInlineSpan iAztecInlineSpan = it = (IAztecInlineSpan)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToApply)) continue;
                precedingSpan = it;
            }
            if (precedingSpan != null) {
                int spanStart = this.getEditableText().getSpanStart((Object)precedingSpan);
                int spanEnd = this.getEditableText().getSpanEnd((Object)precedingSpan);
                if (spanEnd > start) {
                    IAztecInlineSpan iAztecInlineSpan = precedingSpan;
                    if (iAztecInlineSpan == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.IAztecInlineSpan");
                    }
                    iAztecInlineSpan.applyInlineStyleAttributes(this.getEditableText(), start, end);
                    return;
                }
                IAztecInlineSpan iAztecInlineSpan = precedingSpan;
                if (iAztecInlineSpan == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.IAztecInlineSpan");
                }
                this.applySpan(iAztecInlineSpan, spanStart, end, 33);
            }
        }
        if (this.getEditor().length() > end) {
            IAztecInlineSpan[] nextSpans = (IAztecInlineSpan[])this.getEditableText().getSpans(end, end + 1, IAztecInlineSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)nextSpans, (String)"nextSpans");
            for (Object element$iv : (Object[])nextSpans) {
                IAztecInlineSpan iAztecInlineSpan = it = (IAztecInlineSpan)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToApply)) continue;
                followingSpan = it;
            }
            if (followingSpan != null) {
                int spanEnd = this.getEditableText().getSpanEnd((Object)followingSpan);
                IAztecInlineSpan iAztecInlineSpan = followingSpan;
                if (iAztecInlineSpan == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.IAztecInlineSpan");
                }
                this.applySpan(iAztecInlineSpan, start, spanEnd, 33);
                this.getEditableText().setSpan((Object)followingSpan, start, spanEnd, 33);
            }
        }
        if (precedingSpan == null && followingSpan == null) {
            IAztecInlineSpan existingSpanOfSameStyle = null;
            IAztecInlineSpan[] spans = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
            for (Object element$iv : (Object[])spans) {
                IAztecInlineSpan it2;
                IAztecInlineSpan iAztecInlineSpan = it2 = (IAztecInlineSpan)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToApply)) continue;
                existingSpanOfSameStyle = it2;
            }
            if (existingSpanOfSameStyle != null) {
                this.getEditableText().removeSpan((Object)existingSpanOfSameStyle);
                IAztecInlineSpan iAztecInlineSpan = existingSpanOfSameStyle;
                if (iAztecInlineSpan == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.IAztecInlineSpan");
                }
                iAztecInlineSpan.setAttributes(attrs);
                IAztecInlineSpan iAztecInlineSpan2 = existingSpanOfSameStyle;
                if (iAztecInlineSpan2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.spans.IAztecInlineSpan");
                }
                this.applySpan(iAztecInlineSpan2, start, end, 33);
            } else {
                this.applySpan(spanToApply, start, end, 33);
            }
        }
        this.joinStyleSpans(start, end);
    }

    public static /* bridge */ /* synthetic */ void applyInlineStyle$default(InlineFormatter inlineFormatter, ITextFormat iTextFormat, int n, int n2, AztecAttributes aztecAttributes, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        if ((n3 & 8) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        inlineFormatter.applyInlineStyle(iTextFormat, n, n2, aztecAttributes);
    }

    private final void applySpan(IAztecInlineSpan span, int start, int end, int type) {
        if (start > end) {
            AztecLog.ExternalLogger extLogger = this.getEditor().getExternalLogger();
            if (extLogger != null) {
                extLogger.log("InlineFormatter.applySpan - setSpan has end before start. Start:" + start + " End:" + end);
                extLogger.log("Logging the whole content" + AztecText.toPlainHtml$default(this.getEditor(), false, 1, null));
            }
            AppLog.w((AppLog.T)AppLog.T.EDITOR, (String)("InlineFormatter.applySpan - setSpan has end before start. Start:" + start + " End:" + end));
            AppLog.w((AppLog.T)AppLog.T.EDITOR, (String)("Logging the whole content" + AztecText.toPlainHtml$default(this.getEditor(), false, 1, null)));
            return;
        }
        this.getEditableText().setSpan((Object)span, start, end, type);
        span.applyInlineStyleAttributes(this.getEditableText(), start, end);
    }

    @Nullable
    public final ITextFormat spanToTextFormat(@NotNull IAztecInlineSpan span) {
        Intrinsics.checkParameterIsNotNull((Object)span, (String)"span");
        Class<?> clazz = span.getClass();
        if (Intrinsics.areEqual(clazz, AztecStyleBoldSpan.class)) {
            return AztecTextFormat.FORMAT_BOLD;
        }
        if (Intrinsics.areEqual(clazz, AztecStyleItalicSpan.class)) {
            return AztecTextFormat.FORMAT_ITALIC;
        }
        if (Intrinsics.areEqual(clazz, AztecStrikethroughSpan.class)) {
            return AztecTextFormat.FORMAT_STRIKETHROUGH;
        }
        if (Intrinsics.areEqual(clazz, AztecUnderlineSpan.class)) {
            return AztecTextFormat.FORMAT_UNDERLINE;
        }
        if (Intrinsics.areEqual(clazz, AztecCodeSpan.class)) {
            return AztecTextFormat.FORMAT_CODE;
        }
        return null;
    }

    public final void removeInlineStyle(@NotNull IAztecInlineSpan spanToRemove, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)spanToRemove, (String)"spanToRemove");
        ITextFormat iTextFormat = this.spanToTextFormat(spanToRemove);
        if (iTextFormat == null) {
            return;
        }
        ITextFormat textFormat = iTextFormat;
        IAztecInlineSpan[] spans = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
        ArrayList<AztecPart> list = new ArrayList<AztecPart>();
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        for (Object element$iv : (Object[])spans) {
            IAztecInlineSpan it;
            IAztecInlineSpan iAztecInlineSpan = it = (IAztecInlineSpan)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
            if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToRemove)) continue;
            list.add(new AztecPart(this.getEditableText().getSpanStart((Object)it), this.getEditableText().getSpanEnd((Object)it), it.getAttributes()));
            this.getEditableText().removeSpan((Object)it);
        }
        InlineFormatter.removeInlineCssStyle$default(this, 0, 0, 3, null);
        Iterable $receiver$iv = list;
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            AztecPart it = (AztecPart)element$iv;
            if (!it.isValid()) continue;
            if (it.getStart() < start) {
                this.applyInlineStyle(textFormat, it.getStart(), start, it.getAttr());
            }
            if (it.getEnd() <= end) continue;
            this.applyInlineStyle(textFormat, end, it.getEnd(), it.getAttr());
        }
        this.joinStyleSpans(start, end);
    }

    public static /* bridge */ /* synthetic */ void removeInlineStyle$default(InlineFormatter inlineFormatter, IAztecInlineSpan iAztecInlineSpan, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        inlineFormatter.removeInlineStyle(iAztecInlineSpan, n, n2);
    }

    public final void removeInlineCssStyle(int start, int end) {
        ForegroundColorSpan[] spans = (ForegroundColorSpan[])this.getEditableText().getSpans(start, end, ForegroundColorSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)spans, (String)"spans");
        for (Object element$iv : (Object[])spans) {
            ForegroundColorSpan it = (ForegroundColorSpan)element$iv;
            this.getEditableText().removeSpan((Object)it);
        }
    }

    public static /* bridge */ /* synthetic */ void removeInlineCssStyle$default(InlineFormatter inlineFormatter, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 2) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        inlineFormatter.removeInlineCssStyle(n, n2);
    }

    public final void removeInlineStyle(@NotNull ITextFormat textFormat, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        this.removeInlineStyle(this.makeInlineSpan(textFormat), start, end);
    }

    public static /* bridge */ /* synthetic */ void removeInlineStyle$default(InlineFormatter inlineFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        inlineFormatter.removeInlineStyle(iTextFormat, n, n2);
    }

    public final boolean isSameInlineSpanType(@NotNull IAztecInlineSpan firstSpan, @NotNull IAztecInlineSpan secondSpan) {
        Intrinsics.checkParameterIsNotNull((Object)firstSpan, (String)"firstSpan");
        Intrinsics.checkParameterIsNotNull((Object)secondSpan, (String)"secondSpan");
        if (Intrinsics.areEqual(firstSpan.getClass(), secondSpan.getClass())) {
            if (firstSpan instanceof StyleSpan && secondSpan instanceof StyleSpan) {
                return ((StyleSpan)firstSpan).getStyle() == ((StyleSpan)secondSpan).getStyle();
            }
            return true;
        }
        return false;
    }

    public final void joinStyleSpans(int start, int end) {
        IAztecInlineSpan outerSpan;
        int inSelectionSpanStart;
        int inSelectionSpanEnd;
        IAztecInlineSpan innerSpan;
        IAztecInlineSpan[] spansInSelection;
        if (start > 1) {
            spansInSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
            IAztecInlineSpan[] spansBeforeSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(start - 1, start, IAztecInlineSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)spansInSelection, (String)"spansInSelection");
            for (Object element$iv : (Object[])spansInSelection) {
                innerSpan = (IAztecInlineSpan)element$iv;
                inSelectionSpanEnd = this.getEditableText().getSpanEnd((Object)innerSpan);
                inSelectionSpanStart = this.getEditableText().getSpanStart((Object)innerSpan);
                if (inSelectionSpanEnd == -1 || inSelectionSpanStart == -1) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)spansBeforeSelection, (String)"spansBeforeSelection");
                for (Object element$iv2 : (Object[])spansBeforeSelection) {
                    outerSpan = (IAztecInlineSpan)element$iv2;
                    int outerSpanStart = this.getEditableText().getSpanStart((Object)outerSpan);
                    IAztecInlineSpan iAztecInlineSpan = innerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"innerSpan");
                    IAztecInlineSpan iAztecInlineSpan2 = outerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan2, (String)"outerSpan");
                    if (!this.isSameInlineSpanType(iAztecInlineSpan, iAztecInlineSpan2) || inSelectionSpanEnd < outerSpanStart) continue;
                    this.getEditableText().removeSpan((Object)outerSpan);
                    this.applySpan(innerSpan, outerSpanStart, inSelectionSpanEnd, 33);
                }
            }
        }
        if (this.getEditor().length() > end) {
            spansInSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
            IAztecInlineSpan[] spansAfterSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(end, end + 1, IAztecInlineSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)spansInSelection, (String)"spansInSelection");
            for (Object element$iv : (Object[])spansInSelection) {
                innerSpan = (IAztecInlineSpan)element$iv;
                inSelectionSpanEnd = this.getEditableText().getSpanEnd((Object)innerSpan);
                inSelectionSpanStart = this.getEditableText().getSpanStart((Object)innerSpan);
                if (inSelectionSpanEnd == -1 || inSelectionSpanStart == -1) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)spansAfterSelection, (String)"spansAfterSelection");
                for (Object element$iv2 : (Object[])spansAfterSelection) {
                    outerSpan = (IAztecInlineSpan)element$iv2;
                    int outerSpanEnd = this.getEditableText().getSpanEnd((Object)outerSpan);
                    IAztecInlineSpan iAztecInlineSpan = innerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"innerSpan");
                    IAztecInlineSpan iAztecInlineSpan3 = outerSpan;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan3, (String)"outerSpan");
                    if (!this.isSameInlineSpanType(iAztecInlineSpan, iAztecInlineSpan3) || outerSpanEnd < inSelectionSpanStart) continue;
                    this.getEditableText().removeSpan((Object)outerSpan);
                    this.applySpan(innerSpan, inSelectionSpanStart, outerSpanEnd, 33);
                }
            }
        }
        spansInSelection = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
        IAztecInlineSpan[] spansToUse = (IAztecInlineSpan[])this.getEditableText().getSpans(start, end, IAztecInlineSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)spansInSelection, (String)"spansInSelection");
        for (Object element$iv : (Object[])spansInSelection) {
            IAztecInlineSpan appliedSpan = (IAztecInlineSpan)element$iv;
            int spanStart = this.getEditableText().getSpanStart((Object)appliedSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)appliedSpan);
            IAztecInlineSpan neighbourSpan = null;
            Intrinsics.checkExpressionValueIsNotNull((Object)spansToUse, (String)"spansToUse");
            for (Object element$iv3 : (Object[])spansToUse) {
                IAztecInlineSpan it = (IAztecInlineSpan)element$iv3;
                int aSpanStart = this.getEditableText().getSpanStart((Object)it);
                int aSpanEnd = this.getEditableText().getSpanEnd((Object)it);
                IAztecInlineSpan iAztecInlineSpan = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                IAztecInlineSpan iAztecInlineSpan4 = appliedSpan;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan4, (String)"appliedSpan");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, iAztecInlineSpan4) || aSpanStart != spanEnd && aSpanEnd != spanStart) continue;
                neighbourSpan = it;
            }
            if (neighbourSpan == null) continue;
            int neighbourSpanStart = this.getEditableText().getSpanStart((Object)neighbourSpan);
            int neighbourSpanEnd = this.getEditableText().getSpanEnd((Object)neighbourSpan);
            if (neighbourSpanStart == -1 || neighbourSpanEnd == -1) continue;
            if (spanStart == neighbourSpanEnd) {
                IAztecInlineSpan iAztecInlineSpan = appliedSpan;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"appliedSpan");
                this.applySpan(iAztecInlineSpan, neighbourSpanStart, spanEnd, 33);
            } else if (spanEnd == neighbourSpanStart) {
                IAztecInlineSpan iAztecInlineSpan = appliedSpan;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"appliedSpan");
                this.applySpan(iAztecInlineSpan, spanStart, neighbourSpanEnd, 33);
            }
            this.getEditableText().removeSpan((Object)neighbourSpan);
        }
    }

    @NotNull
    public final IAztecInlineSpan makeInlineSpan(@NotNull ITextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        ITextFormat iTextFormat = textFormat;
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_BOLD)) {
            return new AztecStyleBoldSpan(null, 1, null);
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_ITALIC)) {
            return new AztecStyleItalicSpan(null, 1, null);
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_STRIKETHROUGH)) {
            return new AztecStrikethroughSpan(null, null, 3, null);
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_UNDERLINE)) {
            return new AztecUnderlineSpan(false, null, 3, null);
        }
        if (Intrinsics.areEqual((Object)iTextFormat, (Object)AztecTextFormat.FORMAT_CODE)) {
            return new AztecCodeSpan(this.codeStyle, null, 2, null);
        }
        return new AztecStyleSpan(0, null, 2, null);
    }

    @NotNull
    public final IAztecInlineSpan makeInlineSpan(@NotNull Class<IAztecInlineSpan> spanType, @NotNull AztecAttributes attrs) {
        Intrinsics.checkParameterIsNotNull(spanType, (String)"spanType");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Class<IAztecInlineSpan> clazz = spanType;
        if (Intrinsics.areEqual(clazz, AztecCodeSpan.class)) {
            return new AztecCodeSpan(this.codeStyle, attrs);
        }
        return new AztecStyleSpan(0, null, 2, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ IAztecInlineSpan makeInlineSpan$default(InlineFormatter inlineFormatter, Class clazz, AztecAttributes aztecAttributes, int n, Object object) {
        if ((n & 2) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        return inlineFormatter.makeInlineSpan(clazz, aztecAttributes);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsInlineStyle(@NotNull ITextFormat textFormat, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)textFormat, (String)"textFormat");
        IAztecInlineSpan spanToCheck = this.makeInlineSpan(textFormat);
        if (start > end) {
            return false;
        }
        if (start == end) {
            void n;
            void $receiver$iv$iv;
            void $receiver$iv232;
            Object[] $receiver$iv$iv2;
            void $receiver$iv;
            if (start - 1 < 0 || start + 1 > this.getEditableText().length()) {
                return false;
            }
            Object[] objectArray = this.getEditableText().getSpans(start - 1, start, IAztecInlineSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(st\u2026ecInlineSpan::class.java)");
            Object[] objectArray2 = objectArray;
            void var7_8 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void var11_19 : $receiver$iv$iv2) {
                IAztecInlineSpan it;
                IAztecInlineSpan iAztecInlineSpan = it = (IAztecInlineSpan)var11_19;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToCheck)) continue;
                destination$iv$iv.add(var11_19);
            }
            IAztecInlineSpan before = (IAztecInlineSpan)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            Object[] objectArray3 = this.getEditableText().getSpans(start, start + 1, IAztecInlineSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray3, (String)"editableText.getSpans(st\u2026ecInlineSpan::class.java)");
            $receiver$iv$iv2 = objectArray3;
            destination$iv$iv = $receiver$iv232;
            Collection destination$iv$iv2 = new ArrayList();
            int n2 = ((void)$receiver$iv$iv).length;
            boolean bl = false;
            while (n < n2) {
                IAztecInlineSpan it;
                void element$iv$iv = $receiver$iv$iv[n];
                IAztecInlineSpan iAztecInlineSpan = it = (IAztecInlineSpan)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"it");
                if (this.isSameInlineSpanType(iAztecInlineSpan, spanToCheck)) {
                    destination$iv$iv2.add(element$iv$iv);
                }
                ++n;
            }
            IAztecInlineSpan after = (IAztecInlineSpan)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
            return before != null && after != null && this.isSameInlineSpanType(before, after);
        }
        StringBuilder builder = new StringBuilder();
        int after = start;
        int $receiver$iv232 = end - 1;
        if (after <= $receiver$iv232) {
            while (true) {
                void i;
                IAztecInlineSpan[] spans = (IAztecInlineSpan[])this.getEditableText().getSpans((int)i, (int)(i + true), IAztecInlineSpan.class);
                int n = spans.length;
                for (int j = 0; j < n; ++j) {
                    IAztecInlineSpan span;
                    IAztecInlineSpan iAztecInlineSpan = span = spans[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)iAztecInlineSpan, (String)"span");
                    if (!this.isSameInlineSpanType(iAztecInlineSpan, spanToCheck)) continue;
                    builder.append(((Object)this.getEditableText().subSequence((int)i, (int)(i + true))).toString());
                    break;
                }
                if (i == $receiver$iv232) break;
                ++i;
            }
        }
        CharSequence $receiver$iv232 = this.getEditableText().subSequence(start, end);
        CharSequence charSequence = "\n";
        charSequence = new Regex((String)charSequence);
        String string2 = "";
        String originalText = charSequence.replace($receiver$iv232, string2);
        String string3 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"builder.toString()");
        charSequence = string3;
        string2 = "\n";
        string2 = new Regex(string2);
        String string4 = "";
        String textOfCombinedSpans = string2.replace(charSequence, string4);
        charSequence = originalText;
        return charSequence.length() > 0 && Intrinsics.areEqual((Object)originalText, (Object)textOfCombinedSpans);
    }

    public static /* bridge */ /* synthetic */ boolean containsInlineStyle$default(InlineFormatter inlineFormatter, ITextFormat iTextFormat, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = inlineFormatter.getSelectionStart();
        }
        if ((n3 & 4) != 0) {
            n2 = inlineFormatter.getSelectionEnd();
        }
        return inlineFormatter.containsInlineStyle(iTextFormat, n, n2);
    }

    public final void tryRemoveLeadingInlineStyle() {
        block3: {
            block2: {
                int selectionStart = this.getEditor().getSelectionStart();
                int selectionEnd = this.getEditor().getSelectionEnd();
                if (selectionStart != 1 || selectionEnd != selectionStart) break block2;
                Object[] objectArray = this.getEditableText().getSpans(0, 0, IAztecInlineSpan.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(0,\u2026ecInlineSpan::class.java)");
                for (Object element$iv : objectArray) {
                    IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                    if (this.getEditableText().getSpanEnd((Object)it) != selectionEnd || this.getEditableText().getSpanEnd((Object)it) != selectionStart) continue;
                    this.getEditableText().removeSpan((Object)it);
                }
                break block3;
            }
            if (this.getEditor().length() != 1 || this.getEditor().getText().charAt(0) != Constants.INSTANCE.getEND_OF_BUFFER_MARKER()) break block3;
            Object[] objectArray = this.getEditableText().getSpans(0, 1, IAztecInlineSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"editableText.getSpans(0,\u2026ecInlineSpan::class.java)");
            for (Object element$iv : objectArray) {
                IAztecInlineSpan it = (IAztecInlineSpan)element$iv;
                if (this.getEditableText().getSpanStart((Object)it) != 1 || this.getEditableText().getSpanEnd((Object)it) != 1) continue;
                this.getEditableText().removeSpan((Object)it);
            }
        }
    }

    @NotNull
    public final CodeStyle getCodeStyle() {
        return this.codeStyle;
    }

    public InlineFormatter(@NotNull AztecText editor, @NotNull CodeStyle codeStyle) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)codeStyle, (String)"codeStyle");
        super(editor);
        this.codeStyle = codeStyle;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/wordpress/aztec/formatting/InlineFormatter$CodeStyle;", "", "codeBackground", "", "codeBackgroundAlpha", "", "codeColor", "(IFI)V", "getCodeBackground", "()I", "getCodeBackgroundAlpha", "()F", "getCodeColor", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "aztec_release"})
    public static final class CodeStyle {
        private final int codeBackground;
        private final float codeBackgroundAlpha;
        private final int codeColor;

        public final int getCodeBackground() {
            return this.codeBackground;
        }

        public final float getCodeBackgroundAlpha() {
            return this.codeBackgroundAlpha;
        }

        public final int getCodeColor() {
            return this.codeColor;
        }

        public CodeStyle(int codeBackground, float codeBackgroundAlpha, int codeColor) {
            this.codeBackground = codeBackground;
            this.codeBackgroundAlpha = codeBackgroundAlpha;
            this.codeColor = codeColor;
        }

        public final int component1() {
            return this.codeBackground;
        }

        public final float component2() {
            return this.codeBackgroundAlpha;
        }

        public final int component3() {
            return this.codeColor;
        }

        @NotNull
        public final CodeStyle copy(int codeBackground, float codeBackgroundAlpha, int codeColor) {
            return new CodeStyle(codeBackground, codeBackgroundAlpha, codeColor);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CodeStyle copy$default(CodeStyle codeStyle, int n, float f, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = codeStyle.codeBackground;
            }
            if ((n3 & 2) != 0) {
                f = codeStyle.codeBackgroundAlpha;
            }
            if ((n3 & 4) != 0) {
                n2 = codeStyle.codeColor;
            }
            return codeStyle.copy(n, f, n2);
        }

        public String toString() {
            return "CodeStyle(codeBackground=" + this.codeBackground + ", codeBackgroundAlpha=" + this.codeBackgroundAlpha + ", codeColor=" + this.codeColor + ")";
        }

        public int hashCode() {
            return (this.codeBackground * 31 + Float.floatToIntBits(this.codeBackgroundAlpha)) * 31 + this.codeColor;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CodeStyle)) break block3;
                    CodeStyle codeStyle = (CodeStyle)object;
                    if (!(this.codeBackground == codeStyle.codeBackground) || Float.compare(this.codeBackgroundAlpha, codeStyle.codeBackgroundAlpha) != 0 || !(this.codeColor == codeStyle.codeColor)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

