/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.AztecListSpan;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJh\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006-"}, d2={"Lorg/wordpress/aztec/spans/AztecUnorderedListSpan;", "Lorg/wordpress/aztec/spans/AztecListSpan;", "nestingLevel", "", "attributes", "Lorg/wordpress/aztec/AztecAttributes;", "listStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "(ILorg/wordpress/aztec/AztecAttributes;Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getAttributes", "()Lorg/wordpress/aztec/AztecAttributes;", "setAttributes", "(Lorg/wordpress/aztec/AztecAttributes;)V", "getListStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;", "setListStyle", "(Lorg/wordpress/aztec/formatting/BlockFormatter$ListStyle;)V", "getNestingLevel", "()I", "setNestingLevel", "(I)V", "drawLeadingMargin", "", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "x", "dir", "top", "baseline", "bottom", "text", "", "start", "end", "first", "", "l", "Landroid/text/Layout;", "getLeadingMargin", "aztec_release"})
public final class AztecUnorderedListSpan
extends AztecListSpan {
    @NotNull
    private final String TAG = "ul";
    private int nestingLevel;
    @NotNull
    private AztecAttributes attributes;
    @NotNull
    private BlockFormatter.ListStyle listStyle;

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    public int getLeadingMargin(boolean first) {
        return this.listStyle.getIndicatorMargin() + 2 * this.listStyle.getIndicatorWidth() + this.listStyle.getIndicatorPadding();
    }

    public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout l) {
        block6: {
            block5: {
                int spanEnd;
                Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
                Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
                if (!first) {
                    return;
                }
                int spanStart = ((Spanned)text).getSpanStart((Object)this);
                int n = start;
                if (spanStart > n || (spanEnd = ((Spanned)text).getSpanEnd((Object)this)) < n) break block5;
                int n2 = end;
                if (spanStart <= n2 && spanEnd >= n2) break block6;
            }
            return;
        }
        Paint.Style style2 = p.getStyle();
        int oldColor = p.getColor();
        p.setColor(this.listStyle.getIndicatorColor());
        p.setStyle(Paint.Style.FILL);
        int lineIndex = this.getIndexOfProcessedLine(text, end);
        String textToDraw = lineIndex > -1 ? "\u2022" : "";
        float width = p.measureText(textToDraw);
        float markerStartPosition = (float)x + (float)(this.listStyle.getIndicatorMargin() * dir) * 1.0f;
        if (dir == 1) {
            markerStartPosition -= width;
        }
        c.drawText(textToDraw, markerStartPosition, (float)baseline + (width - p.descent()), p);
        p.setColor(oldColor);
        p.setStyle(style2);
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    @Override
    @NotNull
    public AztecAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AztecAttributes aztecAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)aztecAttributes, (String)"<set-?>");
        this.attributes = aztecAttributes;
    }

    @NotNull
    public final BlockFormatter.ListStyle getListStyle() {
        return this.listStyle;
    }

    public final void setListStyle(@NotNull BlockFormatter.ListStyle listStyle) {
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"<set-?>");
        this.listStyle = listStyle;
    }

    public AztecUnorderedListSpan(int nestingLevel, @NotNull AztecAttributes attributes, @NotNull BlockFormatter.ListStyle listStyle) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)listStyle, (String)"listStyle");
        super(nestingLevel, listStyle.getVerticalPadding());
        this.nestingLevel = nestingLevel;
        this.attributes = attributes;
        this.listStyle = listStyle;
        this.TAG = "ul";
    }

    public /* synthetic */ AztecUnorderedListSpan(int n, AztecAttributes aztecAttributes, BlockFormatter.ListStyle listStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            aztecAttributes = new AztecAttributes(null, 1, null);
        }
        if ((n2 & 4) != 0) {
            listStyle = new BlockFormatter.ListStyle(0, 0, 0, 0, 0);
        }
        this(n, aztecAttributes, listStyle);
    }
}

