/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers;

import android.text.Editable;
import android.text.TextWatcher;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.spans.AztecHeadingSpan;
import org.wordpress.aztec.spans.AztecListItemSpan;
import org.wordpress.aztec.spans.EndOfParagraphMarker;
import org.wordpress.aztec.watchers.TextChangedEvent;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J(\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/wordpress/aztec/watchers/EndOfParagraphMarkerAdder;", "Landroid/text/TextWatcher;", "aztecText", "Lorg/wordpress/aztec/AztecText;", "verticalParagraphMargin", "", "(Lorg/wordpress/aztec/AztecText;I)V", "aztecTextRef", "Ljava/lang/ref/WeakReference;", "textChangedEventDetails", "Lorg/wordpress/aztec/watchers/TextChangedEvent;", "getVerticalParagraphMargin", "()I", "afterTextChanged", "", "text", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "count", "after", "onTextChanged", "before", "Companion", "aztec_release"})
public final class EndOfParagraphMarkerAdder
implements TextWatcher {
    private final WeakReference<AztecText> aztecTextRef;
    private TextChangedEvent textChangedEventDetails;
    private final int verticalParagraphMargin;
    public static final Companion Companion = new Companion(null);

    public void beforeTextChanged(@NotNull CharSequence text, int start, int count, int after) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.textChangedEventDetails = new TextChangedEvent(((Object)text).toString(), false, 0, 6, null);
    }

    public void onTextChanged(@NotNull CharSequence text, int start, int before, int count) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.textChangedEventDetails.setBefore(before);
        this.textChangedEventDetails.setText(text);
        this.textChangedEventDetails.setCountOfCharacters(count);
        this.textChangedEventDetails.setStart(start);
        this.textChangedEventDetails.initialize();
        if (!this.textChangedEventDetails.isNewLineButNotAtTheBeginning()) {
            return;
        }
        AztecText aztecText = (AztecText)this.aztecTextRef.get();
        if (aztecText != null && !aztecText.isTextChangedListenerDisabled() && aztecText.isInCalypsoMode()) {
            boolean insideHeading;
            int inputStart = this.textChangedEventDetails.getInputStart();
            int inputEnd = this.textChangedEventDetails.getInputEnd();
            Object[] objectArray = aztecText.getText().getSpans(inputStart, inputEnd, AztecListItemSpan.class);
            Object[] objectArray2 = objectArray;
            boolean isInsideList = !(objectArray2.length == 0);
            Object[] objectArray3 = objectArray2 = aztecText.getText().getSpans(inputStart, inputEnd, AztecHeadingSpan.class);
            boolean bl = insideHeading = !(objectArray3.length == 0);
            if (insideHeading && aztecText.getText().length() > inputEnd && aztecText.getText().charAt(inputEnd) == '\n') {
                insideHeading = false;
            }
            if (!isInsideList && !insideHeading) {
                aztecText.getText().setSpan((Object)new EndOfParagraphMarker(this.verticalParagraphMargin), inputStart, inputEnd, 33);
            }
        }
    }

    public void afterTextChanged(@NotNull Editable text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
    }

    public final int getVerticalParagraphMargin() {
        return this.verticalParagraphMargin;
    }

    public EndOfParagraphMarkerAdder(@NotNull AztecText aztecText, int verticalParagraphMargin) {
        Intrinsics.checkParameterIsNotNull((Object)aztecText, (String)"aztecText");
        this.verticalParagraphMargin = verticalParagraphMargin;
        this.aztecTextRef = new WeakReference<AztecText>(aztecText);
        this.textChangedEventDetails = new TextChangedEvent("", 0, 0, 0);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/wordpress/aztec/watchers/EndOfParagraphMarkerAdder$Companion;", "", "()V", "install", "", "editText", "Lorg/wordpress/aztec/AztecText;", "verticalParagraphMargin", "", "aztec_release"})
    public static final class Companion {
        public final void install(@NotNull AztecText editText, int verticalParagraphMargin) {
            Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
            editText.addTextChangedListener(new EndOfParagraphMarkerAdder(editText, verticalParagraphMargin));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

