/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.ParagraphStyle;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.ccil.cowan.tagsoup.Parser;
import org.wordpress.aztec.AztecAttributes;
import org.wordpress.aztec.AztecTextFormat;
import org.wordpress.aztec.Html;
import org.wordpress.aztec.plugins.IAztecPlugin;
import org.wordpress.aztec.plugins.html2visual.IHtmlCommentHandler;
import org.wordpress.aztec.spans.AztecCodeSpan;
import org.wordpress.aztec.spans.AztecCursorSpan;
import org.wordpress.aztec.spans.AztecMediaSpan;
import org.wordpress.aztec.spans.AztecRelativeSizeBigSpan;
import org.wordpress.aztec.spans.AztecRelativeSizeSmallSpan;
import org.wordpress.aztec.spans.AztecStyleBoldSpan;
import org.wordpress.aztec.spans.AztecStyleItalicSpan;
import org.wordpress.aztec.spans.AztecSubscriptSpan;
import org.wordpress.aztec.spans.AztecSuperscriptSpan;
import org.wordpress.aztec.spans.AztecTypefaceMonospaceSpan;
import org.wordpress.aztec.spans.AztecURLSpan;
import org.wordpress.aztec.spans.AztecUnderlineSpan;
import org.wordpress.aztec.spans.CommentSpan;
import org.wordpress.aztec.spans.FontSpan;
import org.wordpress.aztec.spans.IAztecBlockSpan;
import org.wordpress.aztec.spans.IAztecInlineSpan;
import org.wordpress.aztec.spans.UnknownClickableSpan;
import org.wordpress.aztec.spans.UnknownHtmlSpan;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

class HtmlToSpannedConverter
implements ContentHandler,
LexicalHandler {
    private int nestingLevel = 0;
    private int unknownTagLevel = 0;
    private Unknown unknown;
    private boolean insidePreTag = false;
    private boolean insideCodeTag = false;
    private String source;
    private List<IAztecPlugin> plugins;
    private UnknownHtmlSpan.OnUnknownHtmlClickListener onUnknownHtmlClickListener;
    private XMLReader reader;
    private SpannableStringBuilder spannableStringBuilder;
    private Html.TagHandler tagHandler;
    private Context context;

    public HtmlToSpannedConverter(String source, Html.TagHandler tagHandler, Parser parser, UnknownHtmlSpan.OnUnknownHtmlClickListener onUnknownHtmlClickListener, Context context, List<IAztecPlugin> plugins) {
        this.source = source;
        this.plugins = plugins;
        this.spannableStringBuilder = new SpannableStringBuilder();
        this.tagHandler = tagHandler;
        this.reader = parser;
        this.context = context;
        this.onUnknownHtmlClickListener = onUnknownHtmlClickListener;
    }

    public Spanned convert() {
        Object[] paragraphs;
        this.reader.setContentHandler(this);
        try {
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.source = this.source.replaceAll("\\[video([^\\]]*)\\]", "<video$1/>");
            this.reader.parse(new InputSource(new StringReader(this.source)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        for (Object paragraph : paragraphs = this.spannableStringBuilder.getSpans(0, this.spannableStringBuilder.length(), ParagraphStyle.class)) {
            if (paragraph instanceof UnknownHtmlSpan || paragraph instanceof IAztecBlockSpan || paragraph instanceof AztecMediaSpan) continue;
            int start = this.spannableStringBuilder.getSpanStart(paragraph);
            int end = this.spannableStringBuilder.getSpanEnd(paragraph);
            if (end - 2 >= 0 && this.spannableStringBuilder.charAt(end - 1) == '\n' && this.spannableStringBuilder.charAt(end - 2) == '\n') {
                --end;
            }
            if (end == start) {
                this.spannableStringBuilder.removeSpan(paragraph);
                continue;
            }
            this.spannableStringBuilder.setSpan(paragraph, start, end, 51);
        }
        return this.spannableStringBuilder;
    }

    private void handleStartTag(String tag, Attributes attributes, int nestingLevel) {
        if (this.unknownTagLevel != 0) {
            if (tag.equalsIgnoreCase("aztec_cursor")) {
                HtmlToSpannedConverter.handleCursor(this.spannableStringBuilder);
                return;
            }
            this.unknown.rawHtml.append('<').append(tag).append((CharSequence)Html.stringifyAttributes(attributes)).append('>');
            ++this.unknownTagLevel;
            return;
        }
        if (!tag.equalsIgnoreCase("br")) {
            if (tag.equalsIgnoreCase("aztec_cursor")) {
                HtmlToSpannedConverter.handleCursor(this.spannableStringBuilder);
            } else if (tag.equalsIgnoreCase("strong")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_BOLD, attributes);
            } else if (tag.equalsIgnoreCase("b")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_BOLD, attributes);
            } else if (tag.equalsIgnoreCase("em")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_ITALIC, attributes);
            } else if (tag.equalsIgnoreCase("cite")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_ITALIC, attributes);
            } else if (tag.equalsIgnoreCase("dfn")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_ITALIC, attributes);
            } else if (tag.equalsIgnoreCase("i")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_ITALIC, attributes);
            } else if (tag.equalsIgnoreCase("big")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_BIG, attributes);
            } else if (tag.equalsIgnoreCase("small")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_SMALL, attributes);
            } else if (tag.equalsIgnoreCase("font")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_FONT, attributes);
            } else if (tag.equalsIgnoreCase("tt")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_MONOSPACE, attributes);
            } else if (tag.equalsIgnoreCase("a")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_LINK, attributes);
            } else if (tag.equalsIgnoreCase("u")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_UNDERLINE, attributes);
            } else if (tag.equalsIgnoreCase("sup")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_SUPERSCRIPT, attributes);
            } else if (tag.equalsIgnoreCase("sub")) {
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_SUBSCRIPT, attributes);
            } else if (tag.equalsIgnoreCase("code")) {
                this.insideCodeTag = true;
                HtmlToSpannedConverter.start(this.spannableStringBuilder, AztecTextFormat.FORMAT_CODE, attributes);
            } else {
                if (this.tagHandler != null) {
                    boolean tagHandled;
                    if (tag.equalsIgnoreCase("pre")) {
                        this.insidePreTag = true;
                    }
                    if (tagHandled = this.tagHandler.handleTag(true, tag, (Editable)this.spannableStringBuilder, this.context, attributes, nestingLevel)) {
                        return;
                    }
                }
                if (!UnknownHtmlSpan.Companion.getKNOWN_TAGS().contains(tag.toLowerCase()) && this.unknownTagLevel == 0) {
                    this.unknownTagLevel = 1;
                    this.unknown = new Unknown();
                    this.unknown.rawHtml = new StringBuilder();
                    this.unknown.rawHtml.append('<').append(tag).append((CharSequence)Html.stringifyAttributes(attributes)).append('>');
                    this.spannableStringBuilder.setSpan((Object)this.unknown, this.spannableStringBuilder.length(), this.spannableStringBuilder.length(), 17);
                }
            }
        }
    }

    private void handleEndTag(String tag, int nestingLevel) {
        if (this.unknownTagLevel != 0) {
            if (tag.equalsIgnoreCase("aztec_cursor")) {
                return;
            }
            if (tag.equalsIgnoreCase("br")) {
                --this.unknownTagLevel;
                return;
            }
            this.unknown.rawHtml.append("</").append(tag).append(">");
            --this.unknownTagLevel;
            if (this.unknownTagLevel == 0) {
                this.spannableStringBuilder.append((CharSequence)"\ufffc");
                HtmlToSpannedConverter.endUnknown(this.spannableStringBuilder, nestingLevel, this.unknown.rawHtml, this.context, this.onUnknownHtmlClickListener);
            }
            return;
        }
        if (tag.equalsIgnoreCase("br")) {
            HtmlToSpannedConverter.handleBr(this.spannableStringBuilder);
        } else if (tag.equalsIgnoreCase("strong")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_BOLD);
        } else if (tag.equalsIgnoreCase("b")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_BOLD);
        } else if (tag.equalsIgnoreCase("em")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_ITALIC);
        } else if (tag.equalsIgnoreCase("cite")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_ITALIC);
        } else if (tag.equalsIgnoreCase("dfn")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_ITALIC);
        } else if (tag.equalsIgnoreCase("i")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_ITALIC);
        } else if (tag.equalsIgnoreCase("big")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_BIG);
        } else if (tag.equalsIgnoreCase("small")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_SMALL);
        } else if (tag.equalsIgnoreCase("font")) {
            HtmlToSpannedConverter.endFont(this.spannableStringBuilder);
        } else if (tag.equalsIgnoreCase("tt")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_MONOSPACE);
        } else if (tag.equalsIgnoreCase("a")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_LINK);
        } else if (tag.equalsIgnoreCase("u")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_UNDERLINE);
        } else if (tag.equalsIgnoreCase("sup")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_SUPERSCRIPT);
        } else if (tag.equalsIgnoreCase("sub")) {
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_SUBSCRIPT);
        } else if (tag.equalsIgnoreCase("code")) {
            this.insideCodeTag = false;
            HtmlToSpannedConverter.end(this.spannableStringBuilder, AztecTextFormat.FORMAT_CODE);
        } else if (this.tagHandler != null) {
            if (tag.equalsIgnoreCase("pre")) {
                this.insidePreTag = false;
            }
            this.tagHandler.handleTag(false, tag, (Editable)this.spannableStringBuilder, this.context, new AztecAttributes(), nestingLevel);
        }
    }

    private static void handleCursor(SpannableStringBuilder text) {
        int start = text.length();
        Object[] unknownSpans = text.getSpans(start, start, Unknown.class);
        if (unknownSpans.length > 0) {
            start = text.getSpanStart(unknownSpans[0]);
        }
        text.setSpan((Object)new AztecCursorSpan(), start, start, 17);
    }

    private static void handleBr(SpannableStringBuilder text) {
        text.append((CharSequence)"\n");
    }

    private static Object getLast(Spanned text, Class kind) {
        Object[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        return objs[objs.length - 1];
    }

    private static void start(SpannableStringBuilder text, AztecTextFormat textFormat, Attributes attrs) {
        IAztecInlineSpan newSpan;
        AztecAttributes attributes = new AztecAttributes(attrs);
        switch (textFormat) {
            case FORMAT_BOLD: {
                newSpan = new AztecStyleBoldSpan(attributes);
                break;
            }
            case FORMAT_ITALIC: {
                newSpan = new AztecStyleItalicSpan(attributes);
                break;
            }
            case FORMAT_UNDERLINE: {
                newSpan = new AztecUnderlineSpan(attributes);
                break;
            }
            case FORMAT_LINK: {
                String url = attributes.hasAttribute("href") ? attributes.getValue("href") : "";
                newSpan = new AztecURLSpan(url, attributes);
                break;
            }
            case FORMAT_BIG: {
                newSpan = new AztecRelativeSizeBigSpan(attributes);
                break;
            }
            case FORMAT_SMALL: {
                newSpan = new AztecRelativeSizeSmallSpan(attributes);
                break;
            }
            case FORMAT_SUPERSCRIPT: {
                newSpan = new AztecSuperscriptSpan(attributes);
                break;
            }
            case FORMAT_SUBSCRIPT: {
                newSpan = new AztecSubscriptSpan(attributes);
                break;
            }
            case FORMAT_MONOSPACE: {
                newSpan = new AztecTypefaceMonospaceSpan(attributes);
                break;
            }
            case FORMAT_FONT: {
                newSpan = new FontSpan(attributes);
                break;
            }
            case FORMAT_CODE: {
                newSpan = new AztecCodeSpan(attributes);
                break;
            }
            default: {
                throw new IllegalArgumentException("Style not supported");
            }
        }
        int len = text.length();
        text.setSpan((Object)newSpan, len, len, 17);
    }

    private static void end(SpannableStringBuilder text, AztecTextFormat textFormat) {
        IAztecInlineSpan span;
        switch (textFormat) {
            case FORMAT_BOLD: {
                span = (AztecStyleBoldSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecStyleBoldSpan.class);
                break;
            }
            case FORMAT_ITALIC: {
                span = (AztecStyleItalicSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecStyleItalicSpan.class);
                break;
            }
            case FORMAT_UNDERLINE: {
                span = (AztecUnderlineSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecUnderlineSpan.class);
                break;
            }
            case FORMAT_LINK: {
                span = (AztecURLSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecURLSpan.class);
                break;
            }
            case FORMAT_BIG: {
                span = (AztecRelativeSizeBigSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecRelativeSizeBigSpan.class);
                break;
            }
            case FORMAT_SMALL: {
                span = (AztecRelativeSizeSmallSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecRelativeSizeSmallSpan.class);
                break;
            }
            case FORMAT_SUPERSCRIPT: {
                span = (AztecSuperscriptSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecSuperscriptSpan.class);
                break;
            }
            case FORMAT_SUBSCRIPT: {
                span = (AztecSubscriptSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecSubscriptSpan.class);
                break;
            }
            case FORMAT_MONOSPACE: {
                span = (AztecTypefaceMonospaceSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecTypefaceMonospaceSpan.class);
                break;
            }
            case FORMAT_FONT: {
                span = (FontSpan)HtmlToSpannedConverter.getLast((Spanned)text, FontSpan.class);
                break;
            }
            case FORMAT_CODE: {
                span = (AztecCodeSpan)HtmlToSpannedConverter.getLast((Spanned)text, AztecCodeSpan.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("Style not supported");
            }
        }
        int where = text.getSpanStart((Object)span);
        text.setSpan((Object)span, where, text.length(), 33);
    }

    private static void endFont(SpannableStringBuilder text) {
        int len = text.length();
        FontSpan font = (FontSpan)HtmlToSpannedConverter.getLast((Spanned)text, FontSpan.class);
        int where = text.getSpanStart((Object)font);
        HtmlToSpannedConverter.end(text, AztecTextFormat.FORMAT_FONT);
        if (font != null && where != len) {
            String face;
            String color = font.getAttributes().getValue("color");
            if (!TextUtils.isEmpty((CharSequence)color)) {
                if (color.startsWith("@")) {
                    String name;
                    Resources res = Resources.getSystem();
                    int colorRes = res.getIdentifier(name = color.substring(1), "color", "android");
                    if (colorRes != 0) {
                        ColorStateList colors = res.getColorStateList(colorRes);
                        text.setSpan((Object)new TextAppearanceSpan(null, 0, 0, colors, null), where, len, 33);
                    }
                } else {
                    try {
                        int c = Color.parseColor((String)color);
                        if (c != -1) {
                            text.setSpan((Object)new ForegroundColorSpan(c | 0xFF000000), where, len, 33);
                        }
                    }
                    catch (Exception c) {
                        // empty catch block
                    }
                }
            }
            if ((face = font.getAttributes().getValue("face")) != null) {
                text.setSpan((Object)new TypefaceSpan(face), where, len, 33);
            }
        }
    }

    private static void endUnknown(SpannableStringBuilder text, int nestingLevel, StringBuilder rawHtml, Context context, UnknownHtmlSpan.OnUnknownHtmlClickListener onUnknownHtmlClickListener) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast((Spanned)text, Unknown.class);
        int where = text.getSpanStart(obj);
        text.removeSpan(obj);
        if (where != len) {
            UnknownHtmlSpan unknownHtmlSpan = new UnknownHtmlSpan(nestingLevel, rawHtml, context, 17301568, onUnknownHtmlClickListener);
            text.setSpan((Object)unknownHtmlSpan, where, len, 33);
            UnknownClickableSpan unknownClickableSpan = new UnknownClickableSpan(unknownHtmlSpan);
            text.setSpan((Object)unknownClickableSpan, where, len, 33);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.nestingLevel;
        this.handleStartTag(localName, attributes, this.nestingLevel);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndTag(localName, this.nestingLevel);
        --this.nestingLevel;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.unknownTagLevel != 0) {
            for (int i = 0; i < length; ++i) {
                this.unknown.rawHtml.append(ch[i + start]);
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ch[i + start];
            if (!this.insidePreTag && !this.insideCodeTag && c == ' ' || c == '\n') {
                int len = sb.length();
                int pred = len == 0 ? ((len = this.spannableStringBuilder.length()) == 0 ? 10 : (int)this.spannableStringBuilder.charAt(len - 1)) : sb.charAt(len - 1);
                if (pred == 32 || pred == 10) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        this.spannableStringBuilder.append((CharSequence)sb);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String s, String s1, String s2) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String s) throws SAXException {
    }

    @Override
    public void endEntity(String s) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] chars, int start, int length) throws SAXException {
        if (this.unknownTagLevel != 0) {
            this.unknown.rawHtml.append("<!--");
            for (int i = 0; i < length; ++i) {
                this.unknown.rawHtml.append(chars[i + start]);
            }
            this.unknown.rawHtml.append("-->");
            return;
        }
        String comment = new String(chars, start, length);
        int spanStart = this.spannableStringBuilder.length();
        boolean wasCommentHandled = false;
        if (this.plugins != null) {
            IAztecPlugin plugin;
            Iterator<IAztecPlugin> iterator = this.plugins.iterator();
            while (!(!iterator.hasNext() || (plugin = iterator.next()) instanceof IHtmlCommentHandler && (wasCommentHandled = ((IHtmlCommentHandler)((Object)plugin)).handleComment(comment, (Editable)this.spannableStringBuilder, this.nestingLevel)))) {
            }
        }
        if (!wasCommentHandled) {
            this.spannableStringBuilder.append((CharSequence)comment);
            this.spannableStringBuilder.setSpan((Object)new CommentSpan(), spanStart, this.spannableStringBuilder.length(), 33);
        }
    }

    private static class Unknown {
        public StringBuilder rawHtml;

        private Unknown() {
        }
    }
}

