/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.widget.EditText;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.HistoryListener;
import org.wordpress.aztec.source.SourceViewEditText;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\"\u001a\u00020 J\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020 2\u0006\u0010$\u001a\u00020%J\u0006\u0010'\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010+\u001a\u00020 2\u0006\u0010$\u001a\u00020%J\u0006\u0010,\u001a\u00020\u0003J\u0006\u0010-\u001a\u00020 R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006."}, d2={"Lorg/wordpress/aztec/History;", "", "historyEnabled", "", "historySize", "", "(ZI)V", "historyCursor", "getHistoryCursor", "()I", "setHistoryCursor", "(I)V", "getHistoryEnabled", "()Z", "historyList", "Ljava/util/LinkedList;", "", "getHistoryList", "()Ljava/util/LinkedList;", "setHistoryList", "(Ljava/util/LinkedList;)V", "historyListener", "Lorg/wordpress/aztec/HistoryListener;", "getHistorySize", "historyWorking", "inputBefore", "inputLast", "getInputLast", "()Ljava/lang/String;", "setInputLast", "(Ljava/lang/String;)V", "beforeTextChanged", "", "text", "clearHistory", "handleHistory", "editText", "Landroid/widget/EditText;", "redo", "redoValid", "setHistoryListener", "listener", "setTextFromHistory", "undo", "undoValid", "updateActions", "aztec_release"})
public final class History {
    private int historyCursor;
    @NotNull
    private LinkedList<String> historyList;
    @NotNull
    private String inputLast;
    private HistoryListener historyListener;
    private boolean historyWorking;
    private String inputBefore;
    private final boolean historyEnabled;
    private final int historySize;

    public final int getHistoryCursor() {
        return this.historyCursor;
    }

    public final void setHistoryCursor(int n) {
        this.historyCursor = n;
    }

    @NotNull
    public final LinkedList<String> getHistoryList() {
        return this.historyList;
    }

    public final void setHistoryList(@NotNull LinkedList<String> linkedList) {
        Intrinsics.checkParameterIsNotNull(linkedList, (String)"<set-?>");
        this.historyList = linkedList;
    }

    @NotNull
    public final String getInputLast() {
        return this.inputLast;
    }

    public final void setInputLast(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.inputLast = string2;
    }

    public final void beforeTextChanged(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (this.historyEnabled && !this.historyWorking) {
            this.inputBefore = text;
        }
    }

    public final void handleHistory(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        if (!this.historyEnabled || this.historyWorking) {
            return;
        }
        if (editText instanceof AztecText) {
            this.inputLast = ((AztecText)editText).toFormattedHtml();
        } else if (editText instanceof SourceViewEditText) {
            this.inputLast = ((SourceViewEditText)editText).getText().toString();
        }
        String string2 = this.inputBefore;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputBefore");
        }
        if (Intrinsics.areEqual((Object)this.inputLast, (Object)string2)) {
            return;
        }
        while (this.historyCursor != this.historyList.size() && this.historyCursor >= 0) {
            this.historyList.remove(this.historyCursor);
        }
        if (this.historyList.size() >= this.historySize) {
            this.historyList.remove(0);
            int n = this.historyCursor;
            this.historyCursor = n + -1;
        }
        String string3 = this.inputBefore;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputBefore");
        }
        this.historyList.add(string3);
        this.historyCursor = this.historyList.size();
        this.updateActions();
    }

    public final void redo(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        if (!this.redoValid()) {
            return;
        }
        this.historyWorking = true;
        editText.setFocusable(false);
        editText.setFocusableInTouchMode(false);
        if (this.historyCursor >= this.historyList.size() - 1) {
            this.historyCursor = this.historyList.size();
            if (editText instanceof AztecText) {
                ((AztecText)editText).fromHtml(this.inputLast);
            } else if (editText instanceof SourceViewEditText) {
                ((SourceViewEditText)editText).displayStyledHtml(this.inputLast);
            }
        } else {
            int n = this.historyCursor;
            this.historyCursor = n + 1;
            this.setTextFromHistory(editText);
        }
        this.historyWorking = false;
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        this.updateActions();
    }

    public final void undo(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        if (!this.undoValid()) {
            return;
        }
        this.historyWorking = true;
        int n = this.historyCursor;
        this.historyCursor = n + -1;
        editText.setFocusable(false);
        editText.setFocusableInTouchMode(false);
        this.setTextFromHistory(editText);
        this.historyWorking = false;
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        this.updateActions();
    }

    private final void setTextFromHistory(EditText editText) {
        if (editText instanceof AztecText) {
            AztecText aztecText = (AztecText)editText;
            String string2 = this.historyList.get(this.historyCursor);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"historyList[historyCursor]");
            aztecText.fromHtml(string2);
        } else if (editText instanceof SourceViewEditText) {
            SourceViewEditText sourceViewEditText = (SourceViewEditText)editText;
            String string3 = this.historyList.get(this.historyCursor);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"historyList[historyCursor]");
            sourceViewEditText.displayStyledHtml(string3);
        }
    }

    public final boolean redoValid() {
        if (!this.historyEnabled || this.historySize <= 0 || this.historyList.size() <= 0 || this.historyWorking) {
            return false;
        }
        return this.historyCursor < this.historyList.size();
    }

    public final boolean undoValid() {
        if (!this.historyEnabled || this.historySize <= 0 || this.historyWorking) {
            return false;
        }
        return this.historyList.size() > 0 && this.historyCursor > 0;
    }

    public final void clearHistory() {
        this.inputLast = "";
        this.historyList.clear();
    }

    public final void setHistoryListener(@NotNull HistoryListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.historyListener = listener;
    }

    public final void updateActions() {
        block1: {
            HistoryListener historyListener = this.historyListener;
            if (historyListener != null) {
                historyListener.onRedoEnabled();
            }
            HistoryListener historyListener2 = this.historyListener;
            if (historyListener2 == null) break block1;
            historyListener2.onUndoEnabled();
        }
    }

    public final boolean getHistoryEnabled() {
        return this.historyEnabled;
    }

    public final int getHistorySize() {
        return this.historySize;
    }

    public History(boolean historyEnabled, int historySize) {
        this.historyEnabled = historyEnabled;
        this.historySize = historySize;
        this.historyList = new LinkedList();
        this.inputLast = "";
    }
}

