/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.source;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.History;
import org.wordpress.aztec.R;
import org.wordpress.aztec.source.Format;
import org.wordpress.aztec.source.HtmlStyleTextWatcher;
import org.wordpress.aztec.source.HtmlStyleUtils;
import org.wordpress.aztec.spans.AztecCursorSpan;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001NB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J(\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020'2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nH\u0016J\u000e\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020#J\u000e\u0010/\u001a\u00020#2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020#2\u0006\u00100\u001a\u000201J\u0006\u00103\u001a\u00020#J\u0010\u00104\u001a\u0002012\b\b\u0002\u00105\u001a\u00020\u0013J\u0012\u00106\u001a\u00020#2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0006\u00107\u001a\u00020\u0013J\u0006\u00108\u001a\u00020\u0013J\b\u00109\u001a\u00020#H\u0014J\b\u0010:\u001a\u00020#H\u0014J\u0018\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020>H\u0016J\u0012\u0010?\u001a\u00020#2\b\u0010@\u001a\u0004\u0018\u00010AH\u0016J\b\u0010B\u001a\u00020AH\u0016J(\u0010C\u001a\u00020#2\u0006\u0010$\u001a\u00020'2\u0006\u0010(\u001a\u00020\n2\u0006\u0010D\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0016J\u0006\u0010E\u001a\u00020#J\u000e\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u00020\u0013J\u000e\u0010H\u001a\u00020#2\u0006\u0010I\u001a\u00020\u001cJ\u0010\u0010J\u001a\u00020#2\u0006\u0010K\u001a\u00020\nH\u0016J\u0010\u0010L\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0002J\u0006\u0010M\u001a\u00020#R&\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n8\u0006@@X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n8\u0006@@X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000f\"\u0004\b!\u0010\u0011\u00a8\u0006O"}, d2={"Lorg/wordpress/aztec/source/SourceViewEditText;", "Landroid/support/v7/widget/AppCompatEditText;", "Landroid/text/TextWatcher;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "attributeColor", "getAttributeColor", "()I", "setAttributeColor$aztec_release", "(I)V", "consumeEditEvent", "", "history", "Lorg/wordpress/aztec/History;", "getHistory", "()Lorg/wordpress/aztec/History;", "setHistory", "(Lorg/wordpress/aztec/History;)V", "isInCalypsoMode", "onImeBackListener", "Lorg/wordpress/aztec/AztecText$OnImeBackListener;", "styleTextWatcher", "Lorg/wordpress/aztec/source/HtmlStyleTextWatcher;", "tagColor", "getTagColor", "setTagColor$aztec_release", "afterTextChanged", "", "text", "Landroid/text/Editable;", "beforeTextChanged", "", "start", "count", "after", "consumeCursorTag", "styledHtml", "Landroid/text/SpannableStringBuilder;", "disableTextChangedListener", "displayStyledAndFormattedHtml", "source", "", "displayStyledHtml", "enableTextChangedListener", "getPureHtml", "withCursorTag", "init", "isCursorInsideTag", "isTextChangedListenerDisabled", "onAttachedToWindow", "onDetachedFromWindow", "onKeyPreIme", "keyCode", "event", "Landroid/view/KeyEvent;", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onTextChanged", "before", "redo", "setCalypsoMode", "isCompatibleWithCalypso", "setOnImeBackListener", "listener", "setVisibility", "visibility", "styleHtml", "undo", "SavedState", "aztec_release"})
@SuppressLint(value={"SupportAnnotationUsage"})
public final class SourceViewEditText
extends AppCompatEditText
implements TextWatcher {
    @ColorInt
    private int tagColor;
    @ColorInt
    private int attributeColor;
    private HtmlStyleTextWatcher styleTextWatcher;
    private AztecText.OnImeBackListener onImeBackListener;
    private boolean isInCalypsoMode;
    @Nullable
    private History history;
    private boolean consumeEditEvent;

    public final int getTagColor() {
        return this.tagColor;
    }

    public final void setTagColor$aztec_release(int n) {
        this.tagColor = n;
    }

    public final int getAttributeColor() {
        return this.attributeColor;
    }

    public final void setAttributeColor$aztec_release(int n) {
        this.attributeColor = n;
    }

    @Nullable
    public final History getHistory() {
        return this.history;
    }

    public final void setHistory(@Nullable History history) {
        this.history = history;
    }

    private final void init(AttributeSet attrs) {
        TypedArray values = this.getContext().obtainStyledAttributes(attrs, R.styleable.SourceViewEditText);
        this.setBackgroundColor(values.getColor(R.styleable.SourceViewEditText_codeBackgroundColor, ContextCompat.getColor((Context)this.getContext(), (int)17170445)));
        if (!values.hasValue(R.styleable.SourceViewEditText_codeDialog) && values.getBoolean(R.styleable.SourceViewEditText_codeDialog, false)) {
            this.setTextColor(values.getColor(R.styleable.SourceViewEditText_codeTextColor, 16842806));
        }
        this.tagColor = values.getColor(R.styleable.SourceViewEditText_tagColor, this.tagColor);
        this.attributeColor = values.getColor(R.styleable.SourceViewEditText_attributeColor, this.attributeColor);
        this.styleTextWatcher = new HtmlStyleTextWatcher(this.tagColor, this.attributeColor);
        values.recycle();
    }

    public final void setCalypsoMode(boolean isCompatibleWithCalypso) {
        this.isInCalypsoMode = isCompatibleWithCalypso;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.addTextChangedListener(this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeTextChangedListener(this);
    }

    public void onRestoreInstanceState(@Nullable Parcelable state) {
        Parcelable parcelable = state;
        if (parcelable == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.wordpress.aztec.source.SourceViewEditText.SavedState");
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        Bundle customState = savedState.getState();
        this.setVisibility(customState.getInt("visibility"));
    }

    @NotNull
    public Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"superState");
        SavedState savedState = new SavedState(parcelable);
        Bundle bundle = new Bundle();
        bundle.putInt("visibility", this.getVisibility());
        savedState.setState(bundle);
        return (Parcelable)savedState;
    }

    public void beforeTextChanged(@NotNull CharSequence text, int start, int count, int after) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            History history = this.history;
            if (history != null) {
                history.beforeTextChanged(((Object)text).toString());
            }
            HtmlStyleTextWatcher htmlStyleTextWatcher = this.styleTextWatcher;
            if (htmlStyleTextWatcher == null) break block1;
            htmlStyleTextWatcher.beforeTextChanged(text, start, count, after);
        }
    }

    public void onTextChanged(@NotNull CharSequence text, int start, int before, int count) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            HtmlStyleTextWatcher htmlStyleTextWatcher = this.styleTextWatcher;
            if (htmlStyleTextWatcher == null) break block0;
            htmlStyleTextWatcher.onTextChanged(text, start, before, count);
        }
    }

    public void afterTextChanged(@Nullable Editable text) {
        block2: {
            if (this.isTextChangedListenerDisabled()) {
                this.enableTextChangedListener();
                return;
            }
            History history = this.history;
            if (history != null) {
                history.handleHistory((EditText)this);
            }
            HtmlStyleTextWatcher htmlStyleTextWatcher = this.styleTextWatcher;
            if (htmlStyleTextWatcher == null) break block2;
            htmlStyleTextWatcher.afterTextChanged(text);
        }
    }

    public final void redo() {
        block0: {
            History history = this.history;
            if (history == null) break block0;
            history.redo((EditText)this);
        }
    }

    public final void undo() {
        block0: {
            History history = this.history;
            if (history == null) break block0;
            history.undo((EditText)this);
        }
    }

    public void setVisibility(int visibility) {
        int selectionBefore = this.getSelectionStart();
        super.setVisibility(visibility);
        if (visibility == 0) {
            this.requestFocus();
            if (selectionBefore != this.getSelectionStart()) {
                this.setSelection(0);
            }
        }
    }

    public final void displayStyledAndFormattedHtml(@NotNull String source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        SpannableStringBuilder styledHtml = this.styleHtml(Format.INSTANCE.addSourceEditorFormatting(source, this.isInCalypsoMode));
        this.disableTextChangedListener();
        int cursorPosition = this.consumeCursorTag(styledHtml);
        this.setText((CharSequence)styledHtml);
        this.enableTextChangedListener();
        if (cursorPosition > 0) {
            this.setSelection(cursorPosition);
        }
    }

    public final int consumeCursorTag(@NotNull SpannableStringBuilder styledHtml) {
        boolean newlineBefore;
        Intrinsics.checkParameterIsNotNull((Object)styledHtml, (String)"styledHtml");
        int cursorTagIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)styledHtml), (String)AztecCursorSpan.Companion.getAZTEC_CURSOR_TAG(), (int)0, (boolean)false, (int)6, null);
        if (cursorTagIndex < 0) {
            return 0;
        }
        boolean bl = cursorTagIndex > 0 ? styledHtml.charAt(cursorTagIndex - 1) == '\n' : (newlineBefore = false);
        boolean newlineAfter = cursorTagIndex + AztecCursorSpan.Companion.getAZTEC_CURSOR_TAG().length() + 1 < styledHtml.length() ? styledHtml.charAt(cursorTagIndex + AztecCursorSpan.Companion.getAZTEC_CURSOR_TAG().length()) == '\n' : false;
        styledHtml.delete(cursorTagIndex, cursorTagIndex + AztecCursorSpan.Companion.getAZTEC_CURSOR_TAG().length());
        if (newlineBefore && newlineAfter) {
            styledHtml.delete(--cursorTagIndex, cursorTagIndex + 1);
        }
        CharSequence charSequence = (CharSequence)styledHtml;
        String string2 = AztecCursorSpan.Companion.getAZTEC_CURSOR_TAG();
        string2 = new Regex(string2);
        String string3 = "";
        string2.replace(charSequence, string3);
        return cursorTagIndex;
    }

    public final void displayStyledHtml(@NotNull String source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        SpannableStringBuilder styledHtml = this.styleHtml(source);
        this.disableTextChangedListener();
        this.setTextKeepState((CharSequence)styledHtml);
        this.enableTextChangedListener();
    }

    private final SpannableStringBuilder styleHtml(String source) {
        SpannableStringBuilder styledHtml = new SpannableStringBuilder((CharSequence)source);
        HtmlStyleUtils.INSTANCE.styleHtmlForDisplayWithColors((Spannable)styledHtml, this.tagColor, this.attributeColor);
        return styledHtml;
    }

    public final boolean isCursorInsideTag() {
        int indexOfFirstClosingBracketOnTheRight = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getText()), (String)">", (int)this.getSelectionEnd(), (boolean)false, (int)4, null);
        int indexOfFirstOpeningBracketOnTheRight = StringsKt.indexOf$default((CharSequence)((CharSequence)this.getText()), (String)"<", (int)this.getSelectionEnd(), (boolean)false, (int)4, null);
        boolean isThereClosingBracketBeforeOpeningBracket = indexOfFirstClosingBracketOnTheRight != -1 && (indexOfFirstClosingBracketOnTheRight < indexOfFirstOpeningBracketOnTheRight || indexOfFirstOpeningBracketOnTheRight == -1);
        int indexOfFirstClosingBracketOnTheLeft = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)this.getText()), (String)">", (int)(this.getSelectionEnd() - 1), (boolean)false, (int)4, null);
        int indexOfFirstOpeningBracketOnTheLeft = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)this.getText()), (String)"<", (int)(this.getSelectionEnd() - 1), (boolean)false, (int)4, null);
        boolean isThereOpeningBracketBeforeClosingBracket = indexOfFirstOpeningBracketOnTheLeft != -1 && (indexOfFirstOpeningBracketOnTheLeft > indexOfFirstClosingBracketOnTheLeft || indexOfFirstClosingBracketOnTheLeft == -1);
        return isThereClosingBracketBeforeOpeningBracket && isThereOpeningBracketBeforeClosingBracket;
    }

    @NotNull
    public final String getPureHtml(boolean withCursorTag) {
        if (withCursorTag) {
            this.disableTextChangedListener();
            if (!this.isCursorInsideTag()) {
                this.getText().insert(this.getSelectionEnd(), (CharSequence)"<aztec_cursor></aztec_cursor>");
            } else {
                this.getText().insert(StringsKt.lastIndexOf$default((CharSequence)((CharSequence)this.getText()), (String)"<", (int)this.getSelectionEnd(), (boolean)false, (int)4, null), (CharSequence)"<aztec_cursor></aztec_cursor>");
            }
            this.enableTextChangedListener();
        }
        return Format.INSTANCE.removeSourceEditorFormatting(this.getText().toString(), this.isInCalypsoMode);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String getPureHtml$default(SourceViewEditText sourceViewEditText, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return sourceViewEditText.getPureHtml(bl);
    }

    public final void disableTextChangedListener() {
        this.consumeEditEvent = true;
    }

    public final void enableTextChangedListener() {
        this.consumeEditEvent = false;
    }

    public final boolean isTextChangedListenerDisabled() {
        return this.consumeEditEvent;
    }

    public final void setOnImeBackListener(@NotNull AztecText.OnImeBackListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.onImeBackListener = listener;
    }

    public boolean onKeyPreIme(int keyCode, @NotNull KeyEvent event) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (event.getKeyCode() != 4 || event.getAction() != 1) break block1;
            AztecText.OnImeBackListener onImeBackListener = this.onImeBackListener;
            if (onImeBackListener != null) {
                onImeBackListener.onImeBack();
            }
        }
        return super.onKeyPreIme(keyCode, event);
    }

    public SourceViewEditText(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.tagColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.html_tag);
        this.attributeColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.html_attribute);
        this.isInCalypsoMode = true;
        this.consumeEditEvent = true;
        this.init(null);
    }

    public SourceViewEditText(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.tagColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.html_tag);
        this.attributeColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.html_attribute);
        this.isInCalypsoMode = true;
        this.consumeEditEvent = true;
        this.init(attrs);
    }

    public SourceViewEditText(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.tagColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.html_tag);
        this.attributeColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.html_attribute);
        this.isInCalypsoMode = true;
        this.consumeEditEvent = true;
        this.init(attrs);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/wordpress/aztec/source/SourceViewEditText$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "state", "Landroid/os/Bundle;", "getState", "()Landroid/os/Bundle;", "setState", "(Landroid/os/Bundle;)V", "writeToParcel", "", "out", "flags", "", "Companion", "aztec_release"})
    public static final class SavedState
    extends View.BaseSavedState {
        @NotNull
        private Bundle state;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        @NotNull
        public final Bundle getState() {
            return this.state;
        }

        public final void setState(@NotNull Bundle bundle) {
            Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"<set-?>");
            this.state = bundle;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            out.writeBundle(this.state);
        }

        public SavedState(@NotNull Parcelable superState) {
            Intrinsics.checkParameterIsNotNull((Object)superState, (String)"superState");
            super(superState);
            this.state = new Bundle();
        }

        public SavedState(@NotNull Parcel parcel) {
            Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
            super(parcel);
            this.state = new Bundle();
            Bundle bundle = parcel.readBundle(((Object)((Object)this)).getClass().getClassLoader());
            Intrinsics.checkExpressionValueIsNotNull((Object)bundle, (String)"parcel.readBundle(javaClass.classLoader)");
            this.state = bundle;
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @NotNull
                public SavedState createFromParcel(@NotNull Parcel source) {
                    Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                    return new SavedState(source);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/wordpress/aztec/source/SourceViewEditText$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lorg/wordpress/aztec/source/SourceViewEditText$SavedState;", "aztec_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

