/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.LineBackgroundSpan;
import android.text.style.LineHeightSpan;
import android.text.style.QuoteSpan;
import android.text.style.UpdateLayout;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.formatting.BlockFormatter;
import org.wordpress.aztec.spans.AztecBlockSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B!\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ8\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-H\u0016Jb\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0016Jh\u00109\u001a\u00020%2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\tH\u0016J\u0010\u0010A\u001a\u00020\u00072\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010B\u001a\u00020\tH\u0016R\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0014\"\u0004\b#\u0010\u0016\u00a8\u0006C"}, d2={"Lorg/wordpress/aztec/spans/AztecQuoteSpan;", "Landroid/text/style/QuoteSpan;", "Landroid/text/style/LineBackgroundSpan;", "Lorg/wordpress/aztec/spans/AztecBlockSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/UpdateLayout;", "nestingLevel", "", "attributes", "", "quoteStyle", "Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "(ILjava/lang/String;Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;)V", "TAG", "getAttributes", "()Ljava/lang/String;", "setAttributes", "(Ljava/lang/String;)V", "endBeforeBleed", "getEndBeforeBleed", "()I", "setEndBeforeBleed", "(I)V", "getNestingLevel", "setNestingLevel", "getQuoteStyle", "()Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;", "setQuoteStyle", "(Lorg/wordpress/aztec/formatting/BlockFormatter$QuoteStyle;)V", "rect", "Landroid/graphics/Rect;", "getRect", "()Landroid/graphics/Rect;", "startBeforeCollapse", "getStartBeforeCollapse", "setStartBeforeCollapse", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "Landroid/graphics/Paint$FontMetricsInt;", "drawBackground", "c", "Landroid/graphics/Canvas;", "p", "Landroid/graphics/Paint;", "left", "right", "top", "baseline", "bottom", "lnum", "drawLeadingMargin", "x", "dir", "first", "", "layout", "Landroid/text/Layout;", "getEndTag", "getLeadingMargin", "getStartTag", "aztec_release"})
public final class AztecQuoteSpan
extends QuoteSpan
implements LineBackgroundSpan,
AztecBlockSpan,
LineHeightSpan,
UpdateLayout {
    private int endBeforeBleed;
    private int startBeforeCollapse;
    @NotNull
    private final Rect rect;
    private final String TAG = "blockquote";
    private int nestingLevel;
    @NotNull
    private String attributes;
    @NotNull
    private BlockFormatter.QuoteStyle quoteStyle;

    @Override
    public int getEndBeforeBleed() {
        return this.endBeforeBleed;
    }

    @Override
    public void setEndBeforeBleed(int n) {
        this.endBeforeBleed = n;
    }

    @Override
    public int getStartBeforeCollapse() {
        return this.startBeforeCollapse;
    }

    @Override
    public void setStartBeforeCollapse(int n) {
        this.startBeforeCollapse = n;
    }

    @NotNull
    public final Rect getRect() {
        return this.rect;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        Spanned spanned = (Spanned)charSequence;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.quoteStyle.getVerticalPadding();
            fm.top -= this.quoteStyle.getVerticalPadding();
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.quoteStyle.getVerticalPadding();
            fm.bottom += this.quoteStyle.getVerticalPadding();
        }
    }

    @Override
    @NotNull
    public String getStartTag() {
        if (TextUtils.isEmpty((CharSequence)this.getAttributes())) {
            return this.TAG;
        }
        return this.TAG + this.getAttributes();
    }

    @Override
    @NotNull
    public String getEndTag() {
        return this.TAG;
    }

    public int getLeadingMargin(boolean first) {
        return this.quoteStyle.getQuoteMargin() + this.quoteStyle.getQuoteWidth() + this.quoteStyle.getQuotePadding();
    }

    public void drawLeadingMargin(@NotNull Canvas c, @NotNull Paint p, int x, int dir, int top, int baseline, int bottom, @NotNull CharSequence text, int start, int end, boolean first, @NotNull Layout layout) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
        Paint.Style style = p.getStyle();
        int color2 = p.getColor();
        p.setStyle(Paint.Style.FILL);
        p.setColor(this.quoteStyle.getQuoteColor());
        c.drawRect((float)x + (float)this.quoteStyle.getQuoteMargin(), (float)top, (float)(x + this.quoteStyle.getQuoteMargin() + dir * this.quoteStyle.getQuoteWidth()), (float)bottom, p);
        p.setStyle(style);
        p.setColor(color2);
    }

    public void drawBackground(@NotNull Canvas c, @NotNull Paint p, int left, int right, int top, int baseline, int bottom, @Nullable CharSequence text, int start, int end, int lnum) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        int alpha = (int)(this.quoteStyle.getQuoteBackgroundAlpha() * (float)255);
        int paintColor = p.getColor();
        p.setColor(Color.argb((int)alpha, (int)Color.red((int)this.quoteStyle.getQuoteBackground()), (int)Color.green((int)this.quoteStyle.getQuoteBackground()), (int)Color.blue((int)this.quoteStyle.getQuoteBackground())));
        this.rect.set(left + this.quoteStyle.getQuoteMargin(), top, right, bottom);
        c.drawRect(this.rect, p);
        p.setColor(paintColor);
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    @Override
    @NotNull
    public String getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.attributes = string;
    }

    @NotNull
    public final BlockFormatter.QuoteStyle getQuoteStyle() {
        return this.quoteStyle;
    }

    public final void setQuoteStyle(@NotNull BlockFormatter.QuoteStyle quoteStyle) {
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"<set-?>");
        this.quoteStyle = quoteStyle;
    }

    public AztecQuoteSpan(int nestingLevel, @NotNull String attributes, @NotNull BlockFormatter.QuoteStyle quoteStyle) {
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)quoteStyle, (String)"quoteStyle");
        this.nestingLevel = nestingLevel;
        this.attributes = attributes;
        this.quoteStyle = quoteStyle;
        this.endBeforeBleed = -1;
        this.startBeforeCollapse = -1;
        this.rect = new Rect();
        this.TAG = "blockquote";
    }

    public /* synthetic */ AztecQuoteSpan(int n, String string, BlockFormatter.QuoteStyle quoteStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            quoteStyle = new BlockFormatter.QuoteStyle(0, 0, 0.0f, 0, 0, 0, 0);
        }
        this(n, string, quoteStyle);
    }

    @Override
    public void clearStartBeforeCollapse() {
        AztecBlockSpan.DefaultImpls.clearStartBeforeCollapse(this);
    }

    @Override
    public boolean hasCollapsed() {
        return AztecBlockSpan.DefaultImpls.hasCollapsed(this);
    }

    @Override
    public void clearEndBeforeBleed() {
        AztecBlockSpan.DefaultImpls.clearEndBeforeBleed(this);
    }

    @Override
    public boolean hasBled() {
        return AztecBlockSpan.DefaultImpls.hasBled(this);
    }
}

