/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.formatting;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.Patterns;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.wordpress.aztec.formatting.AztecFormatter;
import org.wordpress.aztec.spans.AztecURLSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ,\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0016J\u0010\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0016J\u0006\u0010\u001b\u001a\u00020\u0012J\u0016\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ*\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u001e\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\f2\b\b\u0002\u0010\"\u001a\u00020\fJ0\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u001e\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006'"}, d2={"Lorg/wordpress/aztec/formatting/LinkFormatter;", "Lorg/wordpress/aztec/formatting/AztecFormatter;", "editor", "Lorg/wordpress/aztec/AztecText;", "linkStyle", "Lorg/wordpress/aztec/formatting/LinkFormatter$LinkStyle;", "(Lorg/wordpress/aztec/AztecText;Lorg/wordpress/aztec/formatting/LinkFormatter$LinkStyle;)V", "getLinkStyle", "()Lorg/wordpress/aztec/formatting/LinkFormatter$LinkStyle;", "addLink", "", "link", "", "anchor", "start", "", "end", "containLink", "", "editLink", "getAttributes", "getSelectedUrlWithAnchor", "Lkotlin/Pair;", "getUrlFromClipboard", "context", "Landroid/content/Context;", "getUrlSpanBounds", "isUrlSelected", "linkInvalid", "linkValid", "attributes", "makeUrlSpan", "Lorg/wordpress/aztec/spans/AztecURLSpan;", "url", "attrs", "setLinkSpan", "spannable", "Landroid/text/Spannable;", "LinkStyle", "aztec_release"})
public final class LinkFormatter
extends AztecFormatter {
    @NotNull
    private final LinkStyle linkStyle;

    public final boolean isUrlSelected() {
        AztecURLSpan[] urlSpans = (AztecURLSpan[])this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecURLSpan.class);
        Object[] objectArray = urlSpans;
        return !(objectArray.length == 0);
    }

    @NotNull
    public final Pair<String, String> getSelectedUrlWithAnchor() {
        String anchor;
        String url;
        if (!this.isUrlSelected()) {
            String clipboardUrl = this.getUrlFromClipboard(this.getEditor().getContext());
            url = TextUtils.isEmpty((CharSequence)clipboardUrl) ? "" : clipboardUrl;
            anchor = this.getSelectionStart() == this.getSelectionEnd() ? "" : this.getEditor().getSelectedText();
        } else {
            AztecURLSpan urlSpan = (AztecURLSpan)ArraysKt.first((Object[])this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecURLSpan.class));
            int spanStart = this.getEditableText().getSpanStart((Object)urlSpan);
            int spanEnd = this.getEditableText().getSpanEnd((Object)urlSpan);
            if (this.getSelectionStart() < spanStart || this.getSelectionEnd() > spanEnd) {
                anchor = this.getEditor().getSelectedText();
                url = "";
            } else {
                CharSequence charSequence = (CharSequence)this.getEditableText();
                anchor = ((Object)charSequence.subSequence(spanStart, spanEnd)).toString();
                String string2 = urlSpan.getURL();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"urlSpan.url");
                url = string2;
            }
            if (Intrinsics.areEqual((Object)anchor, (Object)url)) {
                anchor = "";
            }
        }
        return new Pair((Object)url, (Object)anchor);
    }

    @NotNull
    public final String getUrlFromClipboard(@Nullable Context context) {
        if (context == null) {
            return "";
        }
        Object object = context.getSystemService("clipboard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData data = clipboard.getPrimaryClip();
        if (data == null || data.getItemCount() <= 0) {
            return "";
        }
        String clipText = ((Object)data.getItemAt(0).getText()).toString();
        return Patterns.WEB_URL.matcher(clipText).matches() ? clipText : "";
    }

    @NotNull
    public final Pair<Integer, Integer> getUrlSpanBounds() {
        AztecURLSpan urlSpan = (AztecURLSpan)ArraysKt.first((Object[])this.getEditableText().getSpans(this.getSelectionStart(), this.getSelectionEnd(), AztecURLSpan.class));
        int spanStart = this.getEditableText().getSpanStart((Object)urlSpan);
        int spanEnd = this.getEditableText().getSpanEnd((Object)urlSpan);
        if (this.getSelectionStart() < spanStart || this.getSelectionEnd() > spanEnd) {
            return new Pair((Object)this.getSelectionStart(), (Object)this.getSelectionEnd());
        }
        return new Pair((Object)spanStart, (Object)spanEnd);
    }

    public final void addLink(@NotNull String link, @NotNull String anchor, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        String string2 = link;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String cleanLink = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        String actualAnchor = TextUtils.isEmpty((CharSequence)anchor) ? cleanLink : anchor;
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)actualAnchor);
        LinkFormatter.setLinkSpan$default(this, (Spannable)ssb, cleanLink, 0, actualAnchor.length(), null, 16, null);
        if (start == end) {
            this.getEditableText().insert(start, (CharSequence)ssb);
        } else if (Intrinsics.areEqual((Object)this.getEditor().getSelectedText(), (Object)anchor) ^ true) {
            this.getEditableText().replace(start, end, (CharSequence)ssb);
        } else {
            LinkFormatter.setLinkSpan$default(this, (Spannable)this.getEditableText(), cleanLink, start, end, null, 16, null);
        }
    }

    public final void editLink(@NotNull String link, @Nullable String anchor, int start, int end) {
        int newEnd;
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        String string2 = link;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String cleanLink = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        if (TextUtils.isEmpty((CharSequence)anchor)) {
            this.getEditableText().replace(start, end, (CharSequence)cleanLink);
            newEnd = start + cleanLink.length();
        } else {
            if (Intrinsics.areEqual((Object)this.getEditor().getSelectedText(), (Object)anchor) ^ true) {
                this.getEditableText().replace(start, end, (CharSequence)anchor);
            }
            String string4 = anchor;
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            newEnd = start + string4.length();
        }
        String attributes = this.getAttributes(end, start);
        CharSequence charSequence = attributes;
        String string5 = "href=[\"'].*[\"']";
        string5 = new Regex(string5);
        String string6 = "href=" + "\"" + cleanLink + "\"";
        attributes = string5.replace(charSequence, string6);
        this.linkValid(cleanLink, start, newEnd, attributes);
    }

    public static /* bridge */ /* synthetic */ void editLink$default(LinkFormatter linkFormatter, String string2, String string3, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: editLink");
        }
        if ((n3 & 4) != 0) {
            n = linkFormatter.getSelectionStart();
        }
        if ((n3 & 8) != 0) {
            n2 = linkFormatter.getSelectionEnd();
        }
        linkFormatter.editLink(string2, string3, n, n2);
    }

    private final String getAttributes(int end, int start) {
        AztecURLSpan urlSpan = (AztecURLSpan)ArraysKt.firstOrNull((Object[])this.getEditableText().getSpans(start, end, AztecURLSpan.class));
        String attributes = "";
        if (urlSpan != null) {
            attributes = urlSpan.getAttributes();
        }
        return attributes;
    }

    @NotNull
    public final AztecURLSpan makeUrlSpan(@NotNull String url, @NotNull String attrs) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        return new AztecURLSpan(url, this.linkStyle, attrs);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AztecURLSpan makeUrlSpan$default(LinkFormatter linkFormatter, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeUrlSpan");
        }
        if ((n & 2) != 0) {
            string3 = "";
        }
        return linkFormatter.makeUrlSpan(string2, string3);
    }

    private final void linkValid(String link, int start, int end, String attributes) {
        if (start >= end) {
            return;
        }
        this.linkInvalid(start, end);
        this.setLinkSpan((Spannable)this.getEditableText(), link, start, end, attributes);
        this.getEditor().onSelectionChanged(end, end);
    }

    static /* bridge */ /* synthetic */ void linkValid$default(LinkFormatter linkFormatter, String string2, int n, int n2, String string3, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: linkValid");
        }
        if ((n3 & 8) != 0) {
            string3 = "";
        }
        linkFormatter.linkValid(string2, n, n2, string3);
    }

    public final void linkInvalid(int start, int end) {
        if (start >= end) {
            return;
        }
        AztecURLSpan[] spans = (AztecURLSpan[])this.getEditableText().getSpans(start, end, AztecURLSpan.class);
        for (int i = 0; i < spans.length; ++i) {
            AztecURLSpan span = spans[i];
            this.getEditableText().removeSpan((Object)span);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containLink(int start, int end) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (start > end) {
            return false;
        }
        if (start == end) {
            if (start - 1 < 0) return false;
            if (start + 1 > this.getEditableText().length()) {
                return false;
            }
            AztecURLSpan[] before = (AztecURLSpan[])this.getEditableText().getSpans(start - 1, start, AztecURLSpan.class);
            AztecURLSpan[] after = (AztecURLSpan[])this.getEditableText().getSpans(start, start + 1, AztecURLSpan.class);
            Object[] objectArray = before;
            Object[] objectArray2 = objectArray;
            if (objectArray2.length == 0) {
                return false;
            }
            boolean bl = false;
            if (bl) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            objectArray = after;
            objectArray2 = objectArray;
            if (objectArray2.length != 0) return true;
            return false;
        }
        StringBuilder builder = new StringBuilder();
        Iterable after = (Iterable)new IntRange(start, end - 1);
        Iterator iterator = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            Object[] objectArray = this.getEditableText().getSpans(it, it + 1, AztecURLSpan.class);
            Object[] objectArray3 = objectArray;
            if (!(!(objectArray3.length == 0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            int it = ((Number)element$iv).intValue();
            builder.append(((Object)this.getEditableText().subSequence(it, it + 1)).toString());
        }
        return Intrinsics.areEqual((Object)((Object)this.getEditableText().subSequence(start, end)).toString(), (Object)builder.toString());
    }

    public final void setLinkSpan(@NotNull Spannable spannable, @NotNull String link, int start, int end, @NotNull String attributes) {
        Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"spannable");
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        spannable.setSpan((Object)new AztecURLSpan(link, this.linkStyle, attributes), start, end, 33);
    }

    public static /* bridge */ /* synthetic */ void setLinkSpan$default(LinkFormatter linkFormatter, Spannable spannable, String string2, int n, int n2, String string3, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setLinkSpan");
        }
        if ((n3 & 0x10) != 0) {
            string3 = "";
        }
        linkFormatter.setLinkSpan(spannable, string2, n, n2, string3);
    }

    @NotNull
    public final LinkStyle getLinkStyle() {
        return this.linkStyle;
    }

    public LinkFormatter(@NotNull AztecText editor, @NotNull LinkStyle linkStyle) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)linkStyle, (String)"linkStyle");
        super(editor);
        this.linkStyle = linkStyle;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/wordpress/aztec/formatting/LinkFormatter$LinkStyle;", "", "linkColor", "", "linkUnderline", "", "(IZ)V", "getLinkColor", "()I", "getLinkUnderline", "()Z", "component1", "component2", "copy", "aztec_release"})
    public static final class LinkStyle {
        private final int linkColor;
        private final boolean linkUnderline;

        public final int getLinkColor() {
            return this.linkColor;
        }

        public final boolean getLinkUnderline() {
            return this.linkUnderline;
        }

        public LinkStyle(int linkColor, boolean linkUnderline) {
            this.linkColor = linkColor;
            this.linkUnderline = linkUnderline;
        }

        public final int component1() {
            return this.linkColor;
        }

        public final boolean component2() {
            return this.linkUnderline;
        }

        @NotNull
        public final LinkStyle copy(int linkColor, boolean linkUnderline) {
            return new LinkStyle(linkColor, linkUnderline);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ LinkStyle copy$default(LinkStyle linkStyle, int n, boolean bl, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n2 & 1) != 0) {
                n = linkStyle.linkColor;
            }
            if ((n2 & 2) != 0) {
                bl = linkStyle.linkUnderline;
            }
            return linkStyle.copy(n, bl);
        }

        public String toString() {
            return "LinkStyle(linkColor=" + this.linkColor + ", linkUnderline=" + this.linkUnderline + ")";
        }

        public int hashCode() {
            int n = this.linkUnderline ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return this.linkColor * 31 + n;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LinkStyle)) break block3;
                    LinkStyle linkStyle = (LinkStyle)object;
                    if (!(this.linkColor == linkStyle.linkColor) || !(this.linkUnderline == linkStyle.linkUnderline)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

