/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.watchers;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.widget.EditText;
import android.widget.TextView;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.Constants;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J(\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/wordpress/aztec/watchers/EndOfBufferMarkerAdder;", "Landroid/text/TextWatcher;", "text", "Landroid/text/Editable;", "(Landroid/text/Editable;)V", "afterTextChanged", "", "beforeTextChanged", "s", "", "start", "", "count", "after", "onTextChanged", "before", "Companion", "aztec_release"})
public final class EndOfBufferMarkerAdder
implements TextWatcher {
    public static final Companion Companion = new Companion(null);

    public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
    }

    public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
    }

    public void afterTextChanged(@NotNull Editable text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Companion.ensureEndOfTextMarker(text);
    }

    public EndOfBufferMarkerAdder(@NotNull Editable text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Companion.ensureEndOfTextMarker(text);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006\u00a8\u0006\u0015"}, d2={"Lorg/wordpress/aztec/watchers/EndOfBufferMarkerAdder$Companion;", "", "()V", "ensureEndOfTextMarker", "Landroid/text/Editable;", "text", "", "install", "", "editText", "Landroid/widget/EditText;", "removeEndOfTextMarker", "T", "", "string", "(Ljava/lang/CharSequence;)Ljava/lang/CharSequence;", "safeLength", "", "textView", "Landroid/widget/TextView;", "strip", "aztec_release"})
    public static final class Companion {
        public final void install(@NotNull EditText editText) {
            Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
            Editable editable = editText.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"editText.text");
            editText.addTextChangedListener((TextWatcher)new EndOfBufferMarkerAdder(editable));
        }

        @NotNull
        public final Editable ensureEndOfTextMarker(@NotNull Editable text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            CharSequence charSequence = (CharSequence)text;
            if (charSequence.length() == 0) {
                text.append((CharSequence)("" + Constants.INSTANCE.getEND_OF_BUFFER_MARKER()));
                return text;
            }
            char c = text.charAt(text.length() - 1);
            if (c == Constants.INSTANCE.getNEWLINE()) {
                text.append((CharSequence)("" + Constants.INSTANCE.getEND_OF_BUFFER_MARKER()));
            } else if (c == Constants.INSTANCE.getEND_OF_BUFFER_MARKER()) {
                if (text.length() < 2) {
                    return text;
                }
                if (text.charAt(text.length() - 2) != Constants.INSTANCE.getNEWLINE()) {
                    text.delete(text.length() - 1, text.length());
                }
            } else {
                int lastEndOfTextMarkerIndex;
                while ((lastEndOfTextMarkerIndex = StringsKt.lastIndexOf$default((CharSequence)text.toString(), (char)Constants.INSTANCE.getEND_OF_BUFFER_MARKER(), (int)0, (boolean)false, (int)6, null)) != -1) {
                    text.delete(lastEndOfTextMarkerIndex, lastEndOfTextMarkerIndex + 1);
                }
            }
            return text;
        }

        @NotNull
        public final String ensureEndOfTextMarker(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            SpannableStringBuilder sb = new SpannableStringBuilder((CharSequence)text);
            this.ensureEndOfTextMarker((Editable)sb);
            String string2 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
            return string2;
        }

        @NotNull
        public final <T extends CharSequence> T removeEndOfTextMarker(@NotNull T string2) {
            Intrinsics.checkParameterIsNotNull(string2, (String)"string");
            T t = string2;
            if (t.length() > 0 && string2.charAt(string2.length() - 1) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER()) {
                t = string2;
                int n = 0;
                int n2 = string2.length() - 2;
                ((Object)t.subSequence(n, n2)).toString();
            }
            return string2;
        }

        public final int safeLength(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
            if (textView.length() == 0) {
                return 0;
            }
            if (textView.getText().charAt(textView.length() - 1) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER()) {
                return textView.length() - 1;
            }
            return textView.length();
        }

        @NotNull
        public final String strip(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"string");
            CharSequence charSequence = string2;
            if (charSequence.length() == 0) {
                return string2;
            }
            if (string2.charAt(string2.length() - 1) == Constants.INSTANCE.getEND_OF_BUFFER_MARKER()) {
                charSequence = string2;
                int n = 0;
                int n2 = string2.length() - 1;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)charSequence2).substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            }
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

