/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.style.DynamicDrawableSpan;
import android.view.Gravity;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.AztecText;
import org.xml.sax.Attributes;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 S2\u00020\u0001:\u0001SB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020&J\u001a\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u00102\u001a\u00020&H\u0002J\u000e\u00103\u001a\u00020&2\u0006\u00104\u001a\u00020&J\u0006\u00105\u001a\u000200J\u0006\u00106\u001a\u000200JP\u00107\u001a\u0002002\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010.\u001a\u00020&2\u0006\u0010<\u001a\u00020&2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020&2\u0006\u0010A\u001a\u00020&2\u0006\u0010B\u001a\u00020CH\u0016J\n\u0010D\u001a\u0004\u0018\u00010\u0005H\u0016J\u0006\u0010E\u001a\u00020\fJ6\u0010F\u001a\u00020&2\b\u0010B\u001a\u0004\u0018\u00010C2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010.\u001a\u00020&2\u0006\u0010<\u001a\u00020&2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0006\u0010I\u001a\u00020\fJ\u000e\u0010J\u001a\u0002002\u0006\u0010K\u001a\u00020LJ\u0010\u0010M\u001a\u0002002\b\u0010N\u001a\u0004\u0018\u00010\u0005J\u0016\u0010O\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020&2\u0006\u0010Q\u001a\u00020&J \u0010R\u001a\u0002002\u0006\u0010P\u001a\u00020&2\b\u0010N\u001a\u0004\u0018\u00010\u00052\u0006\u00102\u001a\u00020&R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020&0%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006T"}, d2={"Lorg/wordpress/aztec/spans/AztecMediaSpan;", "Landroid/text/style/DynamicDrawableSpan;", "context", "Landroid/content/Context;", "drawable", "Landroid/graphics/drawable/Drawable;", "attributes", "Lorg/xml/sax/Attributes;", "onMediaTappedListener", "Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "(Landroid/content/Context;Landroid/graphics/drawable/Drawable;Lorg/xml/sax/Attributes;Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;)V", "TAG", "", "aspectRatio", "", "getAspectRatio", "()D", "setAspectRatio", "(D)V", "getAttributes", "()Lorg/xml/sax/Attributes;", "setAttributes", "(Lorg/xml/sax/Attributes;)V", "getContext", "()Landroid/content/Context;", "measuring", "", "getOnMediaTappedListener", "()Lorg/wordpress/aztec/AztecText$OnMediaTappedListener;", "originalBounds", "Landroid/graphics/Rect;", "getOriginalBounds", "()Landroid/graphics/Rect;", "setOriginalBounds", "(Landroid/graphics/Rect;)V", "overlays", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "textView", "Lorg/wordpress/aztec/AztecText;", "getTextView", "()Lorg/wordpress/aztec/AztecText;", "setTextView", "(Lorg/wordpress/aztec/AztecText;)V", "adjustBounds", "start", "applyOverlayGravity", "", "overlay", "gravity", "calculateWantedWidth", "widthMeasureSpec", "clearOverlays", "computeAspectRatio", "draw", "canvas", "Landroid/graphics/Canvas;", "text", "", "end", "x", "", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getDrawable", "getHtml", "getSize", "metrics", "Landroid/graphics/Paint$FontMetricsInt;", "getSource", "onClick", "view", "Landroid/view/View;", "setDrawable", "newDrawable", "setOverayLevel", "index", "level", "setOverlay", "Companion", "aztec_release"})
public final class AztecMediaSpan
extends DynamicDrawableSpan {
    private final String TAG = "img";
    @Nullable
    private AztecText textView;
    @NotNull
    private Rect originalBounds;
    private double aspectRatio;
    private boolean measuring;
    private final ArrayList<Pair<Drawable, Integer>> overlays;
    @NotNull
    private final Context context;
    private Drawable drawable;
    @Nullable
    private Attributes attributes;
    @Nullable
    private final AztecText.OnMediaTappedListener onMediaTappedListener;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final AztecText getTextView() {
        return this.textView;
    }

    public final void setTextView(@Nullable AztecText aztecText) {
        this.textView = aztecText;
    }

    @NotNull
    public final Rect getOriginalBounds() {
        return this.originalBounds;
    }

    public final void setOriginalBounds(@NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"<set-?>");
        this.originalBounds = rect;
    }

    public final double getAspectRatio() {
        return this.aspectRatio;
    }

    public final void setAspectRatio(double d) {
        this.aspectRatio = d;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void computeAspectRatio() {
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4 = this.drawable;
        if ((drawable4 != null ? drawable4.getIntrinsicWidth() : -1) > -1) {
            Drawable drawable5 = this.drawable;
            if ((drawable5 != null ? drawable5.getIntrinsicHeight() : -1) > -1) {
                Drawable drawable6 = this.drawable;
                Drawable drawable7 = this.drawable;
                this.aspectRatio = 1.0 * (double)(drawable6 != null ? drawable6.getIntrinsicWidth() : 1) / (double)(drawable7 != null ? drawable7.getIntrinsicHeight() : 1);
                return;
            }
        }
        if ((drawable3 = this.drawable) != null && (drawable3 = drawable3.getBounds()) != null ? drawable3.isEmpty() : true) {
            this.aspectRatio = 1.0;
            return;
        }
        Drawable drawable8 = this.drawable;
        this.aspectRatio = 1.0 * (double)(drawable8 != null && (drawable8 = drawable8.getBounds()) != null ? drawable8.width() : 0) / (double)((drawable2 = this.drawable) != null && (drawable2 = drawable2.getBounds()) != null ? drawable2.height() : 1);
    }

    public int getSize(@Nullable Paint paint, @Nullable CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt metrics) {
        Rect sizeRect = this.adjustBounds(start);
        if (metrics != null && sizeRect.width() > 0) {
            metrics.ascent = -sizeRect.height();
            metrics.descent = 0;
            metrics.top = metrics.ascent;
            metrics.bottom = 0;
        }
        return sizeRect.width();
    }

    @NotNull
    public final Rect adjustBounds(int start) {
        Drawable drawable2;
        int height;
        int n;
        int width;
        int n2;
        AztecText aztecText;
        block17: {
            Drawable drawable3;
            block16: {
                if (this.textView == null) break block16;
                AztecText aztecText2 = this.textView;
                if (!Intrinsics.areEqual((Object)(aztecText2 != null ? Integer.valueOf(aztecText2.getWidthMeasureSpec()) : null), (Object)0)) break block17;
            }
            if ((drawable3 = this.drawable) == null || (drawable3 = drawable3.getBounds()) == null) {
                drawable3 = new Rect(0, 0, 0, 0);
            }
            return new Rect((Rect)drawable3);
        }
        if (this.measuring) {
            return new Rect(0, 0, 1, 1);
        }
        AztecText aztecText3 = this.textView;
        AztecText aztecText4 = this.textView;
        AztecText aztecText5 = this.textView;
        int want = this.calculateWantedWidth(aztecText3 != null ? aztecText3.getWidthMeasureSpec() : 0) - (aztecText4 != null ? aztecText4.getCompoundPaddingLeft() : 0) - (aztecText5 != null ? aztecText5.getCompoundPaddingRight() : 0);
        this.measuring = true;
        AztecText aztecText6 = this.textView;
        AztecText aztecText7 = this.textView;
        StaticLayout layout = new StaticLayout(aztecText7 != null && (aztecText7 = aztecText7.getText()) != null ? (CharSequence)((Object)aztecText7) : (CharSequence)"", 0, (aztecText = this.textView) != null && (aztecText = aztecText.getText()) != null ? aztecText.length() : 0, (TextPaint)(aztecText6 != null ? aztecText6.getPaint() : null), want, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        this.measuring = false;
        int line = layout.getLineForOffset(start);
        int maxWidth = layout.getParagraphRight(line) - layout.getParagraphLeft(line);
        if (this.originalBounds.width() > 0) {
            n2 = this.originalBounds.width();
        } else {
            Drawable drawable4 = this.drawable;
            if ((drawable4 != null ? drawable4.getIntrinsicWidth() : -1) > -1) {
                Drawable drawable5 = this.drawable;
                n2 = drawable5 != null ? drawable5.getIntrinsicWidth() : -1;
            } else {
                n2 = width = maxWidth;
            }
        }
        if (this.originalBounds.height() > 0) {
            n = this.originalBounds.height();
        } else {
            Drawable drawable6 = this.drawable;
            if ((drawable6 != null ? drawable6.getIntrinsicHeight() : -1) > -1) {
                Drawable drawable7 = this.drawable;
                n = drawable7 != null ? drawable7.getIntrinsicHeight() : -1;
            } else {
                n = height = (int)((double)width / this.aspectRatio);
            }
        }
        if (width > maxWidth) {
            width = maxWidth;
            height = (int)((double)width / this.aspectRatio);
        }
        Drawable drawable8 = this.drawable;
        if (drawable8 != null) {
            drawable8.setBounds(new Rect(0, 0, width, height));
        }
        if ((drawable2 = this.drawable) == null || (drawable2 = drawable2.getBounds()) == null) {
            drawable2 = new Rect(0, 0, 0, 0);
        }
        return new Rect((Rect)drawable2);
    }

    public final int calculateWantedWidth(int widthMeasureSpec) {
        int width;
        BoringLayout.Metrics UNKNOWN_BORING;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        BoringLayout.Metrics boring = UNKNOWN_BORING = new BoringLayout.Metrics();
        int des = -1;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            if (des < 0) {
                AztecText aztecText = this.textView;
                boring = BoringLayout.isBoring((CharSequence)"", (TextPaint)(aztecText != null ? aztecText.getPaint() : null));
            }
            if (boring == null || boring == UNKNOWN_BORING) {
                if (des < 0) {
                    AztecText aztecText = this.textView;
                    des = (int)Math.ceil(Layout.getDesiredWidth((CharSequence)"", (TextPaint)(aztecText != null ? aztecText.getPaint() : null)));
                }
                width = des;
            } else {
                width = boring.width;
            }
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        return width;
    }

    @Nullable
    public Drawable getDrawable() {
        return this.drawable;
    }

    public final void setDrawable(@Nullable Drawable newDrawable) {
        this.drawable = newDrawable;
        Drawable drawable2 = this.drawable;
        if (drawable2 == null || (drawable2 = drawable2.getBounds()) == null) {
            drawable2 = new Rect(0, 0, 0, 0);
        }
        this.originalBounds = new Rect((Rect)drawable2);
        AztecMediaSpan.Companion.setInitBounds(newDrawable);
        this.computeAspectRatio();
    }

    public final void setOverlay(int index, @Nullable Drawable newDrawable, int gravity) {
        if (CollectionsKt.getLastIndex((List)this.overlays) >= index) {
            this.overlays.remove(index);
        }
        if (newDrawable != null) {
            this.overlays.ensureCapacity(index + 1);
            this.overlays.add(index, (Pair<Drawable, Integer>)new Pair((Object)newDrawable, (Object)gravity));
            AztecMediaSpan.Companion.setInitBounds(newDrawable);
        }
    }

    public final void clearOverlays() {
        this.overlays.clear();
    }

    public final boolean setOverayLevel(int index, int level) {
        Drawable drawable2 = (Drawable)this.overlays.get(index).getFirst();
        return drawable2 != null ? drawable2.setLevel(level) : false;
    }

    private final void applyOverlayGravity(Drawable overlay, int gravity) {
        if (this.drawable != null && overlay != null) {
            Drawable drawable2 = this.drawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            int n = drawable2.getBounds().width();
            Drawable drawable3 = this.drawable;
            if (drawable3 == null) {
                Intrinsics.throwNpe();
            }
            Rect rect = new Rect(0, 0, n, drawable3.getBounds().height());
            Rect outRect = new Rect();
            Gravity.apply((int)gravity, (int)overlay.getBounds().width(), (int)overlay.getBounds().height(), (Rect)rect, (Rect)outRect);
            overlay.setBounds(outRect.left, outRect.top, outRect.right, outRect.bottom);
        }
    }

    public void draw(@NotNull Canvas canvas, @NotNull CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Pair it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        canvas.save();
        if (this.drawable != null) {
            int transY = top;
            if (this.mVerticalAlignment == 1) {
                transY -= paint.getFontMetricsInt().descent;
            }
            canvas.translate(x, (float)transY);
            Drawable drawable2 = this.drawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            drawable2.draw(canvas);
        }
        Iterable transY = this.overlays;
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            this.applyOverlayGravity((Drawable)it.getFirst(), ((Number)it.getSecond()).intValue());
        }
        $receiver$iv = this.overlays;
        for (Object element$iv : $receiver$iv) {
            it = (Pair)element$iv;
            Drawable drawable3 = (Drawable)it.getFirst();
            if (drawable3 == null) continue;
            drawable3.draw(canvas);
        }
        canvas.restore();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this.TAG);
        Attributes attributes = this.attributes;
        if (attributes != null) {
            int n;
            Attributes attributes2 = attributes;
            Attributes it = attributes2;
            int n2 = 0;
            Attributes attributes3 = this.attributes;
            if (attributes3 == null) {
                Intrinsics.throwNpe();
            }
            if (n2 <= (n = attributes3.getLength() - 1)) {
                while (true) {
                    void i;
                    sb.append(' ');
                    Attributes attributes4 = this.attributes;
                    if (attributes4 == null) {
                        Intrinsics.throwNpe();
                    }
                    sb.append(attributes4.getLocalName((int)i));
                    sb.append("=\"");
                    Attributes attributes5 = this.attributes;
                    if (attributes5 == null) {
                        Intrinsics.throwNpe();
                    }
                    sb.append(attributes5.getValue((int)i));
                    sb.append("\"");
                    if (i == n) break;
                    ++i;
                }
            }
        }
        sb.append("/>");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public final void onClick(@NotNull View view) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            AztecText.OnMediaTappedListener onMediaTappedListener = this.onMediaTappedListener;
            if (onMediaTappedListener == null) break block0;
            onMediaTappedListener.mediaTapped(this.attributes, AztecMediaSpan.Companion.getWidth(this.drawable), AztecMediaSpan.Companion.getHeight(this.drawable));
        }
    }

    @NotNull
    public final String getSource() {
        Object object = this.attributes;
        if (object == null || (object = object.getValue("src")) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final Attributes getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@Nullable Attributes attributes) {
        this.attributes = attributes;
    }

    @Nullable
    public final AztecText.OnMediaTappedListener getOnMediaTappedListener() {
        return this.onMediaTappedListener;
    }

    public AztecMediaSpan(@NotNull Context context, @Nullable Drawable drawable2, @Nullable Attributes attributes, @Nullable AztecText.OnMediaTappedListener onMediaTappedListener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.drawable = drawable2;
        this.attributes = attributes;
        this.onMediaTappedListener = onMediaTappedListener;
        this.TAG = "img";
        Drawable drawable3 = this.drawable;
        if (drawable3 == null || (drawable3 = drawable3.getBounds()) == null) {
            drawable3 = new Rect(0, 0, 0, 0);
        }
        this.originalBounds = new Rect((Rect)drawable3);
        this.aspectRatio = 1.0;
        this.overlays = new ArrayList();
        this.computeAspectRatio();
        AztecMediaSpan.Companion.setInitBounds(this.drawable);
    }

    @JvmStatic
    private static final void setInitBounds(Drawable drawable2) {
        AztecMediaSpan.Companion.setInitBounds(drawable2);
    }

    @JvmStatic
    private static final int getWidth(Drawable drawable2) {
        return AztecMediaSpan.Companion.getWidth(drawable2);
    }

    @JvmStatic
    private static final int getHeight(Drawable drawable2) {
        return AztecMediaSpan.Companion.getHeight(drawable2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0003\u00a8\u0006\n"}, d2={"Lorg/wordpress/aztec/spans/AztecMediaSpan$Companion;", "", "()V", "getHeight", "", "drawable", "Landroid/graphics/drawable/Drawable;", "getWidth", "setInitBounds", "", "aztec_release"})
    public static final class Companion {
        @JvmStatic
        private final void setInitBounds(Drawable drawable2) {
            block1: {
                Drawable drawable3 = drawable2;
                if (drawable3 == null) break block1;
                Drawable drawable4 = drawable3;
                Drawable it = drawable4;
                if (it.getBounds().isEmpty() && (it.getIntrinsicWidth() > -1 || it.getIntrinsicHeight() > -1)) {
                    it.setBounds(0, 0, it.getIntrinsicWidth(), it.getIntrinsicHeight());
                }
            }
        }

        @JvmStatic
        private final int getWidth(Drawable drawable2) {
            Drawable drawable3 = drawable2;
            if (drawable3 != null) {
                Drawable drawable4 = drawable3;
                Drawable it = drawable4;
                if (it.getIntrinsicWidth() < 0) {
                    return it.getBounds().width();
                }
                return it.getIntrinsicWidth();
            }
            return 0;
        }

        @JvmStatic
        private final int getHeight(Drawable drawable2) {
            Drawable drawable3 = drawable2;
            if (drawable3 != null) {
                Drawable drawable4 = drawable3;
                Drawable it = drawable4;
                if (it.getIntrinsicHeight() < 0) {
                    return it.getBounds().height();
                }
                return it.getIntrinsicHeight();
            }
            return 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

