/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec;

import android.graphics.Rect;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.ArrowKeyMovementMethod;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.spans.AztecMediaClickableSpan;
import org.wordpress.aztec.spans.UnknownClickableSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/wordpress/aztec/EnhancedMovementMethod;", "Landroid/text/method/ArrowKeyMovementMethod;", "()V", "onTouchEvent", "", "widget", "Landroid/widget/TextView;", "text", "Landroid/text/Spannable;", "event", "Landroid/view/MotionEvent;", "aztec_release"})
public final class EnhancedMovementMethod
extends ArrowKeyMovementMethod {
    public static final EnhancedMovementMethod INSTANCE;

    public boolean onTouchEvent(@NotNull TextView widget, @NotNull Spannable text, @NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int action = event.getAction();
        if (action == 1 || action == 0) {
            ClickableSpan link;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout = widget.getLayout();
            int line = layout.getLineForVertical(y += widget.getScrollY());
            int off = layout.getOffsetForHorizontal(line, (float)(x += widget.getScrollX()));
            float charX = layout.getPrimaryHorizontal(off);
            float charPrevX = off > 0 ? layout.getPrimaryHorizontal(off - 1) : charX;
            float charNextX = off < text.length() ? layout.getPrimaryHorizontal(off + 1) : charX;
            Rect lineRect = new Rect();
            layout.getLineBounds(line, lineRect);
            if (((float)x >= charPrevX && (float)x <= charX || (float)x >= charX && (float)x <= charNextX) && y >= lineRect.top && y <= lineRect.bottom && (link = (ClickableSpan)ArraysKt.firstOrNull((Object[])text.getSpans(off, off, ClickableSpan.class))) != null && (link instanceof AztecMediaClickableSpan || link instanceof UnknownClickableSpan)) {
                if (action == 1) {
                    link.onClick((View)widget);
                } else {
                    Selection.setSelection((Spannable)text, (int)text.getSpanStart((Object)link), (int)text.getSpanEnd((Object)link));
                }
                return true;
            }
        }
        return super.onTouchEvent(widget, text, event);
    }

    private EnhancedMovementMethod() {
        INSTANCE = this;
    }

    static {
        new EnhancedMovementMethod();
    }
}

