/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.spans;

import android.graphics.Paint;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.UpdateLayout;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wordpress.aztec.TextFormat;
import org.wordpress.aztec.spans.AztecContentSpan;
import org.wordpress.aztec.spans.AztecHeadingSpan$WhenMappings;
import org.wordpress.aztec.spans.AztecInlineSpan;
import org.wordpress.aztec.spans.AztecLineBlockSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ?2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0002?@B#\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB!\b\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ8\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u001cH\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020\bH\u0016J\b\u00109\u001a\u00020\bH\u0016J\b\u0010:\u001a\u00020\bH\u0002J\u0010\u0010;\u001a\u00020.2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020.2\u0006\u0010<\u001a\u00020=H\u0016R\u001a\u0010\u0010\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006A"}, d2={"Lorg/wordpress/aztec/spans/AztecHeadingSpan;", "Landroid/text/style/MetricAffectingSpan;", "Lorg/wordpress/aztec/spans/AztecLineBlockSpan;", "Lorg/wordpress/aztec/spans/AztecContentSpan;", "Lorg/wordpress/aztec/spans/AztecInlineSpan;", "Landroid/text/style/LineHeightSpan;", "Landroid/text/style/UpdateLayout;", "tag", "", "attrs", "verticalPadding", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "textFormat", "Lorg/wordpress/aztec/TextFormat;", "(Lorg/wordpress/aztec/TextFormat;Ljava/lang/String;I)V", "attributes", "getAttributes", "()Ljava/lang/String;", "setAttributes", "(Ljava/lang/String;)V", "heading", "Lorg/wordpress/aztec/spans/AztecHeadingSpan$Heading;", "getHeading", "()Lorg/wordpress/aztec/spans/AztecHeadingSpan$Heading;", "setHeading", "(Lorg/wordpress/aztec/spans/AztecHeadingSpan$Heading;)V", "previousFontMetrics", "Landroid/graphics/Paint$FontMetricsInt;", "getPreviousFontMetrics", "()Landroid/graphics/Paint$FontMetricsInt;", "setPreviousFontMetrics", "(Landroid/graphics/Paint$FontMetricsInt;)V", "previousTextScale", "", "getPreviousTextScale", "()F", "setPreviousTextScale", "(F)V", "getTextFormat", "()Lorg/wordpress/aztec/TextFormat;", "setTextFormat", "(Lorg/wordpress/aztec/TextFormat;)V", "getVerticalPadding", "()I", "chooseHeight", "", "text", "", "start", "end", "spanstartv", "v", "fm", "clone", "", "getEndTag", "getStartTag", "getTag", "updateDrawState", "textPaint", "Landroid/text/TextPaint;", "updateMeasureState", "Companion", "Heading", "aztec_release"})
public final class AztecHeadingSpan
extends MetricAffectingSpan
implements AztecLineBlockSpan,
AztecContentSpan,
AztecInlineSpan,
LineHeightSpan,
UpdateLayout {
    @NotNull
    public Heading heading;
    @NotNull
    private String attributes;
    @Nullable
    private Paint.FontMetricsInt previousFontMetrics;
    private float previousTextScale;
    @NotNull
    private TextFormat textFormat;
    private final int verticalPadding;
    private static final float SCALE_H1 = 1.73f;
    private static final float SCALE_H2 = 1.32f;
    private static final float SCALE_H3 = 1.02f;
    private static final float SCALE_H4 = 0.87f;
    private static final float SCALE_H5 = 0.72f;
    private static final float SCALE_H6 = 0.6f;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Heading getHeading() {
        Heading heading = this.heading;
        if (heading == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        return heading;
    }

    public final void setHeading(@NotNull Heading heading) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)heading), (String)"<set-?>");
        this.heading = heading;
    }

    @Override
    @NotNull
    public String getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.attributes = string;
    }

    @Nullable
    public final Paint.FontMetricsInt getPreviousFontMetrics() {
        return this.previousFontMetrics;
    }

    public final void setPreviousFontMetrics(@Nullable Paint.FontMetricsInt fontMetricsInt) {
        this.previousFontMetrics = fontMetricsInt;
    }

    public final float getPreviousTextScale() {
        return this.previousTextScale;
    }

    public final void setPreviousTextScale(float f) {
        this.previousTextScale = f;
    }

    public void chooseHeight(@NotNull CharSequence text, int start, int end, int spanstartv, int v, @NotNull Paint.FontMetricsInt fm) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)fm, (String)"fm");
        CharSequence charSequence = text;
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        Spanned spanned = (Spanned)charSequence;
        int spanStart = spanned.getSpanStart((Object)this);
        int spanEnd = spanned.getSpanEnd((Object)this);
        if (this.previousFontMetrics == null) {
            this.previousFontMetrics = new Paint.FontMetricsInt();
            if (this.previousFontMetrics == null) {
                Intrinsics.throwNpe();
            }
            this.previousFontMetrics.top = fm.top;
            if (this.previousFontMetrics == null) {
                Intrinsics.throwNpe();
            }
            this.previousFontMetrics.ascent = fm.ascent;
            if (this.previousFontMetrics == null) {
                Intrinsics.throwNpe();
            }
            this.previousFontMetrics.bottom = fm.bottom;
            if (this.previousFontMetrics == null) {
                Intrinsics.throwNpe();
            }
            this.previousFontMetrics.descent = fm.descent;
        }
        boolean addedTopPadding = false;
        boolean addedBottomPadding = false;
        if (start == spanStart || start < spanStart) {
            fm.ascent -= this.verticalPadding;
            fm.top -= this.verticalPadding;
            addedTopPadding = true;
        }
        if (end == spanEnd || spanEnd < end) {
            fm.descent += this.verticalPadding;
            fm.bottom += this.verticalPadding;
            addedBottomPadding = true;
        }
        if (!addedTopPadding) {
            Paint.FontMetricsInt fontMetricsInt = this.previousFontMetrics;
            if (fontMetricsInt == null) {
                Intrinsics.throwNpe();
            }
            fm.ascent = fontMetricsInt.ascent;
            Paint.FontMetricsInt fontMetricsInt2 = this.previousFontMetrics;
            if (fontMetricsInt2 == null) {
                Intrinsics.throwNpe();
            }
            fm.top = fontMetricsInt2.top;
        }
        if (!addedBottomPadding) {
            Paint.FontMetricsInt fontMetricsInt = this.previousFontMetrics;
            if (fontMetricsInt == null) {
                Intrinsics.throwNpe();
            }
            fm.descent = fontMetricsInt.descent;
            Paint.FontMetricsInt fontMetricsInt3 = this.previousFontMetrics;
            if (fontMetricsInt3 == null) {
                Intrinsics.throwNpe();
            }
            fm.bottom = fontMetricsInt3.bottom;
        }
    }

    @Override
    @NotNull
    public String getStartTag() {
        if (TextUtils.isEmpty((CharSequence)this.getAttributes())) {
            return this.getTag();
        }
        return this.getTag() + this.getAttributes();
    }

    @Override
    @NotNull
    public String getEndTag() {
        return this.getTag();
    }

    public void updateDrawState(@NotNull TextPaint textPaint) {
        Intrinsics.checkParameterIsNotNull((Object)textPaint, (String)"textPaint");
        TextPaint textPaint2 = textPaint;
        float f = textPaint2.getTextSize();
        Heading heading = this.heading;
        if (heading == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        textPaint2.setTextSize(f * heading.getScale$aztec_release());
        textPaint.setFakeBoldText(true);
    }

    public void updateMeasureState(@NotNull TextPaint textPaint) {
        Intrinsics.checkParameterIsNotNull((Object)textPaint, (String)"textPaint");
        Heading heading = this.heading;
        if (heading == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        if (this.previousTextScale != heading.getScale$aztec_release()) {
            this.previousFontMetrics = null;
        }
        Heading heading2 = this.heading;
        if (heading2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        this.previousTextScale = heading2.getScale$aztec_release();
        TextPaint textPaint2 = textPaint;
        float f = textPaint2.getTextSize();
        Heading heading3 = this.heading;
        if (heading3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        textPaint2.setTextSize(f * heading3.getScale$aztec_release());
    }

    private final String getTag() {
        float f;
        Heading heading = this.heading;
        if (heading == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"heading");
        }
        if ((f = heading.getScale$aztec_release()) == AztecHeadingSpan.Companion.getSCALE_H1()) {
            return "h1";
        }
        if (f == AztecHeadingSpan.Companion.getSCALE_H2()) {
            return "h2";
        }
        if (f == AztecHeadingSpan.Companion.getSCALE_H3()) {
            return "h3";
        }
        if (f == AztecHeadingSpan.Companion.getSCALE_H4()) {
            return "h4";
        }
        if (f == AztecHeadingSpan.Companion.getSCALE_H5()) {
            return "h5";
        }
        if (f == AztecHeadingSpan.Companion.getSCALE_H6()) {
            return "h6";
        }
        return "p";
    }

    @Override
    @NotNull
    public Object clone() {
        return new AztecHeadingSpan(this.textFormat, this.getAttributes(), this.verticalPadding);
    }

    @NotNull
    public final TextFormat getTextFormat() {
        return this.textFormat;
    }

    public final void setTextFormat(@NotNull TextFormat textFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"<set-?>");
        this.textFormat = textFormat;
    }

    public final int getVerticalPadding() {
        return this.verticalPadding;
    }

    @JvmOverloads
    public AztecHeadingSpan(@NotNull TextFormat textFormat, @NotNull String attrs, int verticalPadding) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)textFormat), (String)"textFormat");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        this.textFormat = textFormat;
        this.verticalPadding = verticalPadding;
        this.attributes = attrs;
        this.previousTextScale = 1.0f;
        switch (AztecHeadingSpan$WhenMappings.$EnumSwitchMapping$0[this.textFormat.ordinal()]) {
            case 1: {
                this.heading = Heading.H1;
                break;
            }
            case 2: {
                this.heading = Heading.H2;
                break;
            }
            case 3: {
                this.heading = Heading.H3;
                break;
            }
            case 4: {
                this.heading = Heading.H4;
                break;
            }
            case 5: {
                this.heading = Heading.H5;
                break;
            }
            case 6: {
                this.heading = Heading.H6;
            }
        }
    }

    @JvmOverloads
    public /* synthetic */ AztecHeadingSpan(TextFormat textFormat, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "";
        }
        this(textFormat, string, n);
    }

    @JvmOverloads
    public AztecHeadingSpan(@NotNull TextFormat textFormat, int verticalPadding) {
        this(textFormat, null, verticalPadding, 2, null);
    }

    public AztecHeadingSpan(@NotNull String tag, @NotNull String attrs, int verticalPadding) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        this(Companion.getTextFormat(tag), attrs, verticalPadding);
    }

    public /* synthetic */ AztecHeadingSpan(String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(string, string2, n);
    }

    static {
        SCALE_H1 = 1.73f;
        SCALE_H2 = 1.32f;
        SCALE_H3 = 1.02f;
        SCALE_H4 = 0.87f;
        SCALE_H5 = 0.72f;
        SCALE_H6 = 0.6f;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/wordpress/aztec/spans/AztecHeadingSpan$Heading;", "", "scale", "", "(Ljava/lang/String;IF)V", "getScale$aztec_release", "()F", "H1", "H2", "H3", "H4", "H5", "H6", "aztec_release"})
    public static final class Heading
    extends Enum<Heading> {
        public static final /* enum */ Heading H1;
        public static final /* enum */ Heading H2;
        public static final /* enum */ Heading H3;
        public static final /* enum */ Heading H4;
        public static final /* enum */ Heading H5;
        public static final /* enum */ Heading H6;
        private static final /* synthetic */ Heading[] $VALUES;
        private final float scale;

        static {
            Heading[] headingArray = new Heading[6];
            Heading[] headingArray2 = headingArray;
            headingArray[0] = H1 = new Heading(Companion.getSCALE_H1());
            headingArray[1] = H2 = new Heading(Companion.getSCALE_H2());
            headingArray[2] = H3 = new Heading(Companion.getSCALE_H3());
            headingArray[3] = H4 = new Heading(Companion.getSCALE_H4());
            headingArray[4] = H5 = new Heading(Companion.getSCALE_H5());
            headingArray[5] = H6 = new Heading(Companion.getSCALE_H6());
            $VALUES = headingArray;
        }

        public final float getScale$aztec_release() {
            return this.scale;
        }

        protected Heading(float scale) {
            this.scale = scale;
        }

        public static Heading[] values() {
            return (Heading[])$VALUES.clone();
        }

        public static Heading valueOf(String string) {
            return Enum.valueOf(Heading.class, string);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/wordpress/aztec/spans/AztecHeadingSpan$Companion;", "", "()V", "SCALE_H1", "", "getSCALE_H1", "()F", "SCALE_H2", "getSCALE_H2", "SCALE_H3", "getSCALE_H3", "SCALE_H4", "getSCALE_H4", "SCALE_H5", "getSCALE_H5", "SCALE_H6", "getSCALE_H6", "getTextFormat", "Lorg/wordpress/aztec/TextFormat;", "tag", "", "aztec_release"})
    public static final class Companion {
        private final float getSCALE_H1() {
            return SCALE_H1;
        }

        private final float getSCALE_H2() {
            return SCALE_H2;
        }

        private final float getSCALE_H3() {
            return SCALE_H3;
        }

        private final float getSCALE_H4() {
            return SCALE_H4;
        }

        private final float getSCALE_H5() {
            return SCALE_H5;
        }

        private final float getSCALE_H6() {
            return SCALE_H6;
        }

        @NotNull
        public final TextFormat getTextFormat(@NotNull String tag) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            String string = tag;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            switch (string3) {
                case "h1": {
                    return TextFormat.FORMAT_HEADING_1;
                }
                case "h2": {
                    return TextFormat.FORMAT_HEADING_2;
                }
                case "h3": {
                    return TextFormat.FORMAT_HEADING_3;
                }
                case "h4": {
                    return TextFormat.FORMAT_HEADING_4;
                }
                case "h5": {
                    return TextFormat.FORMAT_HEADING_5;
                }
                case "h6": {
                    return TextFormat.FORMAT_HEADING_6;
                }
            }
            return TextFormat.FORMAT_PARAGRAPH;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

