/*
 * Decompiled with CFR 0.152.
 */
package org.wordpress.aztec.source;

import android.os.Build;
import android.support.annotation.ColorInt;
import android.text.Spannable;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.wordpress.aztec.spans.AztecStyleSpan;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0001\u0010\u0013\u001a\u00020\t2\b\b\u0001\u0010\u0014\u001a\u00020\tH\u0002J\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tJ2\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0001\u0010\u0013\u001a\u00020\t2\b\b\u0001\u0010\u0014\u001a\u00020\tJ\"\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0013\u001a\u00020\t2\b\b\u0001\u0010\u0014\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/wordpress/aztec/source/HtmlStyleUtils;", "", "()V", "REGEX_HTML_ATTRIBUTES", "", "REGEX_HTML_COMMENTS", "REGEX_HTML_ENTITIES", "REGEX_HTML_TAGS", "SPANNABLE_FLAGS", "", "getSPANNABLE_FLAGS", "()I", "applySpansByRegex", "", "content", "Landroid/text/Spannable;", "start", "end", "regex", "tagColor", "attributeColor", "clearSpans", "spanStart", "spanEnd", "styleHtmlForDisplay", "styleHtmlForDisplayWithColors", "aztec_release"})
public final class HtmlStyleUtils {
    private static final String REGEX_HTML_TAGS = "(<\\/?[a-z][^<>]*>)";
    private static final String REGEX_HTML_ATTRIBUTES = "(?<==)('|\")(.*?\\1)(?=.*?>)";
    private static final String REGEX_HTML_COMMENTS = "(<!--.*?-->)";
    private static final String REGEX_HTML_ENTITIES = "(&#34;|&#38;|&#39;|&#60;|&#62;|&#160;|&#161;|&#162;|&#163;|&#164;|&#165;|&#166;|&#167;|&#168;|&#169;|&#170;|&#171;|&#172;|&#173;|&#174;|&#175;|&#176;|&#177;|&#178;|&#179;|&#180;|&#181;|&#182;|&#183;|&#184;|&#185;|&#186;|&#187;|&#188;|&#189;|&#190;|&#191;|&#192;|&#193;|&#194;|&#195;|&#196;|&#197;|&#198;|&#199;|&#200;|&#201;|&#202;|&#203;|&#204;|&#205;|&#206;|&#207;|&#208;|&#209;|&#210;|&#211;|&#212;|&#213;|&#214;|&#215;|&#216;|&#217;|&#218;|&#219;|&#220;|&#221;|&#222;|&#223;|&#224;|&#225;|&#226;|&#227;|&#228;|&#229;|&#230;|&#231;|&#232;|&#233;|&#234;|&#235;|&#236;|&#237;|&#238;|&#239;|&#240;|&#241;|&#242;|&#243;|&#244;|&#245;|&#246;|&#247;|&#248;|&#249;|&#250;|&#251;|&#252;|&#253;|&#254;|&#255;|&#338;|&#339;|&#352;|&#353;|&#376;|&#402;|&#710;|&#732;|&#913;|&#914;|&#915;|&#916;|&#917;|&#918;|&#919;|&#920;|&#921;|&#922;|&#923;|&#924;|&#925;|&#926;|&#927;|&#928;|&#929;|&#931;|&#932;|&#933;|&#934;|&#935;|&#936;|&#937;|&#945;|&#946;|&#947;|&#948;|&#949;|&#950;|&#951;|&#952;|&#953;|&#954;|&#955;|&#956;|&#957;|&#958;|&#959;|&#960;|&#961;|&#962;|&#963;|&#964;|&#965;|&#966;|&#967;|&#968;|&#969;|&#977;|&#978;|&#982;|&#8194;|&#8195;|&#8201;|&#8204;|&#8205;|&#8206;|&#8207;|&#8211;|&#8212;|&#8216;|&#8217;|&#8218;|&#8220;|&#8221;|&#8222;|&#8224;|&#8225;|&#8226;|&#8230;|&#8240;|&#8242;|&#8243;|&#8249;|&#8250;|&#8254;|&#8260;|&#8364;|&#8465;|&#8472;|&#8476;|&#8482;|&#8501;|&#8592;|&#8593;|&#8594;|&#8595;|&#8596;|&#8629;|&#8656;|&#8657;|&#8658;|&#8659;|&#8660;|&#8704;|&#8706;|&#8707;|&#8709;|&#8711;|&#8712;|&#8713;|&#8715;|&#8719;|&#8721;|&#8722;|&#8727;|&#8730;|&#8733;|&#8734;|&#8736;|&#8743;|&#8744;|&#8745;|&#8746;|&#8747;|&#8756;|&#8764;|&#8773;|&#8776;|&#8800;|&#8801;|&#8804;|&#8805;|&#8834;|&#8835;|&#8836;|&#8838;|&#8839;|&#8853;|&#8855;|&#8869;|&#8901;|&#8968;|&#8969;|&#8970;|&#8971;|&#9001;|&#9002;|&#9674;|&#9824;|&#9827;|&#9829;|&#9830;|&quot;|&amp;|&apos;|&lt;|&gt;|&nbsp;|&iexcl;|&cent;|&pound;|&curren;|&yen;|&brvbar;|&sect;|&uml;|&copy;|&ordf;|&laquo;|&not;|&shy;|&reg;|&macr;|&deg;|&plusmn;|&sup2;|&sup3;|&acute;|&micro;|&para;|&middot;|&cedil;|&sup1;|&ordm;|&raquo;|&frac14;|&frac12;|&frac34;|&iquest;|&Agrave;|&Aacute;|&Acirc;|&Atilde;|&Auml;|&Aring;|&AElig;|&Ccedil;|&Egrave;|&Eacute;|&Ecirc;|&Euml;|&Igrave;|&Iacute;|&Icirc;|&Iuml;|&ETH;|&Ntilde;|&Ograve;|&Oacute;|&Ocirc;|&Otilde;|&Ouml;|&times;|&Oslash;|&Ugrave;|&Uacute;|&Ucirc;|&Uuml;|&Yacute;|&THORN;|&szlig;|&agrave;|&aacute;|&acirc;|&atilde;|&auml;|&aring;|&aelig;|&ccedil;|&egrave;|&eacute;|&ecirc;|&euml;|&igrave;|&iacute;|&icirc;|&iuml;|&eth;|&ntilde;|&ograve;|&oacute;|&ocirc;|&otilde;|&ouml;|&divide;|&oslash;|&Ugrave;|&Uacute;|&Ucirc;|&Uuml;|&yacute;|&thorn;|&yuml;|&OElig;|&oelig;|&Scaron;|&scaron;|&Yuml;|&fnof;|&circ;|&tilde;|&Alpha;|&Beta;|&Gamma;|&Delta;|&Epsilon;|&Zeta;|&Eta;|&Theta;|&Iota;|&Kappa;|&Lambda;|&Mu;|&Nu;|&Xi;|&Omicron;|&Pi;|&Rho;|&Sigma;|&Tau;|&Upsilon;|&Phi;|&Chi;|&Psi;|&Omega;|&alpha;|&beta;|&gamma;|&delta;|&epsilon;|&zeta;|&eta;|&theta;|&iota;|&kappa;|&lambda;|&mu;|&nu;|&xi;|&omicron;|&pi;|&rho;|&sigmaf;|&sigma;|&tau;|&upsilon;|&phi;|&chi;|&psi;|&omega;|&thetasym;|&Upsih;|&piv;|&ensp;|&emsp;|&thinsp;|&zwnj;|&zwj;|&lrm;|&rlm;|&ndash;|&mdash;|&lsquo;|&rsquo;|&sbquo;|&ldquo;|&rdquo;|&bdquo;|&dagger;|&Dagger;|&bull;|&hellip;|&permil;|&prime;|&Prime;|&lsaquo;|&rsaquo;|&oline;|&frasl;|&euro;|&image;|&weierp;|&real;|&trade;|&alefsym;|&larr;|&uarr;|&rarr;|&darr;|&harr;|&crarr;|&lArr;|&UArr;|&rArr;|&dArr;|&hArr;|&forall;|&part;|&exist;|&empty;|&nabla;|&isin;|&notin;|&ni;|&prod;|&sum;|&minus;|&lowast;|&radic;|&prop;|&infin;|&ang;|&and;|&or;|&cap;|&cup;|&int;|&there4;|&sim;|&cong;|&asymp;|&ne;|&equiv;|&le;|&ge;|&sub;|&sup;|&nsub;|&sube;|&supe;|&oplus;|&otimes;|&perp;|&sdot;|&lceil;|&rceil;|&lfloor;|&rfloor;|&lang;|&rang;|&loz;|&spades;|&clubs;|&hearts;|&diams;)";
    private static final int SPANNABLE_FLAGS;
    public static final HtmlStyleUtils INSTANCE;

    public final int getSPANNABLE_FLAGS() {
        return SPANNABLE_FLAGS;
    }

    public final void styleHtmlForDisplayWithColors(@NotNull Spannable content, @ColorInt int tagColor, @ColorInt int attributeColor) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        this.styleHtmlForDisplay(content, 0, content.length(), tagColor, attributeColor);
    }

    public final void styleHtmlForDisplay(@NotNull Spannable content, int start, int end, @ColorInt int tagColor, @ColorInt int attributeColor) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (Intrinsics.areEqual((Object)Build.VERSION.RELEASE, (Object)"4.1") || Intrinsics.areEqual((Object)Build.VERSION.RELEASE, (Object)"4.1.1")) {
            return;
        }
        this.applySpansByRegex(content, start, end, REGEX_HTML_TAGS, tagColor, attributeColor);
        this.applySpansByRegex(content, start, end, REGEX_HTML_ATTRIBUTES, tagColor, attributeColor);
        this.applySpansByRegex(content, start, end, REGEX_HTML_COMMENTS, tagColor, attributeColor);
        this.applySpansByRegex(content, start, end, REGEX_HTML_ENTITIES, tagColor, attributeColor);
    }

    private final void applySpansByRegex(Spannable content, int start, int end, String regex, @ColorInt int tagColor, @ColorInt int attributeColor) {
        if (start < 0 || end < 0 || start > content.length() || end > content.length() || start >= end) {
            return;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content.subSequence(start, end));
        while (matcher.find()) {
            int matchStart = matcher.start() + start;
            int matchEnd = matcher.end() + start;
            String string = regex;
            if (Intrinsics.areEqual((Object)string, (Object)REGEX_HTML_TAGS)) {
                content.setSpan((Object)new ForegroundColorSpan(tagColor), matchStart, matchEnd, SPANNABLE_FLAGS);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)REGEX_HTML_ATTRIBUTES)) {
                content.setSpan((Object)new ForegroundColorSpan(attributeColor), matchStart, matchEnd, SPANNABLE_FLAGS);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)REGEX_HTML_COMMENTS)) {
                content.setSpan((Object)new ForegroundColorSpan(attributeColor), matchStart, matchEnd, SPANNABLE_FLAGS);
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)REGEX_HTML_ENTITIES)) continue;
            content.setSpan((Object)new ForegroundColorSpan(tagColor), matchStart, matchEnd, SPANNABLE_FLAGS);
            content.setSpan((Object)new AztecStyleSpan(1, null, 2, null), matchStart, matchEnd, SPANNABLE_FLAGS);
            content.setSpan((Object)new RelativeSizeSpan(0.75f), matchStart, matchEnd, SPANNABLE_FLAGS);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearSpans(@NotNull Spannable content, int spanStart, int spanEnd) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        CharacterStyle[] spans = (CharacterStyle[])content.getSpans(spanStart, spanEnd, CharacterStyle.class);
        Object[] objectArray = spans;
        Iterator iterator = $receiver$iv;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            CharacterStyle it = (CharacterStyle)element$iv$iv;
            if (!(it instanceof ForegroundColorSpan || it instanceof StyleSpan || it instanceof RelativeSizeSpan)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            CharacterStyle it = (CharacterStyle)element$iv;
            content.removeSpan((Object)it);
        }
    }

    private HtmlStyleUtils() {
        INSTANCE = this;
        REGEX_HTML_TAGS = REGEX_HTML_TAGS;
        REGEX_HTML_ATTRIBUTES = REGEX_HTML_ATTRIBUTES;
        REGEX_HTML_COMMENTS = REGEX_HTML_COMMENTS;
        REGEX_HTML_ENTITIES = REGEX_HTML_ENTITIES;
        SPANNABLE_FLAGS = Spannable.SPAN_EXCLUSIVE_EXCLUSIVE;
    }

    static {
        new HtmlStyleUtils();
    }
}

