/*
 * Decompiled with CFR 0.152.
 */
package io.alterac.blurkit;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class RoundedImageView
extends ImageView {
    private float mCornerRadius = 0.0f;
    public static final int DEFAULT_COLOR = -16777216;
    public static final int DEFAULT_RGB = 0;
    private RectF rectF = new RectF();
    private PorterDuffXfermode porterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);

    public RoundedImageView(Context context) {
        super(context, null);
    }

    public RoundedImageView(Context context, AttributeSet attributes) {
        super(context, attributes);
    }

    protected void onDraw(Canvas canvas) {
        Drawable myDrawable = this.getDrawable();
        if (myDrawable != null && myDrawable instanceof BitmapDrawable && this.mCornerRadius > 0.0f) {
            this.rectF.set(myDrawable.getBounds());
            int prevCount = canvas.saveLayer(this.rectF, null, 31);
            this.getImageMatrix().mapRect(this.rectF);
            Paint paint = ((BitmapDrawable)myDrawable).getPaint();
            paint.setAntiAlias(true);
            paint.setColor(-16777216);
            Xfermode prevMode = paint.getXfermode();
            canvas.drawARGB(0, 0, 0, 0);
            canvas.drawRoundRect(this.rectF, this.mCornerRadius, this.mCornerRadius, paint);
            paint.setXfermode((Xfermode)this.porterDuffXfermode);
            super.onDraw(canvas);
            paint.setXfermode(prevMode);
            canvas.restoreToCount(prevCount);
        } else {
            super.onDraw(canvas);
        }
    }

    public void setCornerRadius(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }
}

