/*
 * Decompiled with CFR 0.152.
 */
package io.alterac.blurkit;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import io.alterac.blurkit.BlurKit;
import io.alterac.blurkit.BlurKitException;
import io.alterac.blurkit.R;
import io.alterac.blurkit.RoundedImageView;
import java.lang.ref.WeakReference;

public class BlurLayout
extends FrameLayout {
    public static final float DEFAULT_DOWNSCALE_FACTOR = 0.12f;
    public static final int DEFAULT_BLUR_RADIUS = 12;
    public static final int DEFAULT_FPS = 60;
    public static final float DEFAULT_CORNER_RADIUS = 0.0f;
    public static final float DEFAULT_ALPHA = Float.NaN;
    private float mDownscaleFactor;
    private int mBlurRadius;
    private int mFPS;
    private float mCornerRadius;
    private float mAlpha;
    private boolean mRunning;
    private boolean mAttachedToWindow;
    private boolean mPositionLocked;
    private boolean mViewLocked;
    private RoundedImageView mImageView;
    private WeakReference<View> mActivityView;
    private Point mLockedPoint;
    private Bitmap mLockedBitmap;
    private Choreographer.FrameCallback invalidationLoop = new Choreographer.FrameCallback(){

        public void doFrame(long frameTimeNanos) {
            BlurLayout.this.invalidate();
            Choreographer.getInstance().postFrameCallbackDelayed((Choreographer.FrameCallback)this, (long)(1000 / BlurLayout.this.mFPS));
        }
    };

    public BlurLayout(Context context) {
        super(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlurLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            BlurKit.init(context);
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BlurLayout, 0, 0);
        try {
            this.mDownscaleFactor = a.getFloat(R.styleable.BlurLayout_blk_downscaleFactor, 0.12f);
            this.mBlurRadius = a.getInteger(R.styleable.BlurLayout_blk_blurRadius, 12);
            this.mFPS = a.getInteger(R.styleable.BlurLayout_blk_fps, 60);
            this.mCornerRadius = a.getDimension(R.styleable.BlurLayout_blk_cornerRadius, 0.0f);
            this.mAlpha = a.getDimension(R.styleable.BlurLayout_blk_alpha, Float.NaN);
        }
        finally {
            a.recycle();
        }
        this.mImageView = new RoundedImageView(this.getContext());
        this.mImageView.setScaleType(ImageView.ScaleType.FIT_XY);
        this.addView((View)this.mImageView);
        this.setCornerRadius(this.mCornerRadius);
    }

    public void startBlur() {
        if (this.mRunning) {
            return;
        }
        if (this.mFPS > 0) {
            this.mRunning = true;
            Choreographer.getInstance().postFrameCallback(this.invalidationLoop);
        }
    }

    public void pauseBlur() {
        if (!this.mRunning) {
            return;
        }
        this.mRunning = false;
        Choreographer.getInstance().removeFrameCallback(this.invalidationLoop);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.startBlur();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttachedToWindow = false;
        this.pauseBlur();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.invalidate();
    }

    public void invalidate() {
        super.invalidate();
        Bitmap bitmap = this.blur();
        if (bitmap != null) {
            this.mImageView.setImageBitmap(bitmap);
        }
    }

    private Bitmap blur() {
        Bitmap bitmap;
        Point pointRelativeToActivityView;
        if (this.getContext() == null || this.isInEditMode()) {
            return null;
        }
        if (this.mActivityView == null || this.mActivityView.get() == null) {
            this.mActivityView = new WeakReference<View>(this.getActivityView());
            if (this.mActivityView.get() == null) {
                return null;
            }
        }
        if (this.mPositionLocked) {
            if (this.mLockedPoint == null) {
                this.mLockedPoint = this.getPositionInScreen();
            }
            pointRelativeToActivityView = this.mLockedPoint;
        } else {
            pointRelativeToActivityView = this.getPositionInScreen();
        }
        super.setAlpha(0.0f);
        int screenWidth = ((View)this.mActivityView.get()).getWidth();
        int screenHeight = ((View)this.mActivityView.get()).getHeight();
        int width = (int)((float)this.getWidth() * this.mDownscaleFactor);
        int height = (int)((float)this.getHeight() * this.mDownscaleFactor);
        int x = (int)((float)pointRelativeToActivityView.x * this.mDownscaleFactor);
        int y = (int)((float)pointRelativeToActivityView.y * this.mDownscaleFactor);
        int xPadding = this.getWidth() / 8;
        int yPadding = this.getHeight() / 8;
        int leftOffset = -xPadding;
        leftOffset = x + leftOffset >= 0 ? leftOffset : 0;
        int rightOffset = xPadding;
        rightOffset = x + screenWidth - rightOffset <= screenWidth ? rightOffset : screenWidth + screenWidth - x;
        int topOffset = -yPadding;
        topOffset = y + topOffset >= 0 ? topOffset : 0;
        int bottomOffset = yPadding;
        int n = bottomOffset = y + this.getHeight() + bottomOffset <= screenHeight ? bottomOffset : 0;
        if (this.mViewLocked) {
            if (this.mLockedBitmap == null) {
                this.lockView();
            }
            if (width == 0 || height == 0) {
                return null;
            }
            bitmap = Bitmap.createBitmap((Bitmap)this.mLockedBitmap, (int)x, (int)y, (int)width, (int)height);
        } else {
            try {
                bitmap = this.getDownscaledBitmapForView((View)this.mActivityView.get(), new Rect(pointRelativeToActivityView.x + leftOffset, pointRelativeToActivityView.y + topOffset, pointRelativeToActivityView.x + this.getWidth() + Math.abs(leftOffset) + rightOffset, pointRelativeToActivityView.y + this.getHeight() + Math.abs(topOffset) + bottomOffset), this.mDownscaleFactor);
            }
            catch (BlurKitException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        if (!this.mViewLocked) {
            bitmap = BlurKit.getInstance().blur(bitmap, this.mBlurRadius);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)((float)Math.abs(leftOffset) * this.mDownscaleFactor)), (int)((int)((float)Math.abs(topOffset) * this.mDownscaleFactor)), (int)width, (int)height);
        }
        if (Float.isNaN(this.mAlpha)) {
            super.setAlpha(1.0f);
        } else {
            super.setAlpha(this.mAlpha);
        }
        return bitmap;
    }

    private View getActivityView() {
        Activity activity;
        try {
            activity = (Activity)this.getContext();
        }
        catch (ClassCastException e) {
            return null;
        }
        return activity.getWindow().getDecorView().findViewById(0x1020002);
    }

    private Point getPositionInScreen() {
        PointF pointF = this.getPositionInScreen((View)this);
        return new Point((int)pointF.x, (int)pointF.y);
    }

    private PointF getPositionInScreen(View view) {
        ViewGroup parent;
        if (this.getParent() == null) {
            return new PointF();
        }
        try {
            parent = (ViewGroup)view.getParent();
        }
        catch (Exception e) {
            return new PointF();
        }
        if (parent == null) {
            return new PointF();
        }
        PointF point = this.getPositionInScreen((View)parent);
        point.offset(view.getX(), view.getY());
        return point;
    }

    private Bitmap getDownscaledBitmapForView(View view, Rect crop, float downscaleFactor) throws BlurKitException, NullPointerException {
        View screenView = view.getRootView();
        int width = (int)((float)crop.width() * downscaleFactor);
        int height = (int)((float)crop.height() * downscaleFactor);
        if (screenView.getWidth() <= 0 || screenView.getHeight() <= 0 || width <= 0 || height <= 0) {
            throw new BlurKitException("No screen available (width or height = 0)");
        }
        float dx = (float)(-crop.left) * downscaleFactor;
        float dy = (float)(-crop.top) * downscaleFactor;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Matrix matrix = new Matrix();
        matrix.preScale(downscaleFactor, downscaleFactor);
        matrix.postTranslate(dx, dy);
        canvas.setMatrix(matrix);
        screenView.draw(canvas);
        return bitmap;
    }

    public void setDownscaleFactor(float downscaleFactor) {
        this.mDownscaleFactor = downscaleFactor;
        this.mLockedBitmap = null;
        this.invalidate();
    }

    public float getDownscaleFactor() {
        return this.mDownscaleFactor;
    }

    public void setBlurRadius(int blurRadius) {
        this.mBlurRadius = blurRadius;
        this.mLockedBitmap = null;
        this.invalidate();
    }

    public int getBlurRadius() {
        return this.mBlurRadius;
    }

    public void setFPS(int fps) {
        if (this.mRunning) {
            this.pauseBlur();
        }
        this.mFPS = fps;
        if (this.mAttachedToWindow) {
            this.startBlur();
        }
    }

    public int getFPS() {
        return this.mFPS;
    }

    public void setCornerRadius(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        if (this.mImageView != null) {
            this.mImageView.setCornerRadius(cornerRadius);
        }
        this.invalidate();
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
        if (!this.mViewLocked) {
            super.setAlpha(this.mAlpha);
        }
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void lockView() {
        this.mViewLocked = true;
        if (this.mActivityView != null && this.mActivityView.get() != null) {
            View view = ((View)this.mActivityView.get()).getRootView();
            try {
                super.setAlpha(0.0f);
                this.mLockedBitmap = this.getDownscaledBitmapForView(view, new Rect(0, 0, view.getWidth(), view.getHeight()), this.mDownscaleFactor);
                if (Float.isNaN(this.mAlpha)) {
                    super.setAlpha(1.0f);
                } else {
                    super.setAlpha(this.mAlpha);
                }
                this.mLockedBitmap = BlurKit.getInstance().blur(this.mLockedBitmap, this.mBlurRadius);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void unlockView() {
        this.mViewLocked = false;
        this.mLockedBitmap = null;
    }

    public boolean getViewLocked() {
        return this.mViewLocked;
    }

    public void lockPosition() {
        this.mPositionLocked = true;
        this.mLockedPoint = this.getPositionInScreen();
    }

    public void unlockPosition() {
        this.mPositionLocked = false;
        this.mLockedPoint = null;
    }

    public boolean getPositionLocked() {
        return this.mPositionLocked;
    }
}

