/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.unflattener;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.KeyTransformer;
import com.github.wnameless.json.flattener.PrintMode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public final class JsonUnflattener {
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonNode root;
    private FlattenMode flattenMode = FlattenMode.NORMAL;
    private Character separator = Character.valueOf('.');
    private Character leftBracket = Character.valueOf('[');
    private Character rightBracket = Character.valueOf(']');
    private PrintMode printMode = PrintMode.MINIMAL;
    private KeyTransformer keyTrans = null;

    public static String unflatten(String json) {
        return new JsonUnflattener(json).unflatten();
    }

    private JsonNode parseJson(String json) {
        try {
            return this.mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonUnflattener(String json) {
        JsonNode jsonNode;
        try {
            jsonNode = this.mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.root = jsonNode;
    }

    public JsonUnflattener(Reader jsonReader) throws IOException {
        JsonNode jsonNode;
        try {
            jsonNode = this.mapper.readTree(jsonReader);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.root = jsonNode;
    }

    private String arrayIndex() {
        return Pattern.quote(this.leftBracket.toString()) + "\\s*\\d+\\s*" + Pattern.quote(this.rightBracket.toString());
    }

    private String objectComplexKey() {
        return Pattern.quote(this.leftBracket.toString()) + "\\s*\".+?\"\\s*" + Pattern.quote(this.rightBracket.toString());
    }

    private String objectKey() {
        return "[^" + Pattern.quote(this.separator.toString()) + Pattern.quote(this.leftBracket.toString()) + Pattern.quote(this.rightBracket.toString()) + "]+";
    }

    private Pattern keyPartPattern() {
        if (this.flattenMode.equals((Object)FlattenMode.MONGODB)) {
            return Pattern.compile("[^" + Pattern.quote(this.separator.toString()) + "]+");
        }
        return Pattern.compile(this.arrayIndex() + "|" + this.objectComplexKey() + "|" + this.objectKey());
    }

    public JsonUnflattener withFlattenMode(FlattenMode flattenMode) {
        this.flattenMode = (FlattenMode)((Object)Validate.notNull((Object)((Object)flattenMode)));
        return this;
    }

    public JsonUnflattener withSeparator(char separator) {
        Validate.isTrue((!Character.toString(separator).matches("[\"\\s]") ? 1 : 0) != 0, (String)"Separator contains illegal chracter(%s)", (Object[])new Object[]{Character.toString(separator)});
        Validate.isTrue((!this.leftBracket.equals(Character.valueOf(separator)) && !this.rightBracket.equals(Character.valueOf(separator)) ? 1 : 0) != 0, (String)"Separator(%s) is already used in brackets", (Object[])new Object[]{Character.toString(separator)});
        this.separator = Character.valueOf(separator);
        return this;
    }

    private String illegalBracketsRegex() {
        return "[\"\\s" + Pattern.quote(this.separator.toString()) + "]";
    }

    public JsonUnflattener withLeftAndRightBrackets(char leftBracket, char rightBracket) {
        Validate.isTrue((leftBracket != rightBracket ? 1 : 0) != 0, (String)"Both brackets cannot be the same", (Object[])new Object[0]);
        Validate.isTrue((!Character.toString(leftBracket).matches(this.illegalBracketsRegex()) ? 1 : 0) != 0, (String)"Left bracket contains illegal chracter(%s)", (Object[])new Object[]{Character.toString(leftBracket)});
        Validate.isTrue((!Character.toString(rightBracket).matches(this.illegalBracketsRegex()) ? 1 : 0) != 0, (String)"Right bracket contains illegal chracter(%s)", (Object[])new Object[]{Character.toString(rightBracket)});
        this.leftBracket = Character.valueOf(leftBracket);
        this.rightBracket = Character.valueOf(rightBracket);
        return this;
    }

    public JsonUnflattener withPrintMode(PrintMode printMode) {
        this.printMode = (PrintMode)((Object)Validate.notNull((Object)((Object)printMode)));
        return this;
    }

    public JsonUnflattener withKeyTransformer(KeyTransformer keyTrans) {
        this.keyTrans = (KeyTransformer)Validate.notNull((Object)keyTrans);
        return this;
    }

    private String writeByConfig(JsonNode jsonNode) {
        switch (this.printMode) {
            case REGULAR: {
                return jsonNode.toString();
            }
            case PRETTY: {
                return jsonNode.toPrettyString();
            }
        }
        return jsonNode.toString();
    }

    public String unflatten() {
        StringWriter sw = new StringWriter();
        if (this.root.isArray()) {
            ArrayNode unflattenedArray = this.unflattenArray((ArrayNode)this.root);
            sw.append(this.writeByConfig((JsonNode)unflattenedArray));
            return sw.toString();
        }
        if (!this.root.isObject()) {
            return this.root.toString();
        }
        ObjectNode flattened = (ObjectNode)this.root;
        ObjectNode unflattened = flattened.isEmpty() ? this.mapper.createObjectNode() : null;
        Iterator names = flattened.fieldNames();
        while (names.hasNext()) {
            String key = (String)names.next();
            ObjectNode currentVal = unflattened;
            String objKey = null;
            Integer aryIdx = null;
            Matcher matcher = this.keyPartPattern().matcher(key);
            while (matcher.find()) {
                String keyPart = matcher.group();
                if (objKey != null ^ aryIdx != null) {
                    if (this.isJsonArray(keyPart)) {
                        currentVal = this.findOrCreateJsonArray((JsonNode)currentVal, objKey, aryIdx);
                        objKey = null;
                        aryIdx = this.extractIndex(keyPart);
                    } else {
                        if (flattened.get(key).isArray()) {
                            flattened.set(key, (JsonNode)this.unflattenArray((ArrayNode)flattened.get(key)));
                        }
                        currentVal = this.findOrCreateJsonObject((JsonNode)currentVal, objKey, aryIdx);
                        objKey = this.extractKey(keyPart);
                        aryIdx = null;
                    }
                }
                if (objKey == null && aryIdx == null) {
                    if (this.isJsonArray(keyPart)) {
                        aryIdx = this.extractIndex(keyPart);
                        if (currentVal == null) {
                            currentVal = this.mapper.createArrayNode();
                        }
                    } else {
                        objKey = this.extractKey(keyPart);
                        if (currentVal == null) {
                            currentVal = this.mapper.createObjectNode();
                        }
                    }
                }
                if (unflattened != null) continue;
                unflattened = currentVal;
            }
            this.setUnflattenedValue(flattened, key, (JsonNode)currentVal, objKey, aryIdx);
        }
        sw.append(this.writeByConfig((JsonNode)unflattened));
        return sw.toString();
    }

    private ArrayNode unflattenArray(ArrayNode array) {
        ArrayNode unflattenArray = this.mapper.createArrayNode();
        for (JsonNode value : array) {
            if (value.isArray()) {
                unflattenArray.add((JsonNode)this.unflattenArray((ArrayNode)value));
                continue;
            }
            if (value.isObject()) {
                JsonNode a;
                try {
                    a = this.mapper.readTree(new JsonUnflattener(value.toString()).withSeparator(this.separator.charValue()).unflatten());
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                unflattenArray.add(a);
                continue;
            }
            unflattenArray.add(value);
        }
        return unflattenArray;
    }

    private String extractKey(String keyPart) {
        if (keyPart.matches(this.objectComplexKey())) {
            keyPart = keyPart.replaceAll("^" + Pattern.quote(this.leftBracket.toString()) + "\\s*\"", "");
            keyPart = keyPart.replaceAll("\"\\s*" + Pattern.quote(this.rightBracket.toString()) + "$", "");
        }
        return this.keyTrans != null ? this.keyTrans.transform(keyPart) : keyPart;
    }

    private Integer extractIndex(String keyPart) {
        if (this.flattenMode.equals((Object)FlattenMode.MONGODB)) {
            return Integer.valueOf(keyPart);
        }
        return Integer.valueOf(keyPart.replaceAll("[" + Pattern.quote(this.leftBracket.toString()) + Pattern.quote(this.rightBracket.toString()) + "\\s]", ""));
    }

    private boolean isJsonArray(String keyPart) {
        return keyPart.matches(this.arrayIndex()) || this.flattenMode.equals((Object)FlattenMode.MONGODB) && keyPart.matches("\\d+");
    }

    private JsonNode findOrCreateJsonArray(JsonNode currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            ObjectNode jsonObj = (ObjectNode)currentVal;
            if (jsonObj.get(objKey) == null) {
                ArrayNode ary = this.mapper.createArrayNode();
                jsonObj.set(objKey, (JsonNode)ary);
                return ary;
            }
            return jsonObj.get(objKey);
        }
        ArrayNode jsonAry = (ArrayNode)currentVal;
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx.intValue()).equals((Object)this.parseJson("null"))) {
            ArrayNode ary = this.mapper.createArrayNode();
            this.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), (JsonNode)ary);
            return ary;
        }
        return jsonAry.get(aryIdx.intValue());
    }

    private JsonNode findOrCreateJsonObject(JsonNode currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            ObjectNode jsonObj = (ObjectNode)currentVal;
            if (jsonObj.get(objKey) == null) {
                ObjectNode obj = this.mapper.createObjectNode();
                jsonObj.set(objKey, (JsonNode)obj);
                return obj;
            }
            return jsonObj.get(objKey);
        }
        ArrayNode jsonAry = (ArrayNode)currentVal;
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx.intValue()).equals((Object)this.parseJson("null"))) {
            ObjectNode obj = this.mapper.createObjectNode();
            this.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), (JsonNode)obj);
            return obj;
        }
        return jsonAry.get(aryIdx.intValue());
    }

    private void setUnflattenedValue(ObjectNode flattened, String key, JsonNode currentVal, String objKey, Integer aryIdx) {
        JsonNode val = flattened.get(key);
        if (objKey != null) {
            if (val.isArray()) {
                ArrayNode jsonArray = this.mapper.createArrayNode();
                for (JsonNode arrayVal : (ArrayNode)val) {
                    jsonArray.add(this.parseJson(this.newJsonUnflattener(arrayVal.toString()).unflatten()));
                }
                ((ObjectNode)currentVal).set(objKey, (JsonNode)jsonArray);
            } else {
                ((ObjectNode)currentVal).set(objKey, val);
            }
        } else {
            this.assureJsonArraySize((ArrayNode)currentVal, aryIdx);
            ((ArrayNode)currentVal).set(aryIdx.intValue(), val);
        }
    }

    private JsonUnflattener newJsonUnflattener(String json) {
        JsonUnflattener jf = new JsonUnflattener(json);
        if (this.flattenMode != null) {
            jf.withFlattenMode(this.flattenMode);
        }
        if (this.keyTrans != null) {
            jf.withKeyTransformer(this.keyTrans);
        }
        if (this.leftBracket != null && this.rightBracket != null) {
            jf.withLeftAndRightBrackets(this.leftBracket.charValue(), this.rightBracket.charValue());
        }
        if (this.separator != null) {
            jf.withSeparator(this.separator.charValue());
        }
        return jf;
    }

    private void assureJsonArraySize(ArrayNode jsonArray, Integer index) {
        while (index >= jsonArray.size()) {
            jsonArray.add(this.mapper.nullNode());
        }
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonUnflattener)) {
            return false;
        }
        return this.root.equals((Object)((JsonUnflattener)o).root);
    }

    public String toString() {
        return "JsonUnflattener{root=" + this.root + "}";
    }
}

