/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.Jackson3JsonArray;
import com.github.wnameless.json.base.Jackson3JsonObject;
import com.github.wnameless.json.base.JsonValueCore;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public final class Jackson3JsonValue
implements JsonValueCore<Jackson3JsonValue> {
    private final JsonNode jsonValue;

    public Jackson3JsonValue(JsonNode jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException();
        }
        this.jsonValue = jsonValue;
    }

    @Override
    public boolean isObject() {
        return this.jsonValue.isObject();
    }

    @Override
    public boolean isArray() {
        return this.jsonValue.isArray();
    }

    @Override
    public boolean isString() {
        return this.jsonValue.isString() || this.jsonValue.isBinary() || this.jsonValue.isEmbeddedValue();
    }

    @Override
    public boolean isBoolean() {
        return this.jsonValue.isBoolean();
    }

    @Override
    public boolean isNumber() {
        return this.jsonValue.isNumber();
    }

    @Override
    public boolean isNull() {
        return this.jsonValue.isNull();
    }

    @Override
    public Jackson3JsonObject asObject() {
        return new Jackson3JsonObject((ObjectNode)this.jsonValue);
    }

    @Override
    public Jackson3JsonArray asArray() {
        return new Jackson3JsonArray((ArrayNode)this.jsonValue);
    }

    @Override
    public Jackson3JsonValue asValue() {
        return this;
    }

    @Override
    public String asString() {
        if (this.jsonValue.isEmbeddedValue()) {
            return new String(Base64.getEncoder().encode(this.jsonValue.binaryValue()), StandardCharsets.UTF_8);
        }
        return this.jsonValue.asString();
    }

    @Override
    public boolean asBoolean() {
        return this.jsonValue.asBoolean();
    }

    @Override
    public int asInt() {
        return this.jsonValue.asInt();
    }

    @Override
    public long asLong() {
        return this.jsonValue.asLong();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.jsonValue.bigIntegerValue();
    }

    @Override
    public double asDouble() {
        return this.jsonValue.asDouble();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this.jsonValue.decimalValue();
    }

    public int hashCode() {
        return this.jsonValue.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Jackson3JsonValue)) return false;
        Jackson3JsonValue jv = (Jackson3JsonValue)o;
        if (!Objects.equals(this.jsonValue, jv.jsonValue)) return false;
        return true;
    }

    public String toString() {
        return this.jsonValue.toString();
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public JsonNode getSource() {
        return this.jsonValue;
    }
}

