/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.Jackson3JsonObject;
import com.github.wnameless.json.base.Jackson3JsonValue;
import com.github.wnameless.json.base.JsonArrayCore;
import com.github.wnameless.json.base.JsonSource;
import com.github.wnameless.json.base.TransformIterator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Objects;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;

public final class Jackson3JsonArray
implements JsonArrayCore<Jackson3JsonValue> {
    private final ArrayNode jsonArray;

    public Jackson3JsonArray(ArrayNode jsonArray) {
        if (jsonArray == null) {
            throw new NullPointerException();
        }
        this.jsonArray = jsonArray;
    }

    @Override
    public void add(JsonSource jsonValue) {
        this.jsonArray.add((JsonNode)jsonValue.getSource());
    }

    @Override
    public void set(int index, JsonSource jsonValue) {
        this.jsonArray.set(index, (JsonNode)jsonValue.getSource());
    }

    @Override
    public Jackson3JsonValue remove(int index) {
        return new Jackson3JsonValue(this.jsonArray.remove(index));
    }

    @Override
    public Jackson3JsonValue get(int index) {
        return new Jackson3JsonValue(this.jsonArray.get(index));
    }

    @Override
    public int size() {
        return this.jsonArray.size();
    }

    @Override
    public Iterator<Jackson3JsonValue> iterator() {
        return new TransformIterator<JsonNode, Jackson3JsonValue>(this.jsonArray.iterator(), Jackson3JsonValue::new);
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Jackson3JsonObject asObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Jackson3JsonArray asArray() {
        return this;
    }

    @Override
    public Jackson3JsonValue asValue() {
        return new Jackson3JsonValue((JsonNode)this.jsonArray);
    }

    @Override
    public Object getSource() {
        return this.jsonArray;
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public int hashCode() {
        return this.jsonArray.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Jackson3JsonArray)) return false;
        Jackson3JsonArray ja = (Jackson3JsonArray)o;
        if (!Objects.equals(this.jsonArray, ja.jsonArray)) return false;
        return true;
    }

    public String toString() {
        return this.jsonArray.toString();
    }
}

