/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.GsonJsonArray;
import com.github.wnameless.json.base.GsonJsonObject;
import com.github.wnameless.json.base.JsonValueCore;
import com.google.gson.JsonElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public final class GsonJsonValue
implements JsonValueCore<GsonJsonValue> {
    private final JsonElement jsonValue;

    public GsonJsonValue(JsonElement jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException();
        }
        this.jsonValue = jsonValue;
    }

    @Override
    public boolean isObject() {
        return this.jsonValue.isJsonObject();
    }

    @Override
    public boolean isArray() {
        return this.jsonValue.isJsonArray();
    }

    @Override
    public boolean isString() {
        return this.jsonValue.isJsonPrimitive() ? this.jsonValue.getAsJsonPrimitive().isString() : false;
    }

    @Override
    public boolean isBoolean() {
        return this.jsonValue.isJsonPrimitive() ? this.jsonValue.getAsJsonPrimitive().isBoolean() : false;
    }

    @Override
    public boolean isNumber() {
        return this.jsonValue.isJsonPrimitive() ? this.jsonValue.getAsJsonPrimitive().isNumber() : false;
    }

    @Override
    public boolean isNull() {
        return this.jsonValue.isJsonNull();
    }

    @Override
    public GsonJsonObject asObject() {
        return new GsonJsonObject(this.jsonValue.getAsJsonObject());
    }

    @Override
    public GsonJsonArray asArray() {
        return new GsonJsonArray(this.jsonValue.getAsJsonArray());
    }

    @Override
    public GsonJsonValue asValue() {
        return this;
    }

    @Override
    public int asInt() {
        return this.jsonValue.getAsInt();
    }

    @Override
    public long asLong() {
        return this.jsonValue.getAsLong();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.jsonValue.getAsBigInteger();
    }

    @Override
    public double asDouble() {
        return this.jsonValue.getAsDouble();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this.jsonValue.getAsBigDecimal();
    }

    @Override
    public String asString() {
        return this.jsonValue.getAsString();
    }

    @Override
    public boolean asBoolean() {
        return this.jsonValue.getAsBoolean();
    }

    public int hashCode() {
        return this.jsonValue.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GsonJsonValue)) return false;
        GsonJsonValue jv = (GsonJsonValue)o;
        if (!Objects.equals(this.jsonValue, jv.jsonValue)) return false;
        return true;
    }

    public String toString() {
        return this.jsonValue.toString();
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public JsonElement getSource() {
        return this.jsonValue;
    }
}

