/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.GsonJsonArray;
import com.github.wnameless.json.base.GsonJsonValue;
import com.github.wnameless.json.base.JsonObjectCore;
import com.github.wnameless.json.base.JsonSource;
import com.github.wnameless.json.base.TransformIterator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class GsonJsonObject
implements JsonObjectCore<GsonJsonValue> {
    private final JsonObject jsonObject;

    public GsonJsonObject(JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.jsonObject = jsonObject;
    }

    @Override
    public void set(String name, JsonSource jsonValue) {
        this.jsonObject.add(name, (JsonElement)jsonValue.getSource());
    }

    @Override
    public boolean remove(String name) {
        return this.jsonObject.remove(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.jsonObject.has(name);
    }

    @Override
    public GsonJsonValue get(String name) {
        JsonElement element = this.jsonObject.get(name);
        return element == null ? null : new GsonJsonValue(element);
    }

    @Override
    public int size() {
        return this.jsonObject.size();
    }

    @Override
    public Iterator<String> names() {
        return this.jsonObject.keySet().iterator();
    }

    @Override
    public Iterator<Map.Entry<String, GsonJsonValue>> iterator() {
        return new TransformIterator<Map.Entry, Map.Entry>(this.jsonObject.entrySet().iterator(), member -> new AbstractMap.SimpleImmutableEntry<String, GsonJsonValue>((String)member.getKey(), new GsonJsonValue((JsonElement)member.getValue())));
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GsonJsonObject asObject() {
        return this;
    }

    @Override
    public GsonJsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GsonJsonValue asValue() {
        return new GsonJsonValue((JsonElement)this.jsonObject);
    }

    @Override
    public Object getSource() {
        return this.jsonObject;
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GsonJsonObject)) return false;
        GsonJsonObject jo = (GsonJsonObject)o;
        if (!Objects.equals(this.jsonObject, jo.jsonObject)) return false;
        return true;
    }

    public String toString() {
        return this.jsonObject.toString();
    }
}

