/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.GsonJsonValue;
import com.github.wnameless.json.base.JacksonJsonObject;
import com.github.wnameless.json.base.JsonObjectBase;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class GsonJsonObject
implements JsonObjectBase<GsonJsonValue> {
    private final JsonObject jsonObject;

    public GsonJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public GsonJsonValue get(String name) {
        return new GsonJsonValue(this.jsonObject.get(name));
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JacksonJsonObject)) {
            return false;
        }
        return Objects.equals(this.jsonObject, ((GsonJsonObject)o).jsonObject);
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    @Override
    public Iterator<Map.Entry<String, GsonJsonValue>> iterator() {
        return new GsonJsonEntryIterator(this.jsonObject.entrySet().iterator());
    }

    private final class GsonJsonEntryIterator
    implements Iterator<Map.Entry<String, GsonJsonValue>> {
        private final Iterator<Map.Entry<String, JsonElement>> jsonElementIterator;

        private GsonJsonEntryIterator(Iterator<Map.Entry<String, JsonElement>> jsonElementIterator) {
            this.jsonElementIterator = jsonElementIterator;
        }

        @Override
        public boolean hasNext() {
            return this.jsonElementIterator.hasNext();
        }

        @Override
        public Map.Entry<String, GsonJsonValue> next() {
            Map.Entry<String, JsonElement> member = this.jsonElementIterator.next();
            return new AbstractMap.SimpleImmutableEntry<String, GsonJsonValue>(member.getKey(), new GsonJsonValue(member.getValue()));
        }
    }
}

