/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.unflattener;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JsonUnflattener {
    private static final Pattern keyPartPattern = Pattern.compile("\\[\\s*\\d+\\s*\\]|\\[\\s*\".*\"\\s*\\]|[^\\.\\[\\]]+");

    private JsonUnflattener() {
    }

    public static String unflatten(String json) {
        JsonValue root = Json.parse((String)json);
        if (root.isArray()) {
            return root.asArray().toString();
        }
        JsonObject flattened = root.asObject();
        JsonObject unflattened = flattened.names().isEmpty() ? Json.object() : null;
        for (String key : flattened.names()) {
            JsonObject currentVal = unflattened;
            String objKey = null;
            Integer aryIdx = null;
            Matcher matcher = keyPartPattern.matcher(key);
            while (matcher.find()) {
                String keyPart = matcher.group();
                if (objKey != null ^ aryIdx != null) {
                    if (JsonUnflattener.matchJsonArray(keyPart)) {
                        currentVal = JsonUnflattener.findOrCreateJsonArray((JsonValue)currentVal, objKey, aryIdx);
                        objKey = null;
                        aryIdx = JsonUnflattener.extractIndex(keyPart);
                    } else {
                        currentVal = JsonUnflattener.findOrCreateJsonObject((JsonValue)currentVal, objKey, aryIdx);
                        objKey = JsonUnflattener.extractKey(keyPart);
                        aryIdx = null;
                    }
                }
                if (objKey == null && aryIdx == null) {
                    if (JsonUnflattener.matchJsonArray(keyPart)) {
                        aryIdx = JsonUnflattener.extractIndex(keyPart);
                        if (currentVal == null) {
                            currentVal = Json.array();
                        }
                    } else {
                        objKey = keyPart.replace(".", "");
                        if (currentVal == null) {
                            currentVal = Json.object();
                        }
                    }
                }
                if (unflattened != null) continue;
                unflattened = currentVal;
            }
            JsonUnflattener.setUnflattenedValue(flattened, key, (JsonValue)currentVal, objKey, aryIdx);
        }
        return unflattened.toString();
    }

    private static String extractKey(String keyPart) {
        if (keyPart.matches("^\\[\\s*\".*$")) {
            return keyPart.replaceAll("^\\[\\s*\"", "").replaceAll("\"\\s*\\]$", "");
        }
        return keyPart;
    }

    private static Integer extractIndex(String keyPart) {
        return Integer.valueOf(keyPart.replaceAll("[\\[\\]\\s]", ""));
    }

    private static boolean matchJsonArray(String keyPart) {
        return keyPart.matches("\\[\\s*\\d+\\s*\\]");
    }

    private static JsonValue findOrCreateJsonArray(JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            if (currentVal.asObject().get(objKey) == null) {
                JsonValue ary = Json.array();
                currentVal.asObject().add(objKey, ary);
                return ary;
            }
            return currentVal.asObject().get(objKey);
        }
        if (currentVal.asArray().size() <= aryIdx || currentVal.asArray().get(aryIdx.intValue()) == null) {
            JsonValue ary = Json.array();
            JsonUnflattener.assureJsonArraySize(currentVal.asArray(), aryIdx);
            currentVal.asArray().set(aryIdx.intValue(), ary);
            return ary;
        }
        return currentVal.asArray().get(aryIdx.intValue());
    }

    private static JsonValue findOrCreateJsonObject(JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            if (currentVal.asObject().get(objKey) == null) {
                JsonObject obj = Json.object();
                currentVal.asObject().add(objKey, (JsonValue)obj);
                return obj;
            }
            return currentVal.asObject().get(objKey);
        }
        if (currentVal.asArray().size() <= aryIdx || currentVal.asArray().get(aryIdx.intValue()) == null) {
            JsonObject obj = Json.object();
            JsonUnflattener.assureJsonArraySize(currentVal.asArray(), aryIdx);
            currentVal.asArray().set(aryIdx.intValue(), (JsonValue)obj);
            return obj;
        }
        return currentVal.asArray().get(aryIdx.intValue());
    }

    private static void setUnflattenedValue(JsonObject flattened, String key, JsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            currentVal.asObject().add(objKey, flattened.get(key));
        } else if (aryIdx != null) {
            JsonUnflattener.assureJsonArraySize(currentVal.asArray(), aryIdx);
            currentVal.asArray().set(aryIdx.intValue(), flattened.get(key));
        }
    }

    private static void assureJsonArraySize(JsonArray jsonArray, Integer index) {
        while (index >= jsonArray.size()) {
            jsonArray.add(Json.NULL);
        }
    }
}

