/*
 * Decompiled with CFR 0.152.
 */
package com.shazam.android.widget.text.reflow;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.Property;
import androidx.annotation.NonNull;
import androidx.core.graphics.drawable.DrawableCompat;
import com.shazam.android.widget.text.reflow.ColorUtils;

class SwitchDrawable
extends Drawable {
    static final Property<SwitchDrawable, PointF> TOP_LEFT = new Property<SwitchDrawable, PointF>(PointF.class, "topLeft"){

        public void set(SwitchDrawable drawable, PointF topLeft) {
            drawable.setTopLeft(topLeft);
        }

        public PointF get(SwitchDrawable drawable) {
            return drawable.getTopLeft();
        }
    };
    static final Property<SwitchDrawable, Integer> WIDTH = new Property<SwitchDrawable, Integer>(Integer.class, "width"){

        public void set(SwitchDrawable drawable, Integer width) {
            drawable.setWidth(width);
        }

        public Integer get(SwitchDrawable drawable) {
            return drawable.getWidth();
        }
    };
    static final Property<SwitchDrawable, Integer> HEIGHT = new Property<SwitchDrawable, Integer>(Integer.class, "height"){

        public void set(SwitchDrawable drawable, Integer height) {
            drawable.setHeight(height);
        }

        public Integer get(SwitchDrawable drawable) {
            return drawable.getHeight();
        }
    };
    static final Property<SwitchDrawable, Integer> ALPHA = new Property<SwitchDrawable, Integer>(Integer.class, "alpha"){

        public void set(SwitchDrawable drawable, Integer alpha) {
            drawable.setAlpha(alpha);
        }

        public Integer get(SwitchDrawable drawable) {
            return DrawableCompat.getAlpha((Drawable)drawable);
        }
    };
    static final Property<SwitchDrawable, Float> PROGRESS = new Property<SwitchDrawable, Float>(Float.class, "progress"){

        public void set(SwitchDrawable drawable, Float progress) {
            drawable.setProgress(progress.floatValue());
        }

        public Float get(SwitchDrawable drawable) {
            return Float.valueOf(0.0f);
        }
    };
    private final Paint paint;
    private final float switchThreshold;
    private Bitmap currentBitmap;
    private final Bitmap endBitmap;
    private Rect currentBitmapSrcBounds;
    private final Rect endBitmapSrcBounds;
    private boolean hasSwitched = false;
    private PointF topLeft;
    private int width;
    private int height;
    private final double[] startColor;
    private final double[] endColor;
    private final double[] color = new double[3];

    SwitchDrawable(@NonNull Bitmap startBitmap, @NonNull Rect startBitmapSrcBounds, float startFontSize, @NonNull Bitmap endBitmap, @NonNull Rect endBitmapSrcBounds, float endFontSize, int startColor, int endColor) {
        this.currentBitmap = startBitmap;
        this.currentBitmapSrcBounds = startBitmapSrcBounds;
        this.endBitmap = endBitmap;
        this.endBitmapSrcBounds = endBitmapSrcBounds;
        this.startColor = ColorUtils.colorToLAB(startColor);
        this.endColor = ColorUtils.colorToLAB(endColor);
        this.switchThreshold = startFontSize / (startFontSize + endFontSize);
        this.paint = new Paint(6);
    }

    public void draw(@NonNull Canvas canvas) {
        canvas.drawBitmap(this.currentBitmap, this.currentBitmapSrcBounds, this.getBounds(), this.paint);
    }

    public int getAlpha() {
        return this.paint.getAlpha();
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public ColorFilter getColorFilter() {
        return this.paint.getColorFilter();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    void setProgress(float progress) {
        this.setColor(progress);
        if (!this.hasSwitched && progress >= this.switchThreshold) {
            this.currentBitmap = this.endBitmap;
            this.currentBitmapSrcBounds = this.endBitmapSrcBounds;
            this.hasSwitched = true;
        }
    }

    public void setColor(float progress) {
        ColorUtils.blendLab(this.startColor, this.endColor, progress, this.color);
        this.paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(ColorUtils.labToColor(this.color), PorterDuff.Mode.SRC_IN));
    }

    PointF getTopLeft() {
        return this.topLeft;
    }

    void setTopLeft(PointF topLeft) {
        this.topLeft = topLeft;
        this.updateBounds();
    }

    int getWidth() {
        return this.width;
    }

    void setWidth(int width) {
        this.width = width;
        this.updateBounds();
    }

    int getHeight() {
        return this.height;
    }

    void setHeight(int height) {
        this.height = height;
        this.updateBounds();
    }

    private void updateBounds() {
        int left = Math.round(this.topLeft.x);
        int top = Math.round(this.topLeft.y);
        this.setBounds(left, top, left + this.width, top + this.height);
    }
}

