/*
 * Decompiled with CFR 0.152.
 */
package com.shazam.android.widget.text.reflow;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.transition.PathMotion;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.shazam.android.widget.text.reflow.BoundsCalculator;
import com.shazam.android.widget.text.reflow.R;
import com.shazam.android.widget.text.reflow.Run;
import com.shazam.android.widget.text.reflow.SwitchDrawable;
import com.shazam.android.widget.text.reflow.TextColorGetter;
import com.shazam.android.widget.text.reflow.TextSizeGetter;
import java.util.ArrayList;
import java.util.List;

public final class ReflowTextAnimatorHelper {
    private static final boolean IS_LOLLIPOP_OR_ABOVE = Build.VERSION.SDK_INT >= 21;
    private static final int TRANSPARENT = 0;
    private static final int OPAQUE = 255;
    private static final int OPACITY_MID_TRANSITION = 204;
    private static final float STAGGER_DECAY = 0.8f;
    private static final char ELLIPSIS = '\u2026';
    @NonNull
    private final TextView sourceView;
    @NonNull
    private final TextView targetView;
    private final boolean showLayers;
    private final long velocity;
    private final long minDuration;
    private final long maxDuration;
    private final TextSizeGetter fontSizeGetter;
    private final TextColorGetter textColorGetter;
    private final BoundsCalculator boundsCalculator;
    private long staggerDelay;
    private long duration;
    private boolean calculateDuration;
    private final boolean freezeOnLastFrame;
    private final AnimatorSet animator = new AnimatorSet();
    private Bitmap startText;
    private Bitmap endText;

    private ReflowTextAnimatorHelper(@NonNull Builder builder) {
        this.showLayers = builder.showLayers;
        this.sourceView = builder.sourceView;
        this.targetView = builder.targetView;
        this.minDuration = builder.minDuration;
        this.maxDuration = builder.maxDuration;
        this.calculateDuration = builder.calculateDuration;
        this.staggerDelay = builder.staggerDelay;
        this.velocity = builder.velocity;
        this.freezeOnLastFrame = builder.freezeOnLastFrame;
        this.fontSizeGetter = builder.fontSizeGetter;
        this.textColorGetter = builder.textColorGetter;
        this.boundsCalculator = builder.boundsCalculator;
    }

    public Animator createAnimator() {
        this.duration = this.calculateDuration ? this.calculateDuration(this.boundsCalculator.calculate((View)this.sourceView), this.boundsCalculator.calculate((View)this.targetView)) : -1L;
        this.startText = this.createBitmap((View)this.sourceView);
        this.endText = this.createBitmap((View)this.targetView);
        this.targetView.setWillNotDraw(true);
        ((ViewGroup)this.targetView.getParent()).setClipChildren(false);
        List<Run> runs = this.getRuns();
        this.animator.playTogether(this.createRunAnimators((View)this.targetView, this.startText, this.endText, runs));
        if (!this.freezeOnLastFrame) {
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    ReflowTextAnimatorHelper.this.unfreeze();
                }
            });
        }
        return this.animator;
    }

    public void unfreeze() {
        this.targetView.setWillNotDraw(false);
        this.targetView.getOverlay().clear();
        ((ViewGroup)this.targetView.getParent()).setClipChildren(true);
        if (this.startText != null) {
            this.startText.recycle();
            this.startText = null;
        }
        if (this.endText != null) {
            this.endText.recycle();
            this.endText = null;
        }
    }

    private List<Run> getRuns() {
        int textLength = Math.max(this.sourceView.getLayout().getLineVisibleEnd(this.sourceView.getLayout().getLineCount() - 1), this.targetView.getLayout().getLineVisibleEnd(this.targetView.getLayout().getLineCount() - 1));
        int currentStartLine = 0;
        int currentStartRunLeft = 0;
        int currentStartRunTop = 0;
        int currentEndLine = 0;
        int currentEndRunLeft = 0;
        int currentEndRunTop = 0;
        ArrayList<Run> runs = new ArrayList<Run>();
        Layout startLayout = this.sourceView.getLayout();
        Layout endLayout = this.targetView.getLayout();
        int startOffsetLeft = -1;
        int endOffsetLeft = -1;
        int lastCharPosition = 0;
        for (int charPosition = 0; charPosition < textLength; ++charPosition) {
            boolean isEndVisible;
            boolean isLastChar = charPosition == textLength - 1;
            int startLine = startLayout.getLineForOffset(charPosition);
            char letter = startLayout.getText().charAt(charPosition);
            if (!isLastChar && letter == '\u2026') {
                startLayout = ReflowTextAnimatorHelper.createUnrestrictedLayout(this.sourceView);
            }
            int endLine = endLayout.getLineForOffset(charPosition);
            letter = endLayout.getText().charAt(charPosition);
            if (!isLastChar && letter == '\u2026') {
                endLayout = ReflowTextAnimatorHelper.createUnrestrictedLayout(this.targetView);
            }
            if (startLine == currentStartLine && endLine == currentEndLine && !isLastChar) continue;
            if (isLastChar) {
                ++charPosition;
            }
            currentStartLine = Math.min(currentStartLine, startLayout.getLineCount() - 1);
            currentEndLine = Math.min(currentEndLine, endLayout.getLineCount() - 1);
            int startRunBottom = startLayout.getLineBottom(currentStartLine);
            int endRunBottom = endLayout.getLineBottom(currentEndLine);
            if (currentStartLine == 0 && startOffsetLeft == -1) {
                startOffsetLeft = this.getStartOffsetLeft(startLayout, currentStartLine);
            }
            if (currentEndLine == 0 && endOffsetLeft == -1) {
                endOffsetLeft = this.getStartOffsetLeft(endLayout, currentEndLine);
            }
            Rect startBound = new Rect(currentStartRunLeft, currentStartRunTop, currentStartRunLeft + ReflowTextAnimatorHelper.getSectionWidth(startLayout, lastCharPosition, charPosition), startRunBottom);
            startBound.offset(this.sourceView.getCompoundPaddingLeft() + startOffsetLeft, this.sourceView.getCompoundPaddingTop());
            Rect endBound = new Rect(currentEndRunLeft, currentEndRunTop, currentEndRunLeft + ReflowTextAnimatorHelper.getSectionWidth(endLayout, lastCharPosition, charPosition), endRunBottom);
            endBound.offset(this.targetView.getCompoundPaddingLeft() + endOffsetLeft, this.targetView.getCompoundPaddingTop());
            boolean isStartVisible = startRunBottom <= this.sourceView.getMeasuredHeight();
            boolean bl = isEndVisible = endRunBottom <= this.targetView.getMeasuredHeight();
            if (!isStartVisible && !isEndVisible) break;
            runs.add(new Run(startBound, isStartVisible, endBound, isEndVisible));
            currentStartLine = startLine;
            currentStartRunLeft = (int)startLayout.getPrimaryHorizontal(charPosition);
            currentStartRunTop = startLayout.getLineTop(startLine);
            currentEndLine = endLine;
            currentEndRunLeft = (int)endLayout.getPrimaryHorizontal(charPosition);
            currentEndRunTop = endLayout.getLineTop(endLine);
            startOffsetLeft = 0;
            endOffsetLeft = 0;
            lastCharPosition = charPosition;
        }
        return runs;
    }

    private int getStartOffsetLeft(@NonNull Layout startLayout, int currentStartLine) {
        return (int)startLayout.getLineLeft(currentStartLine);
    }

    private static int getSectionWidth(@NonNull Layout layout, int sectionStart, int sectionEnd) {
        CharSequence text = layout.getText();
        TextPaint paint = layout.getPaint();
        return (int)Layout.getDesiredWidth((CharSequence)text, (int)sectionStart, (int)sectionEnd, (TextPaint)paint);
    }

    private static Layout createUnrestrictedLayout(@NonNull TextView view) {
        CharSequence text = view.getText();
        Layout layout = view.getLayout();
        TextPaint paint = layout.getPaint();
        if (Build.VERSION.SDK_INT >= 23) {
            return StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)layout.getPaint(), (int)layout.getWidth()).setAlignment(layout.getAlignment()).setLineSpacing(view.getLineSpacingExtra(), view.getLineSpacingMultiplier()).setIncludePad(view.getIncludeFontPadding()).setBreakStrategy(view.getBreakStrategy()).setHyphenationFrequency(view.getHyphenationFrequency()).build();
        }
        return new StaticLayout(text, paint, text.length(), layout.getAlignment(), view.getLineSpacingMultiplier(), view.getLineSpacingExtra(), view.getIncludeFontPadding());
    }

    private static void drawLayerBounds(@NonNull Canvas canvas, @NonNull Rect bounds, int sectionNumber, @NonNull Paint fillPaint, @NonNull Paint outlinePaint, @NonNull Paint textPaint) {
        Rect startRect = new Rect(bounds.left + 1, bounds.top + 1, bounds.right - 1, bounds.bottom - 1);
        canvas.drawRect(startRect, fillPaint);
        canvas.drawRect(startRect, outlinePaint);
        canvas.drawText("" + sectionNumber, (float)(bounds.left + 6), (float)(bounds.top + 21), textPaint);
    }

    @NonNull
    private List<Animator> createRunAnimators(@NonNull View view, @NonNull Bitmap startText, @NonNull Bitmap endText, @NonNull List<Run> runs) {
        int i;
        Rect sourceViewBounds = this.boundsCalculator.calculate((View)this.sourceView);
        Rect targetViewBounds = this.boundsCalculator.calculate((View)this.targetView);
        ArrayList<Animator> animators = new ArrayList<Animator>(runs.size());
        int dx = targetViewBounds.left - sourceViewBounds.left;
        int dy = targetViewBounds.top - sourceViewBounds.top;
        long startDelay = 0L;
        boolean upward = sourceViewBounds.centerY() > targetViewBounds.centerY();
        boolean first = true;
        boolean lastRightward = true;
        LinearInterpolator linearInterpolator = new LinearInterpolator();
        if (this.showLayers) {
            Paint textPaint = new Paint();
            textPaint.setTextSize(20.0f);
            textPaint.setColor(-16777216);
            Paint startPaint = new Paint();
            startPaint.setStyle(Paint.Style.STROKE);
            startPaint.setStrokeWidth(1.0f);
            startPaint.setColor(-2130771968);
            Paint endPaint = new Paint();
            endPaint.setStyle(Paint.Style.STROKE);
            endPaint.setStrokeWidth(1.0f);
            endPaint.setColor(-2130771968);
            int[] colors = this.sourceView.getResources().getIntArray(R.array.debug_colors);
            int color = 0;
            Canvas startCanvas = new Canvas(startText);
            Canvas endCanvas = new Canvas(endText);
            Paint fillPaint = new Paint();
            int section = 1;
            for (Run run : runs) {
                fillPaint.setColor(colors[color++ % colors.length]);
                fillPaint.setAlpha(128);
                ReflowTextAnimatorHelper.drawLayerBounds(startCanvas, run.getStart(), section, fillPaint, startPaint, textPaint);
                ReflowTextAnimatorHelper.drawLayerBounds(endCanvas, run.getEnd(), section, fillPaint, startPaint, textPaint);
                ++section;
            }
        }
        int n = i = upward ? 0 : runs.size() - 1;
        while (upward && i < runs.size() || !upward && i >= 0) {
            Run run = runs.get(i);
            if (run.isStartVisible() || run.isEndVisible()) {
                ObjectAnimator fade;
                boolean rightward;
                SwitchDrawable drawable = new SwitchDrawable(startText, run.getStart(), this.fontSizeGetter.get(this.sourceView), endText, run.getEnd(), this.fontSizeGetter.get(this.targetView), this.textColorGetter.get(this.sourceView), this.textColorGetter.get(this.targetView));
                drawable.setBounds(run.getStart().left, run.getStart().top, run.getStart().right, run.getStart().bottom);
                view.getOverlay().add((Drawable)drawable);
                PropertyValuesHolder topLeft = this.getPathValuesHolder(run, dy, dx);
                PropertyValuesHolder width = PropertyValuesHolder.ofInt(SwitchDrawable.WIDTH, (int[])new int[]{run.getStart().width(), run.getEnd().width()});
                PropertyValuesHolder height = PropertyValuesHolder.ofInt(SwitchDrawable.HEIGHT, (int[])new int[]{run.getStart().height(), run.getEnd().height()});
                PropertyValuesHolder progress = PropertyValuesHolder.ofFloat(SwitchDrawable.PROGRESS, (float[])new float[]{0.0f, 1.0f});
                ObjectAnimator runAnim = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)drawable), (PropertyValuesHolder[])new PropertyValuesHolder[]{topLeft, width, height, progress});
                boolean bl = rightward = run.getStart().centerX() + dx < run.getEnd().centerX();
                if (run.isStartVisible() && run.isEndVisible() && !first && rightward != lastRightward) {
                    startDelay += this.staggerDelay;
                    this.staggerDelay = (long)((float)this.staggerDelay * 0.8f);
                }
                lastRightward = rightward;
                first = false;
                runAnim.setStartDelay(startDelay);
                long animDuration = Math.max(this.minDuration, this.duration - startDelay / 2L);
                if (this.calculateDuration) {
                    runAnim.setDuration(animDuration);
                }
                animators.add((Animator)runAnim);
                if (run.isStartVisible() != run.isEndVisible()) {
                    fade = ObjectAnimator.ofInt((Object)((Object)drawable), SwitchDrawable.ALPHA, (int[])new int[]{run.isStartVisible() ? 255 : 0, run.isEndVisible() ? 255 : 0});
                    if (this.calculateDuration) {
                        fade.setDuration((this.duration + startDelay) / 2L);
                    }
                    if (!run.isStartVisible()) {
                        drawable.setAlpha(0);
                        fade.setStartDelay((this.duration + startDelay) / 2L);
                    } else {
                        fade.setStartDelay(startDelay);
                    }
                    animators.add((Animator)fade);
                } else {
                    fade = ObjectAnimator.ofInt((Object)((Object)drawable), SwitchDrawable.ALPHA, (int[])new int[]{255, 204, 255});
                    fade.setStartDelay(startDelay);
                    if (this.calculateDuration) {
                        fade.setDuration(this.duration + startDelay);
                    }
                    fade.setInterpolator((TimeInterpolator)linearInterpolator);
                    animators.add((Animator)fade);
                }
            }
            i += upward ? 1 : -1;
        }
        return animators;
    }

    private static Path getPath(float startX, float startY, float endX, float endY) {
        Path path = new Path();
        path.moveTo(startX, startY);
        path.lineTo(endX, endY);
        return path;
    }

    @TargetApi(value=21)
    private PropertyValuesHolder getPathValuesHolder(Run run, int dy, int dx) {
        PropertyValuesHolder propertyValuesHolder;
        if (IS_LOLLIPOP_OR_ABOVE) {
            PathMotion pathMotion = new PathMotion(){

                public Path getPath(float startX, float startY, float endX, float endY) {
                    return ReflowTextAnimatorHelper.getPath(startX, startY, endX, endY);
                }
            };
            propertyValuesHolder = PropertyValuesHolder.ofObject(SwitchDrawable.TOP_LEFT, null, (Path)pathMotion.getPath((float)(run.getEnd().left - dx), (float)(run.getEnd().top - dy), (float)run.getStart().left, (float)run.getStart().top));
        } else {
            PointF startPoint = new PointF((float)run.getStart().left, (float)run.getStart().top);
            PointF endPoint = new PointF((float)(run.getEnd().left - dx), (float)(run.getEnd().top - dy));
            propertyValuesHolder = PropertyValuesHolder.ofObject(SwitchDrawable.TOP_LEFT, (TypeEvaluator)new TypeEvaluator<PointF>(){
                private final PointF point = new PointF();

                public PointF evaluate(float fraction, PointF startValue, PointF endValue) {
                    float x = startValue.x + (endValue.x - startValue.x) * fraction;
                    float y = startValue.y + (endValue.y - startValue.y) * fraction;
                    this.point.set(x, y);
                    return this.point;
                }
            }, (Object[])new PointF[]{startPoint, endPoint});
        }
        return propertyValuesHolder;
    }

    private Bitmap createBitmap(@NonNull View view) {
        int width = view.getMeasuredWidth();
        int height = view.getMeasuredHeight() * (this.showLayers ? 3 : 1);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        return bitmap;
    }

    private long calculateDuration(@NonNull Rect startPosition, @NonNull Rect endPosition) {
        float distance = (float)Math.hypot(startPosition.exactCenterX() - endPosition.exactCenterX(), startPosition.exactCenterY() - endPosition.exactCenterY());
        long duration = (long)(1000.0f * (distance / (float)this.velocity));
        return Math.max(this.minDuration, Math.min(this.maxDuration, duration));
    }

    public static class Builder {
        private static final long DEFAULT_VELOCITY = 700L;
        private static final boolean DEFAULT_CALCULATE_DURATION = true;
        private static final long DEFAULT_MIN_DURATION = 200L;
        private static final long DEFAULT_MAX_DURATION = 400L;
        private static final long DEFAULT_STAGGER = 40L;
        private static final TextSizeGetter DEFAULT_FONT_SIZE_GETTER = TextView::getTextSize;
        private static final TextColorGetter DEFAULT_TEXT_COLOR_GETTER = TextView::getCurrentTextColor;
        private TextView sourceView;
        private TextView targetView;
        private boolean showLayers = false;
        private long minDuration = 200L;
        private long maxDuration = 400L;
        private long staggerDelay = 40L;
        private long velocity = 700L;
        private boolean freezeOnLastFrame = false;
        private boolean calculateDuration = true;
        private TextSizeGetter fontSizeGetter = DEFAULT_FONT_SIZE_GETTER;
        private TextColorGetter textColorGetter = DEFAULT_TEXT_COLOR_GETTER;
        private BoundsCalculator boundsCalculator = view -> {
            int[] loc = new int[2];
            view.getLocationInWindow(loc);
            return new Rect(loc[0], loc[1], loc[0] + view.getWidth(), loc[1] + view.getHeight());
        };

        public Builder(@NonNull TextView from, @NonNull TextView to) {
            this.sourceView = from;
            this.targetView = to;
            if (this.sourceView == null) {
                throw new IllegalArgumentException("Source view can't be null");
            }
            if (!ViewCompat.isLaidOut((View)this.sourceView)) {
                // empty if block
            }
            if (this.targetView == null) {
                throw new IllegalArgumentException("Target view can't be null");
            }
            if (!ViewCompat.isLaidOut((View)this.targetView)) {
                // empty if block
            }
        }

        public Builder debug(boolean showLayers) {
            this.showLayers = showLayers;
            return this;
        }

        public Builder withDuration(long minDurationMs, long maxDurationMs) {
            this.minDuration = minDurationMs;
            this.maxDuration = maxDurationMs;
            return this;
        }

        public Builder calculateDuration(boolean calculateDuration) {
            this.calculateDuration = calculateDuration;
            return this;
        }

        public Builder setBoundsCalculator(BoundsCalculator boundsCalculator) {
            this.boundsCalculator = boundsCalculator;
            return this;
        }

        public Builder withStaggerDelay(long staggerDelayMs) {
            this.staggerDelay = staggerDelayMs;
            return this;
        }

        public void setFontSizeGetter(TextSizeGetter fontSizeGetter) {
            this.fontSizeGetter = fontSizeGetter;
        }

        public Builder setTextColorGetter(TextColorGetter textColorGetter) {
            this.textColorGetter = textColorGetter;
            return this;
        }

        public Builder withVelocity(long velocity) {
            this.velocity = velocity;
            return this;
        }

        public Builder withFreezeOnLastFrame(boolean freezeOnLastFrame) {
            this.freezeOnLastFrame = freezeOnLastFrame;
            return this;
        }

        public ReflowTextAnimatorHelper build() {
            return new ReflowTextAnimatorHelper(this);
        }

        public Animator buildAnimator() {
            if (this.freezeOnLastFrame) {
                throw new IllegalStateException("Use build() to retain ability to unfreeze() the Helper.");
            }
            return this.build().createAnimator();
        }
    }
}

