/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationBehavior;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationFABBehavior;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationItem;
import com.aurelhubert.ahbottomnavigation.AHHelper;
import com.aurelhubert.ahbottomnavigation.AHTextView;
import com.aurelhubert.ahbottomnavigation.R;
import com.aurelhubert.ahbottomnavigation.notification.AHNotification;
import com.aurelhubert.ahbottomnavigation.notification.AHNotificationHelper;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class AHBottomNavigation
extends FrameLayout {
    public static final int CURRENT_ITEM_NONE = -1;
    public static final int UPDATE_ALL_NOTIFICATIONS = -1;
    private static String TAG = "AHBottomNavigation";
    private static final String EXCEPTION_INDEX_OUT_OF_BOUNDS = "The position (%d) is out of bounds of the items (%d elements)";
    private static final int MIN_ITEMS = 3;
    private static final int MAX_ITEMS = 5;
    private OnTabSelectedListener tabSelectedListener;
    private OnNavigationPositionListener navigationPositionListener;
    private Context context;
    private Resources resources;
    private ArrayList<AHBottomNavigationItem> items = new ArrayList();
    private ArrayList<View> views = new ArrayList();
    private AHBottomNavigationBehavior<AHBottomNavigation> bottomNavigationBehavior;
    private LinearLayout linearLayoutContainer;
    private View backgroundColorView;
    private Animator circleRevealAnim;
    private boolean colored = false;
    private boolean selectedBackgroundVisible = false;
    private boolean translucentNavigationEnabled;
    private List<AHNotification> notifications = AHNotification.generateEmptyList(5);
    private Boolean[] itemsEnabledStates = new Boolean[]{true, true, true, true, true};
    private boolean isBehaviorTranslationSet = false;
    private int currentItem = 0;
    private int currentColor = 0;
    private boolean behaviorTranslationEnabled = true;
    private boolean needHideBottomNavigation = false;
    private boolean hideBottomNavigationWithAnimation = false;
    private boolean soundEffectsEnabled = true;
    private ArrayList<Typeface> titleTypeface = new ArrayList();
    private int defaultBackgroundColor = -1;
    private int defaultBackgroundResource = 0;
    private ArrayList<Integer> iconActiveColor = new ArrayList(5);
    private ArrayList<Integer> iconInactiveColor = new ArrayList(5);
    private ArrayList<Integer> titleActiveColor = new ArrayList(5);
    private ArrayList<Integer> titleInactiveColor = new ArrayList(5);
    private ArrayList<Integer> iconDisableColor = new ArrayList(5);
    private ArrayList<Integer> titleDisableColor = new ArrayList(5);
    private ArrayList<Integer> coloredTitleColorActive = new ArrayList(5);
    private ArrayList<Integer> coloredTitleColorInactive = new ArrayList(5);
    private ArrayList<Float> titleActiveTextSize = new ArrayList(5);
    private ArrayList<Float> titleInactiveTextSize = new ArrayList(5);
    private int bottomNavigationHeight;
    private int navigationBarHeight = 0;
    private float selectedItemWidth;
    private float notSelectedItemWidth;
    private boolean forceTint = false;
    private boolean preferLargeIcons = false;
    private TitleState titleState = TitleState.SHOW_WHEN_ACTIVE;
    @ColorInt
    private int notificationTextColor;
    @ColorInt
    private int notificationBackgroundColor;
    private Drawable notificationBackgroundDrawable;
    private Typeface notificationTypeface;
    private int notificationActiveMarginLeft;
    private int notificationInactiveMarginLeft;
    private int notificationActiveMarginTop;
    private int notificationInactiveMarginTop;
    private long notificationAnimationDuration;
    private int defaultNotificationElevation;

    public AHBottomNavigation(Context context) {
        super(context);
        this.init(context, null);
    }

    public AHBottomNavigation(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AHBottomNavigation(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public void setSoundEffectsEnabled(boolean soundEffectsEnabled) {
        super.setSoundEffectsEnabled(soundEffectsEnabled);
        this.soundEffectsEnabled = soundEffectsEnabled;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.createItems();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.isBehaviorTranslationSet) {
            this.setBehaviorTranslationEnabled(this.behaviorTranslationEnabled);
            this.isBehaviorTranslationSet = true;
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putInt("current_item", this.currentItem);
        bundle.putParcelableArrayList("notifications", new ArrayList<AHNotification>(this.notifications));
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.currentItem = bundle.getInt("current_item");
            this.notifications = bundle.getParcelableArrayList("notifications");
            state = bundle.getParcelable("superState");
        }
        super.onRestoreInstanceState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        this.resources = this.context.getResources();
        this.defaultNotificationElevation = this.resources.getDimensionPixelSize(R.dimen.bottom_navigation_notification_elevation);
        AHHelper.fill(this.iconActiveColor, 5, null);
        AHHelper.fill(this.iconInactiveColor, 5, null);
        AHHelper.fill(this.iconDisableColor, 5, null);
        AHHelper.fill(this.titleActiveColor, 5, null);
        AHHelper.fill(this.titleInactiveColor, 5, null);
        AHHelper.fill(this.titleDisableColor, 5, null);
        AHHelper.fill(this.titleTypeface, 5, null);
        AHHelper.fill(this.titleActiveTextSize, 5, null);
        AHHelper.fill(this.titleInactiveTextSize, 5, null);
        AHHelper.fill(this.coloredTitleColorActive, 5, ContextCompat.getColor((Context)context, (int)R.color.colorBottomNavigationActiveColored));
        AHHelper.fill(this.coloredTitleColorInactive, 5, ContextCompat.getColor((Context)context, (int)R.color.colorBottomNavigationInactiveColored));
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AHBottomNavigationBehavior_Params, 0, 0);
            try {
                this.selectedBackgroundVisible = ta.getBoolean(R.styleable.AHBottomNavigationBehavior_Params_selectedBackgroundVisible, false);
                this.translucentNavigationEnabled = ta.getBoolean(R.styleable.AHBottomNavigationBehavior_Params_translucentNavigationEnabled, false);
                AHHelper.map(this.titleActiveColor, ignored -> ta.getColor(R.styleable.AHBottomNavigationBehavior_Params_accentColor, ContextCompat.getColor((Context)context, (int)R.color.colorBottomNavigationAccent)));
                AHHelper.map(this.titleInactiveColor, ignored -> ta.getColor(R.styleable.AHBottomNavigationBehavior_Params_inactiveColor, ContextCompat.getColor((Context)context, (int)R.color.colorBottomNavigationInactive)));
                AHHelper.map(this.iconDisableColor, ignored -> ta.getColor(R.styleable.AHBottomNavigationBehavior_Params_disableColor, ContextCompat.getColor((Context)context, (int)R.color.colorBottomNavigationDisable)));
                AHHelper.map(this.coloredTitleColorActive, ignored -> ta.getColor(R.styleable.AHBottomNavigationBehavior_Params_coloredActive, ContextCompat.getColor((Context)context, (int)R.color.colorBottomNavigationActiveColored)));
                AHHelper.map(this.coloredTitleColorInactive, ignored -> ta.getColor(R.styleable.AHBottomNavigationBehavior_Params_coloredInactive, ContextCompat.getColor((Context)context, (int)R.color.colorBottomNavigationInactiveColored)));
                this.colored = ta.getBoolean(R.styleable.AHBottomNavigationBehavior_Params_colored, false);
            }
            finally {
                ta.recycle();
            }
        }
        this.notificationTextColor = ContextCompat.getColor((Context)context, (int)17170443);
        this.bottomNavigationHeight = (int)this.resources.getDimension(R.dimen.bottom_navigation_height);
        this.notificationActiveMarginLeft = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_left_active);
        this.notificationInactiveMarginLeft = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_left);
        this.notificationActiveMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_top_active);
        this.notificationInactiveMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_notification_margin_top);
        this.notificationAnimationDuration = 150L;
        ViewCompat.setElevation((View)this, (float)this.resources.getDimension(R.dimen.bottom_navigation_elevation));
        this.setClipToPadding(false);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, this.bottomNavigationHeight);
        this.setLayoutParams(params);
    }

    protected void createItems() {
        if (this.items.size() < 3) {
            Log.w((String)TAG, (String)"The items list should have at least 3 items");
        } else if (this.items.size() > 5) {
            Log.w((String)TAG, (String)"The items list should not have more than 5 items");
        }
        int layoutHeight = (int)this.resources.getDimension(R.dimen.bottom_navigation_height);
        this.removeAllViews();
        this.views.clear();
        this.backgroundColorView = new View(this.context);
        if (Build.VERSION.SDK_INT >= 21) {
            FrameLayout.LayoutParams backgroundLayoutParams = new FrameLayout.LayoutParams(-1, this.calculateHeight(layoutHeight));
            this.addView(this.backgroundColorView, (ViewGroup.LayoutParams)backgroundLayoutParams);
            this.bottomNavigationHeight = layoutHeight;
        }
        this.linearLayoutContainer = new LinearLayout(this.context);
        this.linearLayoutContainer.setOrientation(0);
        this.linearLayoutContainer.setGravity(17);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, layoutHeight);
        this.addView((View)this.linearLayoutContainer, (ViewGroup.LayoutParams)layoutParams);
        if (this.isClassic()) {
            this.createClassicItems(this.linearLayoutContainer);
        } else {
            this.createSmallItems(this.linearLayoutContainer);
        }
        this.post(() -> ((AHBottomNavigation)this).requestLayout());
    }

    private boolean isClassic() {
        if (this.preferLargeIcons && this.items.size() == 3) {
            return true;
        }
        return this.titleState != TitleState.ALWAYS_HIDE && this.titleState != TitleState.SHOW_WHEN_ACTIVE_FORCE && (this.items.size() == 3 || this.titleState == TitleState.ALWAYS_SHOW);
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=21)
    private int calculateHeight(int layoutHeight) {
        if (!this.translucentNavigationEnabled) {
            return layoutHeight;
        }
        int resourceId = this.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            this.navigationBarHeight = this.resources.getDimensionPixelSize(resourceId);
        }
        int[] attrs = new int[]{0x10100DD, 16843760};
        TypedArray typedValue = this.getContext().getTheme().obtainStyledAttributes(attrs);
        boolean translucentNavigation = typedValue.getBoolean(1, true);
        if (this.hasImmersive() && translucentNavigation) {
            layoutHeight += this.navigationBarHeight;
        }
        typedValue.recycle();
        return layoutHeight;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=21)
    public boolean hasImmersive() {
        Display d = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics realDisplayMetrics = new DisplayMetrics();
        d.getRealMetrics(realDisplayMetrics);
        int realHeight = realDisplayMetrics.heightPixels;
        int realWidth = realDisplayMetrics.widthPixels;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        d.getMetrics(displayMetrics);
        int displayHeight = displayMetrics.heightPixels;
        int displayWidth = displayMetrics.widthPixels;
        return realWidth > displayWidth || realHeight > displayHeight;
    }

    private void createClassicItems(LinearLayout linearLayout) {
        int layoutWidth;
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        float height = this.resources.getDimension(R.dimen.bottom_navigation_height);
        float minWidth = this.resources.getDimension(R.dimen.bottom_navigation_min_width);
        float maxWidth = this.resources.getDimension(R.dimen.bottom_navigation_max_width);
        if (this.titleState == TitleState.ALWAYS_SHOW && this.items.size() > 3) {
            minWidth = this.resources.getDimension(R.dimen.bottom_navigation_small_inactive_min_width);
            maxWidth = this.resources.getDimension(R.dimen.bottom_navigation_small_inactive_max_width);
        }
        if ((layoutWidth = this.getWidth()) == 0 || this.items.size() == 0) {
            return;
        }
        float itemWidth = layoutWidth / this.items.size();
        if (itemWidth < minWidth) {
            itemWidth = minWidth;
        } else if (itemWidth > maxWidth) {
            itemWidth = maxWidth;
        }
        int activePaddingTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_margin_top_active);
        for (int i = 0; i < this.items.size(); ++i) {
            boolean current = this.currentItem == i;
            int itemIndex = i;
            AHBottomNavigationItem item = this.items.get(itemIndex);
            View view = inflater.inflate(R.layout.bottom_navigation_item, (ViewGroup)this, false);
            FrameLayout container = (FrameLayout)view.findViewById(R.id.bottom_navigation_container);
            ImageView icon = (ImageView)view.findViewById(R.id.bottom_navigation_item_icon);
            AHTextView title = (AHTextView)view.findViewById(R.id.bottom_navigation_item_title);
            AHTextView notification = (AHTextView)view.findViewById(R.id.bottom_navigation_notification);
            icon.setImageDrawable(item.getDrawable(this.context));
            if (this.titleState == TitleState.ALWAYS_HIDE) {
                title.setVisibility(8);
                ((FrameLayout.LayoutParams)icon.getLayoutParams()).gravity = 17;
                int iconHeight = this.resources.getDimensionPixelSize(R.dimen.bottom_navigation_icon);
                ((ViewGroup.MarginLayoutParams)notification.getLayoutParams()).topMargin = (this.bottomNavigationHeight - iconHeight) / 2 - this.dpToPx(4);
            } else {
                title.setText(item.getTitle(this.context));
            }
            title.setTypeface(this.titleTypeface.get(i));
            if (this.titleState == TitleState.ALWAYS_SHOW && this.items.size() > 3) {
                container.setPadding(0, container.getPaddingTop(), 0, container.getPaddingBottom());
            }
            if (current) {
                if (this.selectedBackgroundVisible) {
                    view.setSelected(true);
                }
                icon.setSelected(true);
                if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)icon.getLayoutParams();
                    p.setMargins(p.leftMargin, activePaddingTop, p.rightMargin, p.bottomMargin);
                    ViewGroup.MarginLayoutParams paramsNotification = (ViewGroup.MarginLayoutParams)notification.getLayoutParams();
                    paramsNotification.setMargins(this.notificationActiveMarginLeft, paramsNotification.topMargin, paramsNotification.rightMargin, paramsNotification.bottomMargin);
                    view.requestLayout();
                }
            } else {
                icon.setSelected(false);
                ViewGroup.MarginLayoutParams paramsNotification = (ViewGroup.MarginLayoutParams)notification.getLayoutParams();
                paramsNotification.setMargins(this.notificationInactiveMarginLeft, paramsNotification.topMargin, paramsNotification.rightMargin, paramsNotification.bottomMargin);
            }
            if (this.colored) {
                if (current) {
                    this.setBackgroundColor(item.getColor(this.context));
                    this.currentColor = item.getColor(this.context);
                }
            } else if (this.defaultBackgroundResource != 0) {
                this.setBackgroundResource(this.defaultBackgroundResource);
            } else {
                this.setBackgroundColor(this.defaultBackgroundColor);
            }
            title.setTextSize(0, current ? this.getActiveTextSize(i) : this.getInactiveTextSize(i));
            if (this.itemsEnabledStates[i].booleanValue()) {
                view.setOnClickListener(v -> this.updateItems(itemIndex, true));
                icon.setImageDrawable(AHHelper.getTintDrawable(this.items.get(i).getDrawable(this.context), current ? this.iconActiveColor.get(i) : this.iconInactiveColor.get(i), this.forceTint));
                title.setTextColor(current ? this.titleActiveColor.get(i) : this.titleInactiveColor.get(i));
                view.setSoundEffectsEnabled(this.soundEffectsEnabled);
            } else {
                icon.setImageDrawable(AHHelper.getTintDrawable(this.items.get(i).getDrawable(this.context), this.iconDisableColor.get(i), this.forceTint));
                title.setTextColor(this.titleDisableColor.get(i));
            }
            if (item.getTag() != null) {
                view.setTag((Object)item.getTag());
            }
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams((int)itemWidth, (int)height);
            linearLayout.addView(view, (ViewGroup.LayoutParams)params);
            this.views.add(view);
            this.setTabAccessibilityLabel(itemIndex, this.currentItem);
        }
        this.updateNotifications(true, -1);
    }

    private float getInactiveTextSize(int index) {
        if (this.titleInactiveTextSize.get(index) != null) {
            return this.titleInactiveTextSize.get(index).floatValue();
        }
        if (this.titleState == TitleState.ALWAYS_SHOW && this.items.size() > 3) {
            return this.resources.getDimension(R.dimen.bottom_navigation_text_size_forced_inactive);
        }
        return this.resources.getDimension(R.dimen.bottom_navigation_text_size_inactive);
    }

    private float getActiveTextSize(int index) {
        if (this.titleActiveTextSize.get(index) != null) {
            return this.titleActiveTextSize.get(index).floatValue();
        }
        if (this.titleState == TitleState.ALWAYS_SHOW && this.items.size() > 3) {
            return this.resources.getDimension(R.dimen.bottom_navigation_text_size_forced_active);
        }
        return this.resources.getDimension(R.dimen.bottom_navigation_text_size_active);
    }

    private void createSmallItems(LinearLayout linearLayout) {
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        float height = this.resources.getDimension(R.dimen.bottom_navigation_height);
        float minWidth = this.resources.getDimension(R.dimen.bottom_navigation_small_inactive_min_width);
        float maxWidth = this.resources.getDimension(R.dimen.bottom_navigation_small_inactive_max_width);
        int layoutWidth = this.getWidth();
        if (layoutWidth == 0 || this.items.size() == 0) {
            return;
        }
        float itemWidth = layoutWidth / this.items.size();
        if (itemWidth < minWidth) {
            itemWidth = minWidth;
        } else if (itemWidth > maxWidth) {
            itemWidth = maxWidth;
        }
        int activeMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_small_margin_top_active);
        float difference = this.resources.getDimension(R.dimen.bottom_navigation_small_selected_width_difference);
        this.selectedItemWidth = itemWidth + (float)this.items.size() * difference;
        this.notSelectedItemWidth = itemWidth -= difference;
        for (int i = 0; i < this.items.size(); ++i) {
            int width;
            float activeTextSize;
            int itemIndex = i;
            boolean current = this.currentItem == i;
            AHBottomNavigationItem item = this.items.get(itemIndex);
            View view = inflater.inflate(R.layout.bottom_navigation_small_item, (ViewGroup)this, false);
            ImageView icon = (ImageView)view.findViewById(R.id.bottom_navigation_small_item_icon);
            AHTextView title = (AHTextView)view.findViewById(R.id.bottom_navigation_small_item_title);
            AHTextView notification = (AHTextView)view.findViewById(R.id.bottom_navigation_notification);
            icon.setImageDrawable(item.getDrawable(this.context));
            if (this.titleState != TitleState.ALWAYS_HIDE) {
                title.setText(item.getTitle(this.context));
            }
            if ((activeTextSize = this.getActiveTextSize(i)) != 0.0f) {
                title.setTextSize(0, activeTextSize);
            }
            title.setTypeface(this.titleTypeface.get(i));
            if (current) {
                if (this.selectedBackgroundVisible) {
                    view.setSelected(true);
                }
                icon.setSelected(true);
                if (this.titleState != TitleState.ALWAYS_HIDE && view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)icon.getLayoutParams();
                    p.setMargins(p.leftMargin, activeMarginTop, p.rightMargin, p.bottomMargin);
                    ViewGroup.MarginLayoutParams paramsNotification = (ViewGroup.MarginLayoutParams)notification.getLayoutParams();
                    paramsNotification.setMargins(this.notificationActiveMarginLeft, this.notificationActiveMarginTop, paramsNotification.rightMargin, paramsNotification.bottomMargin);
                    view.requestLayout();
                }
            } else {
                icon.setSelected(false);
                ViewGroup.MarginLayoutParams paramsNotification = (ViewGroup.MarginLayoutParams)notification.getLayoutParams();
                paramsNotification.setMargins(this.notificationInactiveMarginLeft, this.notificationInactiveMarginTop, paramsNotification.rightMargin, paramsNotification.bottomMargin);
            }
            if (this.colored) {
                if (i == this.currentItem) {
                    this.setBackgroundColor(item.getColor(this.context));
                    this.currentColor = item.getColor(this.context);
                }
            } else if (this.defaultBackgroundResource != 0) {
                this.setBackgroundResource(this.defaultBackgroundResource);
            } else {
                this.setBackgroundColor(this.defaultBackgroundColor);
            }
            if (this.itemsEnabledStates[i].booleanValue()) {
                icon.setImageDrawable(AHHelper.getTintDrawable(this.items.get(i).getDrawable(this.context), this.currentItem == i ? this.iconActiveColor.get(i) : this.iconInactiveColor.get(i), this.forceTint));
                title.setTextColor(this.currentItem == i ? this.titleActiveColor.get(i) : this.titleInactiveColor.get(i));
                title.setAlpha(this.currentItem == i ? 1.0f : 0.0f);
                view.setOnClickListener(v -> this.updateSmallItems(itemIndex, true));
                view.setSoundEffectsEnabled(this.soundEffectsEnabled);
            } else {
                icon.setImageDrawable(AHHelper.getTintDrawable(this.items.get(i).getDrawable(this.context), this.iconDisableColor.get(i), this.forceTint));
                title.setTextColor(this.titleDisableColor.get(i));
                title.setAlpha(0.0f);
            }
            int n = width = i == this.currentItem ? (int)this.selectedItemWidth : (int)itemWidth;
            if (this.titleState == TitleState.ALWAYS_HIDE) {
                width = (int)((double)itemWidth * 1.16);
            }
            if (item.getTag() != null) {
                view.setTag((Object)item.getTag());
            }
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(width, (int)height);
            linearLayout.addView(view, (ViewGroup.LayoutParams)params);
            this.views.add(view);
            this.setTabAccessibilityLabel(itemIndex, this.currentItem);
        }
        this.updateNotifications(true, -1);
    }

    private void setTabAccessibilityLabel(int itemIndex, int currentItem) {
        String contentDescription;
        AHBottomNavigationItem item = this.items.get(itemIndex);
        String string = contentDescription = currentItem == itemIndex ? "selected, " : "";
        if (item.getTitle(this.context) != null) {
            contentDescription = contentDescription + item.getTitle(this.context) + ", ";
        }
        if (AHHelper.isInteger(this.notifications.get(itemIndex).getReadableText())) {
            int num = Integer.parseInt(this.notifications.get(itemIndex).getReadableText());
            contentDescription = contentDescription + num + " new item" + (num == 1 ? "" : "s") + ", ";
        }
        contentDescription = contentDescription + "tab, " + (itemIndex + 1) + " out of " + this.getItemsCount();
        this.views.get(itemIndex).setContentDescription((CharSequence)contentDescription);
    }

    private void updateItems(final int itemIndex, boolean useCallback) {
        boolean selectionAllowed;
        for (int i = 0; i < this.views.size(); ++i) {
            this.setTabAccessibilityLabel(i, itemIndex);
        }
        if (this.currentItem == itemIndex) {
            if (this.tabSelectedListener != null && useCallback) {
                this.tabSelectedListener.onTabSelected(itemIndex, true);
            }
            return;
        }
        if (this.tabSelectedListener != null && useCallback && !(selectionAllowed = this.tabSelectedListener.onTabSelected(itemIndex, false))) {
            return;
        }
        int activeMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_margin_top_active);
        int inactiveMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_margin_top_inactive);
        for (int i = 0; i < this.views.size(); ++i) {
            AHTextView notification;
            ImageView icon;
            AHTextView title;
            View view = this.views.get(i);
            if (this.selectedBackgroundVisible) {
                view.setSelected(i == itemIndex);
            }
            if (i == itemIndex) {
                title = (AHTextView)view.findViewById(R.id.bottom_navigation_item_title);
                icon = (ImageView)view.findViewById(R.id.bottom_navigation_item_icon);
                notification = (AHTextView)view.findViewById(R.id.bottom_navigation_notification);
                icon.setSelected(true);
                AHHelper.updateTopMargin((View)icon, inactiveMarginTop, activeMarginTop);
                AHHelper.updateLeftMargin((View)notification, this.notificationInactiveMarginLeft, this.notificationActiveMarginLeft);
                AHHelper.updateTextColor(title, this.titleInactiveColor.get(i), this.titleActiveColor.get(i));
                AHHelper.updateTextSize((TextView)title, this.getInactiveTextSize(i), this.getActiveTextSize(i));
                AHHelper.updateDrawableColor(this.items.get(itemIndex).getDrawable(this.context), icon, this.iconInactiveColor.get(i), this.iconActiveColor.get(i), this.forceTint);
                if (Build.VERSION.SDK_INT >= 21 && this.colored) {
                    int finalRadius = Math.max(this.getWidth(), this.getHeight());
                    int cx = (int)view.getX() + view.getWidth() / 2;
                    int cy = view.getHeight() / 2;
                    if (this.circleRevealAnim != null && this.circleRevealAnim.isRunning()) {
                        this.circleRevealAnim.cancel();
                        this.setBackgroundColor(this.items.get(itemIndex).getColor(this.context));
                        this.backgroundColorView.setBackgroundColor(0);
                    }
                    this.circleRevealAnim = ViewAnimationUtils.createCircularReveal((View)this.backgroundColorView, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
                    this.circleRevealAnim.setStartDelay(5L);
                    this.circleRevealAnim.addListener(new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            AHBottomNavigation.this.backgroundColorView.setBackgroundColor(((AHBottomNavigationItem)AHBottomNavigation.this.items.get(itemIndex)).getColor(AHBottomNavigation.this.context));
                        }

                        public void onAnimationEnd(Animator animation) {
                            AHBottomNavigation.this.setBackgroundColor(((AHBottomNavigationItem)AHBottomNavigation.this.items.get(itemIndex)).getColor(AHBottomNavigation.this.context));
                            AHBottomNavigation.this.backgroundColorView.setBackgroundColor(0);
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    this.circleRevealAnim.start();
                    continue;
                }
                if (this.colored) {
                    AHHelper.updateViewBackgroundColor((View)this, this.currentColor, this.items.get(itemIndex).getColor(this.context));
                    continue;
                }
                if (this.defaultBackgroundResource != 0) {
                    this.setBackgroundResource(this.defaultBackgroundResource);
                } else {
                    this.setBackgroundColor(this.defaultBackgroundColor);
                }
                this.backgroundColorView.setBackgroundColor(0);
                continue;
            }
            if (i != this.currentItem) continue;
            title = (AHTextView)view.findViewById(R.id.bottom_navigation_item_title);
            icon = (ImageView)view.findViewById(R.id.bottom_navigation_item_icon);
            notification = (AHTextView)view.findViewById(R.id.bottom_navigation_notification);
            icon.setSelected(false);
            AHHelper.updateTopMargin((View)icon, activeMarginTop, inactiveMarginTop);
            AHHelper.updateLeftMargin((View)notification, this.notificationActiveMarginLeft, this.notificationInactiveMarginLeft);
            AHHelper.updateTextColor(title, this.titleActiveColor.get(i), this.titleInactiveColor.get(i));
            AHHelper.updateTextSize((TextView)title, this.getActiveTextSize(i), this.getInactiveTextSize(i));
            AHHelper.updateDrawableColor(this.items.get(this.currentItem).getDrawable(this.context), icon, this.iconActiveColor.get(i), this.iconInactiveColor.get(i), this.forceTint);
        }
        this.currentItem = itemIndex;
        if (this.currentItem > 0 && this.currentItem < this.items.size()) {
            this.currentColor = this.items.get(this.currentItem).getColor(this.context);
        } else if (this.currentItem == -1) {
            if (this.defaultBackgroundResource != 0) {
                this.setBackgroundResource(this.defaultBackgroundResource);
            } else {
                this.setBackgroundColor(this.defaultBackgroundColor);
            }
            this.backgroundColorView.setBackgroundColor(0);
        }
    }

    private void updateSmallItems(final int itemIndex, boolean useCallback) {
        boolean selectionAllowed;
        if (this.currentItem == itemIndex) {
            if (this.tabSelectedListener != null && useCallback) {
                this.tabSelectedListener.onTabSelected(itemIndex, true);
            }
            return;
        }
        if (this.tabSelectedListener != null && useCallback && !(selectionAllowed = this.tabSelectedListener.onTabSelected(itemIndex, false))) {
            return;
        }
        int activeMarginTop = (int)this.resources.getDimension(R.dimen.bottom_navigation_small_margin_top_active);
        int inactiveMargin = (int)this.resources.getDimension(R.dimen.bottom_navigation_small_margin_top);
        for (int i = 0; i < this.views.size(); ++i) {
            AHTextView notification;
            ImageView icon;
            AHTextView title;
            FrameLayout container;
            View view = this.views.get(i);
            if (this.selectedBackgroundVisible) {
                view.setSelected(i == itemIndex);
            }
            if (i == itemIndex) {
                container = (FrameLayout)view.findViewById(R.id.bottom_navigation_small_container);
                title = (AHTextView)view.findViewById(R.id.bottom_navigation_small_item_title);
                icon = (ImageView)view.findViewById(R.id.bottom_navigation_small_item_icon);
                notification = (AHTextView)view.findViewById(R.id.bottom_navigation_notification);
                icon.setSelected(true);
                if (this.titleState != TitleState.ALWAYS_HIDE) {
                    AHHelper.updateTopMargin((View)icon, inactiveMargin, activeMarginTop);
                    AHHelper.updateLeftMargin((View)notification, this.notificationInactiveMarginLeft, this.notificationActiveMarginLeft);
                    AHHelper.updateTopMargin((View)notification, this.notificationInactiveMarginTop, this.notificationActiveMarginTop);
                    AHHelper.updateTextColor(title, this.iconInactiveColor.get(i), this.iconActiveColor.get(i));
                    AHHelper.updateWidth((View)container, this.notSelectedItemWidth, this.selectedItemWidth);
                }
                AHHelper.updateAlpha((View)title, 0.0f, 1.0f);
                AHHelper.updateDrawableColor(this.items.get(itemIndex).getDrawable(this.context), icon, this.iconInactiveColor.get(i), this.iconActiveColor.get(i), this.forceTint);
                if (Build.VERSION.SDK_INT >= 21 && this.colored) {
                    int finalRadius = Math.max(this.getWidth(), this.getHeight());
                    int cx = (int)this.views.get(itemIndex).getX() + this.views.get(itemIndex).getWidth() / 2;
                    int cy = this.views.get(itemIndex).getHeight() / 2;
                    if (this.circleRevealAnim != null && this.circleRevealAnim.isRunning()) {
                        this.circleRevealAnim.cancel();
                        this.setBackgroundColor(this.items.get(itemIndex).getColor(this.context));
                        this.backgroundColorView.setBackgroundColor(0);
                    }
                    this.circleRevealAnim = ViewAnimationUtils.createCircularReveal((View)this.backgroundColorView, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
                    this.circleRevealAnim.setStartDelay(5L);
                    this.circleRevealAnim.addListener(new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                            AHBottomNavigation.this.backgroundColorView.setBackgroundColor(((AHBottomNavigationItem)AHBottomNavigation.this.items.get(itemIndex)).getColor(AHBottomNavigation.this.context));
                        }

                        public void onAnimationEnd(Animator animation) {
                            AHBottomNavigation.this.setBackgroundColor(((AHBottomNavigationItem)AHBottomNavigation.this.items.get(itemIndex)).getColor(AHBottomNavigation.this.context));
                            AHBottomNavigation.this.backgroundColorView.setBackgroundColor(0);
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    this.circleRevealAnim.start();
                    continue;
                }
                if (this.colored) {
                    AHHelper.updateViewBackgroundColor((View)this, this.currentColor, this.items.get(itemIndex).getColor(this.context));
                    continue;
                }
                if (this.defaultBackgroundResource != 0) {
                    this.setBackgroundResource(this.defaultBackgroundResource);
                } else {
                    this.setBackgroundColor(this.defaultBackgroundColor);
                }
                this.backgroundColorView.setBackgroundColor(0);
                continue;
            }
            if (i != this.currentItem) continue;
            container = view.findViewById(R.id.bottom_navigation_small_container);
            title = (AHTextView)view.findViewById(R.id.bottom_navigation_small_item_title);
            icon = (ImageView)view.findViewById(R.id.bottom_navigation_small_item_icon);
            notification = (AHTextView)view.findViewById(R.id.bottom_navigation_notification);
            icon.setSelected(false);
            if (this.titleState != TitleState.ALWAYS_HIDE) {
                AHHelper.updateTopMargin((View)icon, activeMarginTop, inactiveMargin);
                AHHelper.updateLeftMargin((View)notification, this.notificationActiveMarginLeft, this.notificationInactiveMarginLeft);
                AHHelper.updateTopMargin((View)notification, this.notificationActiveMarginTop, this.notificationInactiveMarginTop);
                AHHelper.updateTextColor(title, this.iconActiveColor.get(i), this.iconInactiveColor.get(i));
                AHHelper.updateWidth((View)container, this.selectedItemWidth, this.notSelectedItemWidth);
            }
            AHHelper.updateAlpha((View)title, 1.0f, 0.0f);
            AHHelper.updateDrawableColor(this.items.get(this.currentItem).getDrawable(this.context), icon, this.iconActiveColor.get(i), this.iconInactiveColor.get(i), this.forceTint);
        }
        this.currentItem = itemIndex;
        if (this.currentItem > 0 && this.currentItem < this.items.size()) {
            this.currentColor = this.items.get(this.currentItem).getColor(this.context);
        } else if (this.currentItem == -1) {
            if (this.defaultBackgroundResource != 0) {
                this.setBackgroundResource(this.defaultBackgroundResource);
            } else {
                this.setBackgroundColor(this.defaultBackgroundColor);
            }
            this.backgroundColorView.setBackgroundColor(0);
        }
    }

    private void updateNotifications(boolean updateStyle, int itemPosition) {
        for (int i = 0; i < this.views.size() && i < this.notifications.size(); ++i) {
            if (itemPosition != -1 && itemPosition != i) continue;
            AHNotification notificationItem = this.notifications.get(i);
            int currentTextColor = AHNotificationHelper.getTextColor(notificationItem, this.notificationTextColor);
            int currentBackgroundColor = AHNotificationHelper.getBackgroundColor(notificationItem, this.notificationBackgroundColor);
            AHTextView notification = (AHTextView)this.views.get(i).findViewById(R.id.bottom_navigation_notification);
            if (updateStyle) {
                if (Build.VERSION.SDK_INT >= 21) {
                    notification.setElevation(notificationItem.isDot() ? 0.0f : (float)this.defaultNotificationElevation);
                }
                notification.setTextColor(currentTextColor);
                if (this.notificationTypeface != null) {
                    notification.setTypeface(this.notificationTypeface);
                } else {
                    notification.setTypeface(null, 1);
                }
                if (this.notificationBackgroundDrawable != null) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        Drawable drawable2 = this.notificationBackgroundDrawable.getConstantState().newDrawable();
                        notification.setBackground(drawable2);
                    } else {
                        notification.setBackgroundDrawable(this.notificationBackgroundDrawable);
                    }
                } else if (currentBackgroundColor != 0) {
                    Drawable defaultDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.notification_background);
                    if (Build.VERSION.SDK_INT >= 16) {
                        notification.setBackground(AHHelper.getTintDrawable(defaultDrawable, currentBackgroundColor, this.forceTint));
                    } else {
                        notification.setBackgroundDrawable(AHHelper.getTintDrawable(defaultDrawable, currentBackgroundColor, this.forceTint));
                    }
                }
            }
            if (notificationItem.isEmpty()) {
                this.hideNotification(notificationItem, notification);
                continue;
            }
            this.showNotification(notificationItem, notification);
        }
    }

    private void showNotification(AHNotification notification, AHTextView notificationView) {
        notificationView.setText(notification.getReadableText());
        this.updateNotificationSize(notification, notificationView);
        if (notificationView.getAlpha() != 1.0f) {
            if (notification.shouldAnimate()) {
                this.animateNotificationShow(notificationView);
                notification.setAnimate(false);
            } else {
                notificationView.setScaleX(1.0f);
                notificationView.setScaleY(1.0f);
                notificationView.setAlpha(1.0f);
            }
        }
    }

    private void animateNotificationShow(AHTextView notification) {
        notification.setScaleX(0.0f);
        notification.setScaleY(0.0f);
        notification.setAlpha(0.0f);
        notification.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator()).setDuration(this.notificationAnimationDuration).start();
    }

    private void hideNotification(AHNotification notification, AHTextView notificationView) {
        if (notificationView.getAlpha() != 0.0f) {
            if (notification.shouldAnimate()) {
                this.animateHideNotification(notificationView);
                notification.setAnimate(false);
            } else {
                notificationView.setScaleX(0.0f);
                notificationView.setScaleY(0.0f);
                notificationView.setAlpha(0.0f);
            }
        }
    }

    private void animateHideNotification(final AHTextView notification) {
        notification.animate().scaleX(0.0f).scaleY(0.0f).alpha(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (notification.getAlpha() == 0.0f) {
                    notification.setText("");
                }
            }
        }).setDuration(this.notificationAnimationDuration).start();
    }

    private void updateNotificationSize(AHNotification notificationItem, AHTextView notification) {
        ViewGroup.LayoutParams lp = notification.getLayoutParams();
        lp.width = notificationItem.getSize() >= 0 && !notificationItem.hasText() ? notificationItem.getSize() : -2;
        lp.height = notificationItem.getSize() >= 0 ? notificationItem.getSize() : this.getResources().getDimensionPixelSize(R.dimen.bottom_navigation_notification_height);
        notification.requestLayout();
    }

    private boolean shouldAnimateNotification(AHNotification notificationItem, AHTextView notification) {
        boolean shouldUpdateText = !notification.getText().toString().equals(notificationItem.getReadableText());
        boolean shouldUpdateSize = notificationItem.getSize() != notification.getHeight();
        return shouldUpdateText || shouldUpdateSize;
    }

    public void addItem(AHBottomNavigationItem item) {
        if (this.items.size() > 5) {
            Log.w((String)TAG, (String)"The items list should not have more than 5 items");
        }
        this.items.add(item);
        this.createItems();
    }

    public void addItems(List<AHBottomNavigationItem> items) {
        if (items.size() > 5 || this.items.size() + items.size() > 5) {
            Log.w((String)TAG, (String)"The items list should not have more than 5 items");
        }
        this.items.addAll(items);
        this.createItems();
    }

    public void removeItemAtIndex(int index) {
        if (index < this.items.size()) {
            this.items.remove(index);
            this.createItems();
        }
    }

    public void removeAllItems() {
        this.items.clear();
        this.createItems();
    }

    public void refresh() {
        this.createItems();
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public boolean isColored() {
        return this.colored;
    }

    public void setColored(boolean colored) {
        this.colored = colored;
        this.iconActiveColor = colored ? this.coloredTitleColorActive : this.titleActiveColor;
        this.iconInactiveColor = colored ? this.coloredTitleColorInactive : this.titleInactiveColor;
        this.createItems();
    }

    public int getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(@ColorInt int defaultBackgroundColor) {
        this.defaultBackgroundColor = defaultBackgroundColor;
        this.createItems();
    }

    public void setDefaultBackgroundResource(@DrawableRes int defaultBackgroundResource) {
        this.defaultBackgroundResource = defaultBackgroundResource;
        this.createItems();
    }

    @Nullable
    public Integer getIconActiveColor(int index) {
        return this.iconActiveColor.get(index);
    }

    public void setIconActiveColor(int index, @Nullable Integer activeColor) {
        if (AHHelper.equals(this.iconActiveColor.get(index), activeColor)) {
            return;
        }
        this.iconActiveColor.set(index, activeColor);
        this.createItems();
    }

    public void setTitleActiveColor(int index, @Nullable Integer activeColor) {
        if (AHHelper.equals(this.titleActiveColor.get(index), activeColor)) {
            return;
        }
        this.titleActiveColor.set(index, activeColor);
        this.createItems();
    }

    @Nullable
    public Integer getIconInactiveColor(int index) {
        return this.iconInactiveColor.get(index);
    }

    @Nullable
    public Integer getTitleInactiveColor(int index) {
        return this.titleInactiveColor.get(index);
    }

    public void setIconInactiveColor(int index, @Nullable Integer inactiveColor) {
        if (AHHelper.equals(this.iconInactiveColor.get(index), inactiveColor)) {
            return;
        }
        this.iconInactiveColor.set(index, inactiveColor);
        this.createItems();
    }

    public void setTitleInactiveColor(int index, @Nullable Integer inactiveColor) {
        if (AHHelper.equals(this.titleInactiveColor.get(index), inactiveColor)) {
            return;
        }
        this.titleInactiveColor.set(index, inactiveColor);
        this.createItems();
    }

    public void setColoredModeColors(int index, @ColorInt int colorActive, @ColorInt int colorInactive) {
        this.coloredTitleColorActive.set(index, colorActive);
        this.coloredTitleColorInactive.set(index, colorInactive);
        this.createItems();
    }

    public void setSelectedBackgroundVisible(boolean visible) {
        this.selectedBackgroundVisible = visible;
        this.createItems();
    }

    public void setTitleTypeface(int index, @Nullable Typeface typeface) {
        if (this.titleTypeface.get(index) == typeface) {
            return;
        }
        this.titleTypeface.set(index, typeface);
        this.createItems();
    }

    public void setTitleActiveTextSize(int index, Float activeSize) {
        if (AHHelper.equals(this.titleActiveTextSize.get(index), activeSize)) {
            return;
        }
        this.titleActiveTextSize.set(index, activeSize);
        this.createItems();
    }

    public void setTitleInactiveTextSize(int index, Float inactiveSize) {
        if (AHHelper.equals(this.titleInactiveTextSize.get(index), inactiveSize)) {
            return;
        }
        this.titleInactiveTextSize.set(index, inactiveSize);
        this.createItems();
    }

    public void setTitleActiveTextSizeInSp(int index, Float activeSize) {
        if (AHHelper.equals(this.titleActiveTextSize.get(index), activeSize)) {
            return;
        }
        this.titleActiveTextSize.set(index, Float.valueOf(TypedValue.applyDimension((int)2, (float)activeSize.floatValue(), (DisplayMetrics)this.resources.getDisplayMetrics())));
        this.createItems();
    }

    public void setTitleInactiveTextSizeInSp(int index, Float inactiveSize) {
        if (AHHelper.equals(this.titleInactiveTextSize.get(index), inactiveSize)) {
            return;
        }
        this.titleInactiveTextSize.set(index, Float.valueOf(TypedValue.applyDimension((int)2, (float)inactiveSize.floatValue(), (DisplayMetrics)this.resources.getDisplayMetrics())));
        this.createItems();
    }

    public void setTag(int index, String tag) {
        if (index >= 0 && index < this.views.size()) {
            this.views.get(index).setTag((Object)tag);
        }
    }

    public AHBottomNavigationItem getItem(int position) {
        if (position < 0 || position > this.items.size() - 1) {
            Log.w((String)TAG, (String)("The position is out of bounds of the items (" + this.items.size() + " elements)"));
            return null;
        }
        return this.items.get(position);
    }

    public int getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(int position) {
        this.setCurrentItem(position, true);
    }

    public void setCurrentItem(int position, boolean useCallback) {
        if (position >= this.items.size()) {
            Log.w((String)TAG, (String)("The position is out of bounds of the items (" + this.items.size() + " elements)"));
            return;
        }
        if (this.isClassic()) {
            this.updateItems(position, useCallback);
        } else {
            this.updateSmallItems(position, useCallback);
        }
    }

    public boolean isBehaviorTranslationEnabled() {
        return this.behaviorTranslationEnabled;
    }

    public void setBehaviorTranslationEnabled(boolean behaviorTranslationEnabled) {
        this.behaviorTranslationEnabled = behaviorTranslationEnabled;
        if (this.getParent() instanceof CoordinatorLayout) {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            if (this.bottomNavigationBehavior == null) {
                this.bottomNavigationBehavior = new AHBottomNavigationBehavior(behaviorTranslationEnabled, this.navigationBarHeight);
            } else {
                this.bottomNavigationBehavior.setBehaviorTranslationEnabled(behaviorTranslationEnabled, this.navigationBarHeight);
            }
            if (this.navigationPositionListener != null) {
                this.bottomNavigationBehavior.setOnNavigationPositionListener(this.navigationPositionListener);
            }
            ((CoordinatorLayout.LayoutParams)params).setBehavior(this.bottomNavigationBehavior);
            if (this.needHideBottomNavigation) {
                this.needHideBottomNavigation = false;
                this.bottomNavigationBehavior.hideView(this, this.bottomNavigationHeight, this.hideBottomNavigationWithAnimation);
            }
        }
    }

    public void manageFloatingActionButtonBehavior(FloatingActionButton fab) {
        if (fab.getParent() instanceof CoordinatorLayout) {
            AHBottomNavigationFABBehavior fabBehavior = new AHBottomNavigationFABBehavior(this.navigationBarHeight);
            ((CoordinatorLayout.LayoutParams)fab.getLayoutParams()).setBehavior((CoordinatorLayout.Behavior)fabBehavior);
        }
    }

    public void hideBottomNavigation() {
        this.hideBottomNavigation(true);
    }

    public void hideBottomNavigation(boolean withAnimation) {
        if (this.bottomNavigationBehavior != null) {
            this.bottomNavigationBehavior.hideView(this, this.bottomNavigationHeight, withAnimation);
        } else if (this.getParent() instanceof CoordinatorLayout) {
            this.needHideBottomNavigation = true;
            this.hideBottomNavigationWithAnimation = withAnimation;
        } else {
            ViewCompat.animate((View)this).translationY((float)this.bottomNavigationHeight).setInterpolator((Interpolator)new LinearOutSlowInInterpolator()).setDuration(withAnimation ? 300L : 0L).start();
        }
    }

    public void restoreBottomNavigation() {
        this.restoreBottomNavigation(true);
    }

    public void restoreBottomNavigation(boolean withAnimation) {
        if (this.bottomNavigationBehavior != null) {
            this.bottomNavigationBehavior.resetOffset(this, withAnimation);
        } else {
            ViewCompat.animate((View)this).translationY(0.0f).setInterpolator((Interpolator)new LinearOutSlowInInterpolator()).setDuration(withAnimation ? 300L : 0L).start();
        }
    }

    public boolean isTranslucentNavigationEnabled() {
        return this.translucentNavigationEnabled;
    }

    public void setTranslucentNavigationEnabled(boolean translucentNavigationEnabled) {
        this.translucentNavigationEnabled = translucentNavigationEnabled;
    }

    public boolean isForceTint() {
        return this.forceTint;
    }

    public void setForceTint(boolean forceTint) {
        this.forceTint = forceTint;
        this.createItems();
    }

    public TitleState getTitleState() {
        return this.titleState;
    }

    public void setTitleState(TitleState titleState) {
        this.titleState = titleState;
        this.createItems();
    }

    public void setOnTabSelectedListener(OnTabSelectedListener tabSelectedListener) {
        this.tabSelectedListener = tabSelectedListener;
    }

    public void removeOnTabSelectedListener() {
        this.tabSelectedListener = null;
    }

    public void setOnNavigationPositionListener(OnNavigationPositionListener navigationPositionListener) {
        this.navigationPositionListener = navigationPositionListener;
        if (this.bottomNavigationBehavior != null) {
            this.bottomNavigationBehavior.setOnNavigationPositionListener(navigationPositionListener);
        }
    }

    public void removeOnNavigationPositionListener() {
        this.navigationPositionListener = null;
        if (this.bottomNavigationBehavior != null) {
            this.bottomNavigationBehavior.removeOnNavigationPositionListener();
        }
    }

    @Deprecated
    public void setNotification(int nbNotification, int itemPosition) {
        if (itemPosition < 0 || itemPosition > this.items.size() - 1) {
            throw new IndexOutOfBoundsException(String.format(Locale.US, EXCEPTION_INDEX_OUT_OF_BOUNDS, itemPosition, this.items.size()));
        }
        String title = nbNotification == 0 ? "" : String.valueOf(nbNotification);
        this.notifications.set(itemPosition, AHNotification.justText(title));
        this.updateNotifications(false, itemPosition);
    }

    public void setNotification(String title, int itemPosition) {
        if (itemPosition < 0 || itemPosition > this.items.size() - 1) {
            throw new IndexOutOfBoundsException(String.format(Locale.US, EXCEPTION_INDEX_OUT_OF_BOUNDS, itemPosition, this.items.size()));
        }
        this.notifications.set(itemPosition, AHNotification.justText(title));
        this.updateNotifications(false, itemPosition);
    }

    public void setNotification(AHNotification notification, int itemPosition) {
        if (itemPosition < 0 || itemPosition > this.items.size() - 1) {
            throw new IndexOutOfBoundsException(String.format(Locale.US, EXCEPTION_INDEX_OUT_OF_BOUNDS, itemPosition, this.items.size()));
        }
        if (notification == null) {
            notification = new AHNotification();
        }
        this.notifications.set(itemPosition, notification);
        this.updateNotifications(true, itemPosition);
    }

    public void setNotificationSize(int index, @Px Integer size) {
        if (AHHelper.equals(this.notifications.get(index).getSize(), size)) {
            return;
        }
        this.notifications.get(index).setSize(size);
        this.updateNotifications(true, index);
    }

    public void setNotificationTextColor(@ColorInt int textColor) {
        if (this.notificationTextColor == textColor) {
            return;
        }
        this.notificationTextColor = textColor;
        this.updateNotifications(true, -1);
    }

    public void setNotificationTextColorResource(@ColorRes int textColor) {
        this.notificationTextColor = ContextCompat.getColor((Context)this.context, (int)textColor);
        this.updateNotifications(true, -1);
    }

    public void setNotificationBackground(Drawable drawable2) {
        this.notificationBackgroundDrawable = drawable2;
        this.updateNotifications(true, -1);
    }

    public void setNotificationBackgroundColor(@ColorInt int color2) {
        if (this.notificationBackgroundColor == color2) {
            return;
        }
        this.notificationBackgroundColor = color2;
        this.updateNotifications(true, -1);
    }

    public void setNotificationBackgroundColorResource(@ColorRes int color2) {
        this.notificationBackgroundColor = ContextCompat.getColor((Context)this.context, (int)color2);
        this.updateNotifications(true, -1);
    }

    public void setNotificationTypeface(Typeface typeface) {
        this.notificationTypeface = typeface;
        this.updateNotifications(true, -1);
    }

    public void setNotificationAnimationDuration(long notificationAnimationDuration) {
        this.notificationAnimationDuration = notificationAnimationDuration;
        this.updateNotifications(true, -1);
    }

    public void setNotificationMarginLeft(int activeMargin, int inactiveMargin) {
        this.notificationActiveMarginLeft = activeMargin;
        this.notificationInactiveMarginLeft = inactiveMargin;
        this.createItems();
    }

    public void setUseElevation(boolean useElevation) {
        ViewCompat.setElevation((View)this, (float)(useElevation ? this.resources.getDimension(R.dimen.bottom_navigation_elevation) : 0.0f));
        this.setClipToPadding(false);
    }

    public void setUseElevation(boolean useElevation, float elevation) {
        ViewCompat.setElevation((View)this, (float)(useElevation ? elevation : 0.0f));
        this.setClipToPadding(false);
    }

    public boolean isHidden() {
        if (this.bottomNavigationBehavior != null) {
            return this.bottomNavigationBehavior.isHidden();
        }
        return false;
    }

    public View getViewAtPosition(int position) {
        if (this.linearLayoutContainer != null && position >= 0 && position < this.linearLayoutContainer.getChildCount()) {
            return this.linearLayoutContainer.getChildAt(position);
        }
        return null;
    }

    public void enableItemAtPosition(int position) {
        if (position < 0 || position > this.items.size() - 1) {
            Log.w((String)TAG, (String)("The position is out of bounds of the items (" + this.items.size() + " elements)"));
            return;
        }
        this.itemsEnabledStates[position] = true;
        this.createItems();
    }

    public void disableItemAtPosition(int position) {
        if (position < 0 || position > this.items.size() - 1) {
            Log.w((String)TAG, (String)("The position is out of bounds of the items (" + this.items.size() + " elements)"));
            return;
        }
        this.itemsEnabledStates[position] = false;
        this.createItems();
    }

    public void setIconDisableColor(int index, @ColorInt int iconDisableColor) {
        this.iconDisableColor.set(index, iconDisableColor);
    }

    public void setPreferLargeIcons(boolean preferLargeIcons) {
        this.preferLargeIcons = preferLargeIcons;
    }

    private int dpToPx(int dp) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return dp * (metrics.densityDpi / 160);
    }

    public static interface OnNavigationPositionListener {
        public void onPositionChange(int var1);
    }

    public static interface OnTabSelectedListener {
        public boolean onTabSelected(int var1, boolean var2);
    }

    public static enum TitleState {
        SHOW_WHEN_ACTIVE,
        SHOW_WHEN_ACTIVE_FORCE,
        ALWAYS_SHOW,
        ALWAYS_HIDE;

    }
}

