/*
 * Decompiled with CFR 0.152.
 */
package com.wildma.idcardcamera.cropper;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.wildma.idcardcamera.cropper.CropListener;
import com.wildma.idcardcamera.cropper.CropPosition;

public class CropOverlayView
extends View {
    private int defaultMargin = 100;
    private int minDistance = 100;
    private int vertexSize = 30;
    private int gridSize = 3;
    private Bitmap bitmap;
    private Point topLeft;
    private Point topRight;
    private Point bottomLeft;
    private Point bottomRight;
    private float touchDownX;
    private float touchDownY;
    private CropPosition cropPosition;
    private int currentWidth = 0;
    private int currentHeight = 0;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int WIDTH_BLOCK = 40;
    private int HEIGHT_BLOCK = 40;

    public CropOverlayView(Context context) {
        super(context);
    }

    public CropOverlayView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
        this.resetPoints();
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.getWidth() != this.currentWidth || this.getHeight() != this.currentHeight) {
            this.currentWidth = this.getWidth();
            this.currentHeight = this.getHeight();
            this.resetPoints();
        }
        Log.e((String)"stk", (String)("canvasSize=" + this.getWidth() + "x" + this.getHeight()));
        this.drawBackground(canvas);
        this.drawVertex(canvas);
        this.drawEdge(canvas);
    }

    private void resetPoints() {
        Log.e((String)"stk", (String)("resetPoints, bitmap=" + this.bitmap));
        float scaleX = (float)this.bitmap.getWidth() * 1.0f / (float)this.getWidth();
        float scaleY = (float)this.bitmap.getHeight() * 1.0f / (float)this.getHeight();
        float maxScale = Math.max(scaleX, scaleY);
        int minX = 0;
        int maxX = this.getWidth();
        int minY = 0;
        int maxY = this.getHeight();
        if (maxScale == scaleY) {
            int bitmapInCanvasWidth = (int)((float)this.bitmap.getWidth() / maxScale);
            minX = (this.getWidth() - bitmapInCanvasWidth) / 2;
            maxX = this.getWidth() - minX;
        } else {
            int bitmapInCanvasHeight = (int)((float)this.bitmap.getHeight() / maxScale);
            minY = (this.getHeight() - bitmapInCanvasHeight) / 2;
            maxY = this.getHeight() - minY;
        }
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.defaultMargin = maxX - minX < this.defaultMargin || maxY - minY < this.defaultMargin ? 0 : 30;
        Log.e((String)"stk", (String)("maxX - minX=" + (maxX - minX)));
        Log.e((String)"stk", (String)("maxY - minY=" + (maxY - minY)));
        this.topLeft = new Point(minX + this.defaultMargin, minY + this.defaultMargin);
        this.topRight = new Point(maxX - this.defaultMargin, minY + this.defaultMargin);
        this.bottomLeft = new Point(minX + this.defaultMargin, maxY - this.defaultMargin);
        this.bottomRight = new Point(maxX - this.defaultMargin, maxY - this.defaultMargin);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void drawBackground(Canvas canvas) {
        Paint paint = new Paint();
        paint.setColor(Color.parseColor((String)"#66000000"));
        paint.setStyle(Paint.Style.FILL);
        Path path = new Path();
        path.moveTo((float)this.topLeft.x, (float)this.topLeft.y);
        path.lineTo((float)this.topRight.x, (float)this.topRight.y);
        path.lineTo((float)this.bottomRight.x, (float)this.bottomRight.y);
        path.lineTo((float)this.bottomLeft.x, (float)this.bottomLeft.y);
        path.close();
        canvas.save();
        canvas.clipPath(path, Region.Op.DIFFERENCE);
        canvas.drawColor(Color.parseColor((String)"#66000000"));
        canvas.restore();
    }

    private void drawVertex(Canvas canvas) {
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)this.topLeft.x, (float)this.topLeft.y, (float)this.vertexSize, paint);
        canvas.drawCircle((float)this.topRight.x, (float)this.topRight.y, (float)this.vertexSize, paint);
        canvas.drawCircle((float)this.bottomLeft.x, (float)this.bottomLeft.y, (float)this.vertexSize, paint);
        canvas.drawCircle((float)this.bottomRight.x, (float)this.bottomRight.y, (float)this.vertexSize, paint);
        Log.e((String)"stk", (String)("vertextPoints=" + this.topLeft.toString() + " " + this.topRight.toString() + " " + this.bottomRight.toString() + " " + this.bottomLeft.toString()));
    }

    private void drawEdge(Canvas canvas) {
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setStrokeWidth(3.0f);
        paint.setAntiAlias(true);
        canvas.drawLine((float)this.topLeft.x, (float)this.topLeft.y, (float)this.topRight.x, (float)this.topRight.y, paint);
        canvas.drawLine((float)this.topLeft.x, (float)this.topLeft.y, (float)this.bottomLeft.x, (float)this.bottomLeft.y, paint);
        canvas.drawLine((float)this.bottomRight.x, (float)this.bottomRight.y, (float)this.topRight.x, (float)this.topRight.y, paint);
        canvas.drawLine((float)this.bottomRight.x, (float)this.bottomRight.y, (float)this.bottomLeft.x, (float)this.bottomLeft.y, paint);
    }

    private void drawGrid(Canvas canvas) {
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setStrokeWidth(2.0f);
        paint.setAntiAlias(true);
        for (int i = 1; i <= this.gridSize; ++i) {
            int topDistanceX = Math.abs(this.topLeft.x - this.topRight.x) / (this.gridSize + 1) * i;
            int topDistanceY = Math.abs((this.topLeft.y - this.topRight.y) / (this.gridSize + 1) * i);
            Point top = new Point(this.topLeft.x < this.topRight.x ? this.topLeft.x + topDistanceX : this.topLeft.x - topDistanceX, this.topLeft.y < this.topRight.y ? this.topLeft.y + topDistanceY : this.topLeft.y - topDistanceY);
            int bottomDistanceX = Math.abs((this.bottomLeft.x - this.bottomRight.x) / (this.gridSize + 1) * i);
            int bottomDistanceY = Math.abs((this.bottomLeft.y - this.bottomRight.y) / (this.gridSize + 1) * i);
            Point bottom = new Point(this.bottomLeft.x < this.bottomRight.x ? this.bottomLeft.x + bottomDistanceX : this.bottomLeft.x - bottomDistanceX, this.bottomLeft.y < this.bottomRight.y ? this.bottomLeft.y + bottomDistanceY : this.bottomLeft.y - bottomDistanceY);
            canvas.drawLine((float)top.x, (float)top.y, (float)bottom.x, (float)bottom.y, paint);
            int leftDistanceX = Math.abs((this.topLeft.x - this.bottomLeft.x) / (this.gridSize + 1) * i);
            int leftDistanceY = Math.abs((this.topLeft.y - this.bottomLeft.y) / (this.gridSize + 1) * i);
            Point left = new Point(this.topLeft.x < this.bottomLeft.x ? this.topLeft.x + leftDistanceX : this.topLeft.x - leftDistanceX, this.topLeft.y < this.bottomLeft.y ? this.topLeft.y + leftDistanceY : this.topLeft.y - leftDistanceY);
            int rightDistanceX = Math.abs((this.topRight.x - this.bottomRight.x) / (this.gridSize + 1) * i);
            int rightDistanceY = Math.abs((this.topRight.y - this.bottomRight.y) / (this.gridSize + 1) * i);
            Point right = new Point(this.topRight.x < this.bottomRight.x ? this.topRight.x + rightDistanceX : this.topRight.x - rightDistanceX, this.topRight.y < this.bottomRight.y ? this.topRight.y + rightDistanceY : this.topRight.y - rightDistanceY);
            canvas.drawLine((float)left.x, (float)left.y, (float)right.x, (float)right.y, paint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                break;
            }
            case 0: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.onActionDown(event);
                return true;
            }
            case 2: {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.onActionMove(event);
                return true;
            }
        }
        return false;
    }

    private void onActionDown(MotionEvent event) {
        this.touchDownX = event.getX();
        this.touchDownY = event.getY();
        Point touchPoint = new Point((int)event.getX(), (int)event.getY());
        int minDistance = this.distance(touchPoint, this.topLeft);
        this.cropPosition = CropPosition.TOP_LEFT;
        if (minDistance > this.distance(touchPoint, this.topRight)) {
            minDistance = this.distance(touchPoint, this.topRight);
            this.cropPosition = CropPosition.TOP_RIGHT;
        }
        if (minDistance > this.distance(touchPoint, this.bottomLeft)) {
            minDistance = this.distance(touchPoint, this.bottomLeft);
            this.cropPosition = CropPosition.BOTTOM_LEFT;
        }
        if (minDistance > this.distance(touchPoint, this.bottomRight)) {
            minDistance = this.distance(touchPoint, this.bottomRight);
            this.cropPosition = CropPosition.BOTTOM_RIGHT;
        }
    }

    private int distance(Point src, Point dst) {
        return (int)Math.sqrt(Math.pow(src.x - dst.x, 2.0) + Math.pow(src.y - dst.y, 2.0));
    }

    private void onActionMove(MotionEvent event) {
        int deltaX = (int)(event.getX() - this.touchDownX);
        int deltaY = (int)(event.getY() - this.touchDownY);
        switch (this.cropPosition) {
            case TOP_LEFT: {
                this.adjustTopLeft(deltaX, deltaY);
                this.invalidate();
                break;
            }
            case TOP_RIGHT: {
                this.adjustTopRight(deltaX, deltaY);
                this.invalidate();
                break;
            }
            case BOTTOM_LEFT: {
                this.adjustBottomLeft(deltaX, deltaY);
                this.invalidate();
                break;
            }
            case BOTTOM_RIGHT: {
                this.adjustBottomRight(deltaX, deltaY);
                this.invalidate();
            }
        }
        this.touchDownX = event.getX();
        this.touchDownY = event.getY();
    }

    private void adjustTopLeft(int deltaX, int deltaY) {
        int newY;
        int newX = this.topLeft.x + deltaX;
        if (newX < this.minX) {
            newX = this.minX;
        }
        if (newX > this.maxX) {
            newX = this.maxX;
        }
        if ((newY = this.topLeft.y + deltaY) < this.minY) {
            newY = this.minY;
        }
        if (newY > this.maxY) {
            newY = this.maxY;
        }
        this.topLeft.set(newX, newY);
    }

    private void adjustTopRight(int deltaX, int deltaY) {
        int newY;
        int newX = this.topRight.x + deltaX;
        if (newX > this.maxX) {
            newX = this.maxX;
        }
        if (newX < this.minX) {
            newX = this.minX;
        }
        if ((newY = this.topRight.y + deltaY) < this.minY) {
            newY = this.minY;
        }
        if (newY > this.maxY) {
            newY = this.maxY;
        }
        this.topRight.set(newX, newY);
    }

    private void adjustBottomLeft(int deltaX, int deltaY) {
        int newY;
        int newX = this.bottomLeft.x + deltaX;
        if (newX < this.minX) {
            newX = this.minX;
        }
        if (newX > this.maxX) {
            newX = this.maxX;
        }
        if ((newY = this.bottomLeft.y + deltaY) > this.maxY) {
            newY = this.maxY;
        }
        if (newY < this.minY) {
            newY = this.minY;
        }
        this.bottomLeft.set(newX, newY);
    }

    private void adjustBottomRight(int deltaX, int deltaY) {
        int newY;
        int newX = this.bottomRight.x + deltaX;
        if (newX > this.maxX) {
            newX = this.maxX;
        }
        if (newX < this.minX) {
            newX = this.minX;
        }
        if ((newY = this.bottomRight.y + deltaY) > this.maxY) {
            newY = this.maxY;
        }
        if (newY < this.minY) {
            newY = this.minY;
        }
        this.bottomRight.set(newX, newY);
    }

    public void crop(CropListener cropListener, boolean needStretch) {
        if (this.topLeft == null) {
            return;
        }
        float scaleX = (float)this.bitmap.getWidth() * 1.0f / (float)this.getWidth();
        float scaleY = (float)this.bitmap.getHeight() * 1.0f / (float)this.getHeight();
        float maxScale = Math.max(scaleX, scaleY);
        Log.e((String)"stk", (String)("maxScale=" + maxScale));
        Point bitmapTopLeft = new Point((int)((float)(this.topLeft.x - this.minX) * maxScale), (int)((float)(this.topLeft.y - this.minY) * maxScale));
        Point bitmapTopRight = new Point((int)((float)(this.topRight.x - this.minX) * maxScale), (int)((float)(this.topRight.y - this.minY) * maxScale));
        Point bitmapBottomLeft = new Point((int)((float)(this.bottomLeft.x - this.minX) * maxScale), (int)((float)(this.bottomLeft.y - this.minY) * maxScale));
        Point bitmapBottomRight = new Point((int)((float)(this.bottomRight.x - this.minX) * maxScale), (int)((float)(this.bottomRight.y - this.minY) * maxScale));
        Log.e((String)"stk", (String)("bitmapPoints=" + bitmapTopLeft.toString() + " " + bitmapTopRight.toString() + " " + bitmapBottomRight.toString() + " " + bitmapBottomLeft.toString() + " "));
        Bitmap output = Bitmap.createBitmap((int)(this.bitmap.getWidth() + 1), (int)(this.bitmap.getHeight() + 1), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Path path = new Path();
        path.moveTo((float)bitmapTopLeft.x, (float)bitmapTopLeft.y);
        path.lineTo((float)bitmapTopRight.x, (float)bitmapTopRight.y);
        path.lineTo((float)bitmapBottomRight.x, (float)bitmapBottomRight.y);
        path.lineTo((float)bitmapBottomLeft.x, (float)bitmapBottomLeft.y);
        path.close();
        canvas.drawPath(path, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, paint);
        Rect cropRect = new Rect(Math.min(bitmapTopLeft.x, bitmapBottomLeft.x), Math.min(bitmapTopLeft.y, bitmapTopRight.y), Math.max(bitmapBottomRight.x, bitmapTopRight.x), Math.max(bitmapBottomRight.y, bitmapBottomLeft.y));
        if (cropRect.width() <= 0 || cropRect.height() <= 0) {
            cropListener.onFinish(null);
            return;
        }
        Bitmap cut = Bitmap.createBitmap((Bitmap)output, (int)cropRect.left, (int)cropRect.top, (int)cropRect.width(), (int)cropRect.height());
        if (!needStretch) {
            cropListener.onFinish(cut);
        } else {
            Point cutTopLeft = new Point();
            Point cutTopRight = new Point();
            Point cutBottomLeft = new Point();
            Point cutBottomRight = new Point();
            cutTopLeft.x = bitmapTopLeft.x > bitmapBottomLeft.x ? bitmapTopLeft.x - bitmapBottomLeft.x : 0;
            cutTopLeft.y = bitmapTopLeft.y > bitmapTopRight.y ? bitmapTopLeft.y - bitmapTopRight.y : 0;
            cutTopRight.x = bitmapTopRight.x > bitmapBottomRight.x ? cropRect.width() : cropRect.width() - Math.abs(bitmapBottomRight.x - bitmapTopRight.x);
            cutTopRight.y = bitmapTopLeft.y > bitmapTopRight.y ? 0 : Math.abs(bitmapTopLeft.y - bitmapTopRight.y);
            cutBottomLeft.x = bitmapTopLeft.x > bitmapBottomLeft.x ? 0 : Math.abs(bitmapTopLeft.x - bitmapBottomLeft.x);
            cutBottomLeft.y = bitmapBottomLeft.y > bitmapBottomRight.y ? cropRect.height() : cropRect.height() - Math.abs(bitmapBottomRight.y - bitmapBottomLeft.y);
            cutBottomRight.x = bitmapTopRight.x > bitmapBottomRight.x ? cropRect.width() - Math.abs(bitmapBottomRight.x - bitmapTopRight.x) : cropRect.width();
            cutBottomRight.y = bitmapBottomLeft.y > bitmapBottomRight.y ? cropRect.height() - Math.abs(bitmapBottomRight.y - bitmapBottomLeft.y) : cropRect.height();
            Log.e((String)"stk", (String)(cut.getWidth() + "x" + cut.getHeight()));
            Log.e((String)"stk", (String)("cutPoints=" + cutTopLeft.toString() + " " + cutTopRight.toString() + " " + cutBottomRight.toString() + " " + cutBottomLeft.toString() + " "));
            float width = cut.getWidth();
            float height = cut.getHeight();
            float[] src = new float[]{cutTopLeft.x, cutTopLeft.y, cutTopRight.x, cutTopRight.y, cutBottomRight.x, cutBottomRight.y, cutBottomLeft.x, cutBottomLeft.y};
            float[] dst = new float[]{0.0f, 0.0f, width, 0.0f, width, height, 0.0f, height};
            Matrix matrix = new Matrix();
            matrix.setPolyToPoly(src, 0, dst, 0, 4);
            Bitmap stretch = Bitmap.createBitmap((int)cut.getWidth(), (int)cut.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas stretchCanvas = new Canvas(stretch);
            stretchCanvas.concat(matrix);
            stretchCanvas.drawBitmapMesh(cut, this.WIDTH_BLOCK, this.HEIGHT_BLOCK, this.generateVertices(cut.getWidth(), cut.getHeight()), 0, null, 0, null);
            cropListener.onFinish(stretch);
        }
    }

    private float[] generateVertices(int widthBitmap, int heightBitmap) {
        float[] vertices = new float[(this.WIDTH_BLOCK + 1) * (this.HEIGHT_BLOCK + 1) * 2];
        float widthBlock = (float)widthBitmap / (float)this.WIDTH_BLOCK;
        float heightBlock = (float)heightBitmap / (float)this.HEIGHT_BLOCK;
        for (int i = 0; i <= this.HEIGHT_BLOCK; ++i) {
            for (int j = 0; j <= this.WIDTH_BLOCK; ++j) {
                vertices[i * ((this.HEIGHT_BLOCK + 1) * 2) + j * 2] = (float)j * widthBlock;
                vertices[i * ((this.HEIGHT_BLOCK + 1) * 2) + j * 2 + 1] = (float)i * heightBlock;
            }
        }
        return vertices;
    }
}

