/*
 * Decompiled with CFR 0.152.
 */
package com.whinc.widget.ratingbar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.whinc.widget.ratingbar.R;

public class RatingBar
extends FrameLayout
implements View.OnClickListener {
    private static final String TAG = RatingBar.class.getSimpleName();
    private static final int MAX_COUNT = 5;
    private int mMaxCount = 5;
    private int mCount = 0;
    private Drawable mFillDrawable = null;
    private Drawable mEmptyDrawable = null;
    private OnRatingChangeListener mOnRatingChangeListener = null;
    private int mSpace = 0;
    private boolean mTouchRating = true;
    private boolean mClickRating = true;
    private LinearLayout mRootLayout;
    private ImageView[] mImageViews = null;
    private Context mContext;
    private float mOldX = 0.0f;
    private float mOldY = 0.0f;
    private int mOldStarCount = 0;

    public boolean isTouchRating() {
        return this.mTouchRating;
    }

    public void setTouchRating(boolean touchRating) {
        this.mTouchRating = touchRating;
    }

    public boolean isClickRating() {
        return this.mClickRating;
    }

    public void setClickRating(boolean clickRating) {
        this.mClickRating = clickRating;
    }

    public RatingBar(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public RatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public RatingBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public int getSpace() {
        return this.mSpace;
    }

    public void setSpace(int space) {
        if (this.mSpace == (space = Math.max(0, space))) {
            return;
        }
        this.mSpace = space;
        this.updateStarViews();
    }

    public Drawable getFillDrawable() {
        return this.mFillDrawable;
    }

    public void setFillDrawable(Drawable fillDrawable) {
        if (this.mFillDrawable == fillDrawable) {
            return;
        }
        this.mFillDrawable = fillDrawable;
        this.updateStarViews();
    }

    public void setFillDrawableRes(int res) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setFillDrawable(this.mContext.getDrawable(res));
        } else {
            this.setFillDrawable(this.mContext.getResources().getDrawable(res));
        }
    }

    public Drawable getEmptyDrawable() {
        return this.mEmptyDrawable;
    }

    public void setEmptyDrawable(@Nullable Drawable emptyDrawable) {
        this.mEmptyDrawable = emptyDrawable;
        this.updateStarViews();
    }

    public void setEmptyDrawableRes(int res) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setEmptyDrawable(this.mContext.getDrawable(res));
        } else {
            this.setEmptyDrawable(this.mContext.getResources().getDrawable(res));
        }
    }

    public void setOnRatingChangeListener(@Nullable OnRatingChangeListener listener) {
        this.mOnRatingChangeListener = listener;
    }

    public int getMaxCount() {
        return this.mMaxCount;
    }

    public void setMaxCount(int maxCount) {
        if ((maxCount = Math.max(0, maxCount)) == this.mMaxCount) {
            return;
        }
        this.mMaxCount = maxCount;
        this.createStarViews(maxCount);
        if (maxCount < this.mCount) {
            this.setCount(maxCount);
        }
    }

    public int getCount() {
        return this.mCount;
    }

    public void setCount(int count) {
        if ((count = Math.max(0, Math.min(this.mMaxCount, count))) == this.mCount) {
            return;
        }
        int oldCount = this.mCount;
        this.mCount = count;
        this.updateStarViews();
        if (this.mOnRatingChangeListener != null) {
            this.mOnRatingChangeListener.onChange(this, oldCount, this.mCount);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        if (attrs == null) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.mFillDrawable = context.getDrawable(R.drawable.fill);
                this.mEmptyDrawable = context.getDrawable(R.drawable.empty);
            } else {
                this.mFillDrawable = context.getResources().getDrawable(R.drawable.fill);
                this.mEmptyDrawable = context.getResources().getDrawable(R.drawable.empty);
            }
        } else {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBar);
            this.mMaxCount = typedArray.getInteger(R.styleable.RatingBar_rb_max_count, 5);
            this.mCount = typedArray.getInteger(R.styleable.RatingBar_rb_count, 0);
            this.mFillDrawable = typedArray.getDrawable(R.styleable.RatingBar_rb_fill);
            this.mEmptyDrawable = typedArray.getDrawable(R.styleable.RatingBar_rb_empty);
            this.mSpace = typedArray.getDimensionPixelSize(R.styleable.RatingBar_rb_space, 0);
            this.mClickRating = typedArray.getBoolean(R.styleable.RatingBar_rb_click_rating, true);
            this.mTouchRating = typedArray.getBoolean(R.styleable.RatingBar_rb_touch_rating, true);
            typedArray.recycle();
            if (this.mFillDrawable == null) {
                this.mFillDrawable = Build.VERSION.SDK_INT >= 21 ? context.getDrawable(R.drawable.fill) : context.getResources().getDrawable(R.drawable.fill);
            }
            this.mMaxCount = Math.max(0, this.mMaxCount);
            this.mCount = Math.max(0, Math.min(this.mCount, this.mMaxCount));
        }
        this.mRootLayout = new LinearLayout(context);
        this.addView((View)this.mRootLayout, new ViewGroup.LayoutParams(-1, -1));
        this.createStarViews(this.mMaxCount);
    }

    private void createStarViews(int count) {
        if (this.mRootLayout.getChildCount() > 0) {
            this.mRootLayout.removeAllViews();
        }
        this.mImageViews = new ImageView[count];
        for (int i = 0; i < this.mImageViews.length; ++i) {
            FrameLayout frameLayout = new FrameLayout(this.getContext());
            LinearLayout.LayoutParams llp = new LinearLayout.LayoutParams(0, -1, 1.0f);
            this.mRootLayout.addView((View)frameLayout, (ViewGroup.LayoutParams)llp);
            this.mImageViews[i] = new ImageView(this.getContext());
            ImageView imageView = this.mImageViews[i];
            imageView.setOnClickListener((View.OnClickListener)this);
            imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            imageView.setTag((Object)i);
            FrameLayout.LayoutParams flp = new FrameLayout.LayoutParams(-1, -1, 17);
            frameLayout.addView((View)imageView, (ViewGroup.LayoutParams)flp);
        }
        this.updateStarViews();
    }

    private void updateStarViews() {
        for (int i = 0; i < this.mImageViews.length; ++i) {
            ImageView imgView = this.mImageViews[i];
            imgView.setImageDrawable(i < this.mCount ? this.mFillDrawable : this.mEmptyDrawable);
            ViewGroup parent = (ViewGroup)imgView.getParent();
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)parent.getLayoutParams();
            if (imgView.getDrawable() != null && i - 1 >= 0 && this.mImageViews[i - 1].getDrawable() != null) {
                mlp.setMargins(this.mSpace, 0, 0, 0);
            } else {
                mlp.setMargins(0, 0, 0, 0);
            }
            parent.setLayoutParams((ViewGroup.LayoutParams)mlp);
        }
    }

    public void onClick(View v) {
        Integer index = (Integer)v.getTag();
        this.setCount(index + 1);
    }

    public void setClickable(boolean clickable) {
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mOldX = event.getX();
                this.mOldY = event.getY();
                this.mOldStarCount = this.getTouchStarCount(event);
                return true;
            }
            case 2: {
                if (this.mTouchRating) {
                    float deltaX = event.getX() - this.mOldX;
                    float deltaY = event.getY() - this.mOldY;
                    int distance = (int)Math.round(Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0)));
                    if (distance >= ViewConfiguration.getTouchSlop()) {
                        this.setCount(this.getTouchStarCount(event));
                    }
                }
                this.mOldX = event.getX();
                this.mOldY = event.getY();
                break;
            }
            case 1: {
                int starCount;
                if (!this.mClickRating || (starCount = this.getTouchStarCount(event)) != this.mOldStarCount) break;
                this.setCount(starCount);
                break;
            }
        }
        if (super.onTouchEvent(event)) {
            // empty if block
        }
        return false;
    }

    private View getStarView(int index) {
        return this.mRootLayout.getChildAt(index);
    }

    private int getTouchStarCount(MotionEvent event) {
        int count = 1;
        float rawX = event.getRawX();
        for (int i = 0; i < this.getMaxCount(); ++i) {
            Rect rect = new Rect();
            View view = this.getStarView(i);
            view.getGlobalVisibleRect(rect);
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            if (!(rawX > (float)(rect.right + mlp.rightMargin))) continue;
            ++count;
        }
        return count;
    }

    public static interface OnRatingChangeListener {
        public void onChange(RatingBar var1, int var2, int var3);
    }
}

