/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.network;

import android.text.TextUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import tech.linjiang.pandora.cache.Content;
import tech.linjiang.pandora.cache.Summary;
import tech.linjiang.pandora.network.NetStateListener;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.FileUtil;
import tech.linjiang.pandora.util.FormatUtil;
import tech.linjiang.pandora.util.Utils;

public class OkHttpInterceptor
implements Interceptor {
    private static final String TAG = "OkHttpInterceptor";
    public static final long MAX_SIZE_BODY = 0x200000L;
    private NetStateListener listener;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        long delayReq;
        long id = -1L;
        Request request = chain.request();
        if (Config.isNetLogEnable()) {
            id = this.insert(request);
            this.notifyStart(id);
        }
        if ((delayReq = Config.getNETWORK_DELAY_REQ()) > 0L) {
            try {
                Thread.sleep(delayReq);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            response = chain.proceed(request);
        }
        catch (Throwable e) {
            if (Config.isNetLogEnable() && id >= 0L) {
                this.markFailed(id, Utils.collectThrow(e));
                this.notifyEnd(id);
            }
            throw e;
        }
        long delayRes = Config.getNETWORK_DELAY_RES();
        if (delayRes > 0L) {
            try {
                Thread.sleep(delayRes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (Config.isNetLogEnable() && id >= 0L) {
            this.updateSummary(id, response);
            this.updateContent(id, response);
            this.notifyEnd(id);
        }
        return response;
    }

    private long insert(Request request) {
        long id;
        boolean canRecognize;
        RequestBody requestBody;
        Summary summary = new Summary();
        Content content = new Content();
        summary.status = 0;
        summary.url = request.url().encodedPath();
        summary.host = request.url().host() + ":" + request.url().port();
        summary.method = request.method();
        summary.ssl = request.isHttps();
        summary.start_time = System.currentTimeMillis();
        summary.requestHeader = FormatUtil.formatHeaders(request.headers());
        String query = request.url().encodedQuery();
        if (!TextUtils.isEmpty((CharSequence)query)) {
            summary.query = query;
        }
        if ((requestBody = request.body()) != null) {
            try {
                summary.request_size = requestBody.contentLength();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (requestBody.contentType() != null) {
                summary.request_content_type = requestBody.contentType().toString();
            }
        }
        if (canRecognize = this.checkContentEncoding(request.header("Content-Encoding"))) {
            content.requestBody = OkHttpInterceptor.requestBodyAsStr(request);
        }
        content.id = id = Summary.insert(summary);
        Content.insert(content);
        return id;
    }

    private void updateSummary(long reqId, Response response) {
        Summary summary = Summary.query(reqId);
        if (summary == null) {
            return;
        }
        summary.status = 2;
        summary.end_time = System.currentTimeMillis();
        summary.code = response.code();
        summary.protocol = response.protocol().toString();
        summary.responseHeader = FormatUtil.formatHeaders(response.headers());
        ResponseBody body = response.body();
        if (body != null) {
            MediaType type = body.contentType();
            if (type != null) {
                summary.response_content_type = type.toString();
            }
            summary.response_size = body.contentLength();
        }
        Summary.update(summary);
    }

    private void updateContent(long reqId, Response response) {
        Content content;
        String bodyStr;
        MediaType type;
        ResponseBody body = response.body();
        if (body != null && (type = body.contentType()) != null && type.toString().contains("image")) {
            byte[] bytes = OkHttpInterceptor.responseBodyAsBytes(response);
            if (bytes != null) {
                String path = FileUtil.saveFile(bytes, response.request().url().toString(), null);
                Content content2 = Content.query(reqId);
                if (content2 != null) {
                    content2.responseBody = path;
                    Content.update(content2);
                }
            }
            return;
        }
        boolean canRecognize = this.checkContentEncoding(response.header("Content-Encoding"));
        if (canRecognize && !TextUtils.isEmpty((CharSequence)(bodyStr = OkHttpInterceptor.responseBodyAsStr(response))) && (content = Content.query(reqId)) != null) {
            content.responseBody = bodyStr;
            Content.update(content);
        }
    }

    private void markFailed(long id, String err) {
        Summary summary = Summary.query(id);
        if (summary == null) {
            return;
        }
        summary.status = 1;
        summary.end_time = System.currentTimeMillis();
        Summary.update(summary);
        Content content = Content.query(id);
        if (content != null) {
            content.responseBody = err;
            Content.update(content);
        }
    }

    private void notifyStart(final long id) {
        if (this.listener != null) {
            Utils.post(new Runnable(){

                @Override
                public void run() {
                    if (OkHttpInterceptor.this.listener != null) {
                        OkHttpInterceptor.this.listener.onRequestStart(id);
                    }
                }
            });
        }
    }

    private void notifyEnd(final long id) {
        if (this.listener != null) {
            Utils.post(new Runnable(){

                @Override
                public void run() {
                    if (OkHttpInterceptor.this.listener != null) {
                        OkHttpInterceptor.this.listener.onRequestEnd(id);
                    }
                }
            });
        }
    }

    private static boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private boolean checkContentEncoding(String contentEncoding) {
        return contentEncoding == null || contentEncoding.equalsIgnoreCase("identity") || contentEncoding.equalsIgnoreCase("gzip");
    }

    private static String requestBodyAsStr(Request request) {
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            return null;
        }
        MediaType contentType = requestBody.contentType();
        if (contentType != null && !TextUtils.isEmpty((CharSequence)contentType.toString()) && (contentType.toString().contains("form-data") || contentType.toString().contains("octet-stream"))) {
            try {
                return " (binary " + requestBody.contentLength() + "-byte body omitted)";
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        String contentEncoding = request.header("Content-Encoding");
        boolean gzip = "gzip".equalsIgnoreCase(contentEncoding);
        Buffer buffer = new Buffer();
        try {
            requestBody.writeTo((BufferedSink)buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (!OkHttpInterceptor.isPlaintext(buffer)) {
            try {
                return " (binary " + requestBody.contentLength() + "-byte body omitted)";
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            if (requestBody.contentLength() > 0x200000L) {
                return "(binary " + requestBody.contentLength() + "-byte body omitted)";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return OkHttpInterceptor.sourceToStrInternal((Source)buffer, gzip, requestBody.contentType());
    }

    private static String responseBodyAsStr(Response response) {
        ResponseBody responseBody = response.body();
        if (responseBody == null || !HttpHeaders.hasBody((Response)response)) {
            return null;
        }
        try {
            BufferedSource source = responseBody.source();
            source.request(64L);
            Buffer buffer = source.buffer();
            if (!OkHttpInterceptor.isPlaintext(buffer)) {
                return "(binary " + responseBody.contentLength() + "-byte body omitted)";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (responseBody.contentLength() > 0x200000L) {
            return "(binary " + responseBody.contentLength() + "-byte body omitted)";
        }
        String contentEncoding = response.header("Content-Encoding");
        boolean gzip = "gzip".equalsIgnoreCase(contentEncoding);
        try {
            return OkHttpInterceptor.sourceToStrInternal((Source)response.peekBody(Long.MAX_VALUE).source(), gzip, responseBody.contentType());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sourceToStrInternal(Source source, boolean gzip, MediaType contentType) {
        BufferedSource bufferedSource;
        if (gzip) {
            GzipSource gzipSource = new GzipSource(source);
            bufferedSource = Okio.buffer((Source)gzipSource);
        } else {
            bufferedSource = Okio.buffer((Source)source);
        }
        String tempStr = null;
        Charset charset = UTF8;
        if (contentType != null) {
            charset = contentType.charset(UTF8);
        }
        try {
            tempStr = bufferedSource.readString(charset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufferedSource.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempStr;
    }

    private static byte[] requestBodyAsBytes(Request request) {
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            return null;
        }
        Buffer buffer = new Buffer();
        try {
            requestBody.writeTo((BufferedSink)buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return OkHttpInterceptor.sourceToBytesInternal((Source)buffer);
    }

    private static byte[] responseBodyAsBytes(Response response) {
        ResponseBody responseBody = response.body();
        if (responseBody == null || !HttpHeaders.hasBody((Response)response)) {
            return null;
        }
        try {
            return OkHttpInterceptor.sourceToBytesInternal((Source)response.peekBody(Long.MAX_VALUE).source());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] sourceToBytesInternal(Source source) {
        BufferedSource bufferedSource = Okio.buffer((Source)source);
        byte[] result = null;
        try {
            result = bufferedSource.readByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufferedSource.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void setListener(NetStateListener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }
}

