/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.sandbox.Sandbox;
import tech.linjiang.pandora.ui.GeneralDialog;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.FileAttrFragment;
import tech.linjiang.pandora.ui.item.FileItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.FileUtil;
import tech.linjiang.pandora.util.Utils;

public class FileFragment
extends BaseListFragment {
    private File file;

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.file = (File)this.getArguments().getSerializable("param1");
        this.getToolbar().setTitle((CharSequence)this.file.getName());
        this.getToolbar().getMenu().add(0, 0, 0, R.string.pd_name_delete_key).setIcon(R.drawable.pd_delete).setShowAsAction(2);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (item.getOrder() == 0) {
                    GeneralDialog.build(2).title(R.string.pd_help_title).message(R.string.pd_make_sure, true).positiveButton(R.string.pd_ok).negativeButton(R.string.pd_cancel).show(FileFragment.this);
                }
                return true;
            }
        });
        this.refresh();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 1) {
                this.refresh();
                this.getTargetFragment().onActivityResult(this.getTargetRequestCode(), -1, null);
            } else if (requestCode == 2) {
                FileUtil.deleteDirectory(this.file);
                this.getTargetFragment().onActivityResult(this.getTargetRequestCode(), -1, null);
                this.onBackPressed();
            }
        }
    }

    private void refresh() {
        List<File> files = Sandbox.getFiles(this.file);
        if (Utils.isNotEmpty(files)) {
            ArrayList<BaseItem> data = new ArrayList<BaseItem>();
            data.add(new TitleItem(String.format(Locale.getDefault(), "%d FILES", files.size())));
            for (int i = 0; i < files.size(); ++i) {
                data.add(new FileItem(files.get(i)));
            }
            this.getAdapter().setItems(data);
            this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

                @Override
                public void onItemClick(int position, BaseItem item) {
                    Bundle bundle = new Bundle();
                    if (item instanceof FileItem) {
                        bundle.putSerializable("param1", (Serializable)((File)item.data));
                        if (((File)item.data).isDirectory()) {
                            FileFragment.this.launch(FileFragment.class, bundle, 1);
                        } else {
                            FileFragment.this.launch(FileAttrFragment.class, bundle, 1);
                        }
                    }
                }
            });
        } else {
            this.showError(null);
        }
    }
}

