/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.File;
import tech.linjiang.pandora.cache.Content;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.fragment.BaseFragment;
import tech.linjiang.pandora.util.FileUtil;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class NetContentFragment
extends BaseFragment {
    private boolean showResponse;
    private long id;
    private String contentType;
    private String originContent;
    private WebView webView;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.showResponse = this.getArguments().getBoolean("param1", true);
        this.id = this.getArguments().getLong("param2");
        this.contentType = this.getArguments().getString("param3");
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected View getLayoutView() {
        this.webView = new WebView(this.getContext());
        this.webView.getSettings().setDefaultTextEncodingName("UTF-8");
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                NetContentFragment.this.loadData();
            }
        });
        return this.webView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Content");
        this.webView.loadUrl("file:///android_asset/tmp_json.html");
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.closeSoftInput();
    }

    @Override
    protected int getLayoutId() {
        return 0;
    }

    private void setSearchView() {
        this.getToolbar().getMenu().add(-1, 0, 0, R.string.pd_name_copy_value);
        this.getToolbar().getMenu().add(-1, 0, 1, R.string.pd_name_share);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (item.getOrder() == 0) {
                    Utils.copy2ClipBoard(NetContentFragment.this.originContent);
                } else if (item.getOrder() == 1) {
                    NetContentFragment.this.saveAsFileAndShare(NetContentFragment.this.originContent);
                }
                return true;
            }
        });
    }

    private void saveAsFileAndShare(String msg) {
        this.showLoading();
        new SimpleTask<String, Intent>(new SimpleTask.Callback<String, Intent>(){

            public Intent doInBackground(String[] params) {
                String path = FileUtil.saveFile(params[0].getBytes(), "json", "txt");
                String newPath = FileUtil.fileCopy2Tmp(new File(path));
                if (!TextUtils.isEmpty((CharSequence)newPath)) {
                    return FileUtil.getFileIntent(newPath);
                }
                return null;
            }

            @Override
            public void onPostExecute(Intent result) {
                NetContentFragment.this.hideLoading();
                if (result != null) {
                    try {
                        NetContentFragment.this.startActivity(result);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Utils.toast(t.getMessage());
                    }
                } else {
                    Utils.toast(R.string.pd_failed);
                }
            }
        }).execute(new String[]{msg});
    }

    private void loadData() {
        this.showLoading();
        new SimpleTask<Void, String>(new SimpleTask.Callback<Void, String>(){

            public String doInBackground(Void[] params) {
                Content content = Content.query(NetContentFragment.this.id);
                String result = NetContentFragment.this.showResponse ? content.responseBody : content.requestBody;
                return result;
            }

            @Override
            public void onPostExecute(String result) {
                NetContentFragment.this.hideLoading();
                if (TextUtils.isEmpty((CharSequence)result)) {
                    Utils.toast(R.string.pd_error_msg);
                    return;
                }
                NetContentFragment.this.setSearchView();
                NetContentFragment.this.originContent = result;
                NetContentFragment.this.webView.setWebViewClient(null);
                if (NetContentFragment.this.contentType != null && NetContentFragment.this.contentType.toLowerCase().contains("json")) {
                    result = result.replaceAll("\n", "");
                    result = result.replace("\\", "\\\\");
                    result = result.replace("'", "\\'");
                    if (Build.VERSION.SDK_INT < 19) {
                        NetContentFragment.this.webView.loadUrl(String.format("javascript:showJson('%s')", result));
                    } else {
                        NetContentFragment.this.webView.evaluateJavascript(String.format("showJson('%s')", result), null);
                    }
                } else {
                    NetContentFragment.this.webView.loadDataWithBaseURL(null, result, NetContentFragment.this.decideMimeType(), "utf-8", null);
                }
            }
        }).execute(new Void[0]);
    }

    private String decideMimeType() {
        if (this.contentType != null && this.contentType.toLowerCase().contains("xml")) {
            return "text/xml";
        }
        return "text/html";
    }
}

