/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector;

import android.content.Context;
import android.os.Build;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class CurInfoView
extends AppCompatTextView {
    private boolean isOpen;
    private static final CurInfoView curInfoView = new CurInfoView(Utils.getContext());
    private static CharSequence lastInfo;

    public CurInfoView(Context context) {
        super(context);
        this.setBackgroundColor(0x6F000000);
        this.setTextSize(14.0f);
        this.setTextColor(-1);
        this.setGravity(17);
        this.setPadding(ViewKnife.dip2px(4.0f), 0, ViewKnife.dip2px(4.0f), 0);
    }

    private static void open() {
        try {
            WindowManager windowManager = (WindowManager)Utils.getContext().getSystemService("window");
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = -2;
            params.height = -2;
            params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
            params.flags = 24;
            params.format = -3;
            params.gravity = Config.getUI_ACTIVITY_GRAVITY();
            windowManager.addView((View)curInfoView, (ViewGroup.LayoutParams)params);
            CurInfoView.curInfoView.isOpen = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void close() {
        Utils.removeViewFromWindow((View)curInfoView);
        CurInfoView.curInfoView.isOpen = false;
    }

    public static void toggle() {
        if (CurInfoView.curInfoView.isOpen) {
            CurInfoView.close();
        } else {
            CurInfoView.open();
        }
    }

    public static void show() {
        curInfoView.setVisibility(0);
    }

    public static void hide() {
        curInfoView.setVisibility(8);
    }

    public static void updateText(CharSequence value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            lastInfo = curInfoView.getText();
        } else {
            value = lastInfo;
        }
        curInfoView.setText(value);
    }
}

