/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.RelativeLayout;
import android.widget.TextView;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.connector.SimpleAnimationListener;
import tech.linjiang.pandora.ui.connector.UIStateCallback;
import tech.linjiang.pandora.ui.view.SwipeBackLayout;
import tech.linjiang.pandora.util.ViewKnife;

abstract class BaseFragment
extends Fragment
implements SwipeBackLayout.DismissCallback {
    protected final String TAG = this.getClass().getSimpleName();
    protected static final String PARAM1 = "param1";
    protected static final String PARAM2 = "param2";
    protected static final String PARAM3 = "param3";
    protected static final String PARAM4 = "param4";
    protected static final String PARAM_TITLE = "param_title";
    private Toolbar toolbar;
    private UIStateCallback uiState;
    private TextView tvError;

    public BaseFragment() {
        this.setArguments(new Bundle());
    }

    protected final void launch(Class<? extends BaseFragment> target, Bundle extra) {
        this.launch(target, null, extra);
    }

    protected final void launch(Class<? extends BaseFragment> target, String title, Bundle extra) {
        if (this.getActivity() == null) {
            return;
        }
        this.closeSoftInput();
        if (extra == null) {
            extra = new Bundle();
        }
        extra.putString(PARAM_TITLE, title);
        try {
            Fragment fragment = target.newInstance();
            fragment.setArguments(extra);
            this.getActivity().getSupportFragmentManager().beginTransaction().setCustomAnimations(R.anim.slide_in_right_, 0, 0, R.anim.slide_out_right_).add(R.id.pd_fragment_container_id, fragment).addToBackStack(null).commitAllowingStateLoss();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof UIStateCallback) {
            this.uiState = (UIStateCallback)context;
        }
    }

    public void onDetach() {
        super.onDetach();
        this.uiState = null;
    }

    @Nullable
    public final View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = this.getLayoutView();
        if (view == null) {
            view = inflater.inflate(this.getLayoutId(), container, false);
        }
        view = this.afterInflateAndBeforeAny(view);
        View finalView = this.installToolbar(view);
        finalView = this.installSwipe(finalView);
        finalView.setClickable(true);
        return finalView;
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.uiState != null) {
            this.uiState.hideHint();
        }
    }

    public final Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        if (nextAnim == 0 || !enter) {
            if (enter && this.getView() != null) {
                this.onViewEnterAnimEnd(this.getView());
            }
            return super.onCreateAnimation(transit, enter, nextAnim);
        }
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)nextAnim);
        anim2.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

            @Override
            public void onAnimationEnd(Animation animation) {
                if (BaseFragment.this.getView() != null) {
                    BaseFragment.this.onViewEnterAnimEnd(BaseFragment.this.getView());
                }
            }
        });
        return anim2;
    }

    @Override
    public void onDismiss() {
        if (!this.isDetached() && this.getFragmentManager() != null) {
            if (this.getFragmentManager().getBackStackEntryCount() > 0) {
                try {
                    this.getFragmentManager().popBackStackImmediate();
                }
                catch (Throwable throwable) {}
            } else {
                this.onBackPressed();
            }
        }
    }

    @LayoutRes
    protected abstract int getLayoutId();

    protected View getLayoutView() {
        return null;
    }

    protected boolean enableToolbar() {
        return true;
    }

    protected boolean enableSwipeBack() {
        return true;
    }

    protected void onViewEnterAnimEnd(View container) {
    }

    private View installSwipe(View content) {
        SwipeBackLayout swipeBackLayout = new SwipeBackLayout(this.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        swipeBackLayout.setLayoutParams(params);
        swipeBackLayout.setBackgroundColor(0);
        swipeBackLayout.attach(this, content);
        swipeBackLayout.enableGesture(this.enableSwipeBack());
        return swipeBackLayout;
    }

    private View installToolbar(View view) {
        if (!this.enableToolbar()) {
            return view;
        }
        this.toolbar = new Toolbar((Context)new ContextThemeWrapper(this.getContext(), R.style.ToolbarTheme));
        this.toolbar.inflateMenu(R.menu.pd_menu_common);
        this.toolbar.setId(R.id.pd_toolbar_id);
        this.toolbar.setTitle((CharSequence)this.getArguments().getString(PARAM_TITLE, ViewKnife.getString(R.string.pd_lib_name)));
        this.toolbar.setBackgroundColor(ViewKnife.getColor(R.color.pd_toolbar_bg));
        this.toolbar.setNavigationIcon(ViewKnife.getDrawable(R.drawable.pd_close));
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseFragment.this.onBackPressed();
            }
        });
        ViewGroup.LayoutParams toolbarParams = new ViewGroup.LayoutParams(-1, -2);
        if (Build.VERSION.SDK_INT >= 19) {
            this.toolbar.setPadding(this.toolbar.getPaddingLeft(), this.toolbar.getPaddingTop() + ViewKnife.getStatusHeight(), this.toolbar.getPaddingRight(), this.toolbar.getPaddingBottom());
        }
        RelativeLayout layout2 = new RelativeLayout(this.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        layout2.setLayoutParams(params);
        layout2.addView((View)this.toolbar, toolbarParams);
        RelativeLayout.LayoutParams rlParams = new RelativeLayout.LayoutParams(-1, -1);
        rlParams.addRule(3, R.id.pd_toolbar_id);
        layout2.addView(view, (ViewGroup.LayoutParams)rlParams);
        return layout2;
    }

    protected View afterInflateAndBeforeAny(View view) {
        return view;
    }

    protected final Toolbar getToolbar() {
        return this.toolbar;
    }

    protected final void onBackPressed() {
        if (this.getActivity() != null) {
            this.getActivity().onBackPressed();
        }
    }

    protected final void openSoftInput() {
        if (this.getContext() == null) {
            return;
        }
        try {
            InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
            imm.toggleSoftInput(0, 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected final void closeSoftInput() {
        if (this.getContext() == null) {
            return;
        }
        try {
            ((InputMethodManager)this.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.getActivity().getWindow().getDecorView().getWindowToken(), 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected final void showLoading() {
        if (this.uiState != null) {
            this.uiState.showHint();
        }
    }

    protected final void hideLoading() {
        if (this.uiState != null) {
            this.uiState.hideHint();
        }
    }

    protected final void showError(String msg) {
        this.hideLoading();
        if (this.tvError == null) {
            this.tvError = new TextView(this.getContext());
            this.tvError.setGravity(17);
            this.tvError.setTextSize(16.0f);
            this.tvError.setTextColor(ViewKnife.getColor(R.color.pd_label));
            this.tvError.setBackgroundColor(ViewKnife.getColor(R.color.pd_main_bg));
            this.tvError.setClickable(true);
            RelativeLayout.LayoutParams rlParams = new RelativeLayout.LayoutParams(-1, -1);
            rlParams.addRule(3, R.id.pd_toolbar_id);
            ((RelativeLayout)this.toolbar.getParent()).addView((View)this.tvError, (ViewGroup.LayoutParams)rlParams);
        }
        if (this.tvError.getVisibility() != 0) {
            this.tvError.setVisibility(0);
        }
        this.tvError.setText((CharSequence)(TextUtils.isEmpty((CharSequence)msg) ? ViewKnife.getString(R.string.pd_error_msg) : msg));
    }

    protected final void hideError() {
        if (this.tvError != null) {
            this.tvError.setVisibility(8);
        }
    }
}

