/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import tech.linjiang.pandora.core.R;

public class SwipeBackLayout
extends FrameLayout {
    public static final int EDGE_LEFT = 1;
    private static final int FULL_ALPHA = 255;
    private static final float DEFAULT_SCROLL_THRESHOLD = 0.4f;
    private static final int OVER_SCROLL_DISTANCE = 10;
    private ViewDragHelper mHelper;
    private float mScrollPercent;
    private float mScrimOpacity;
    private Drawable mShadow;
    private Rect mTmpRect = new Rect();
    private int mEdgeFlag = 1;
    private boolean mEnable = true;
    private int orientation;
    private DismissCallback callback;

    public SwipeBackLayout(Context context) {
        this(context, null);
    }

    public SwipeBackLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeBackLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)new ViewDragCallback());
        this.mShadow = this.getResources().getDrawable(R.drawable.pd_shadow_left);
        this.mHelper.setEdgeTrackingEnabled(1);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean isDrawView = child == this.getChildAt(0);
        boolean drawChild = super.drawChild(canvas, child, drawingTime);
        if (isDrawView && this.mScrimOpacity > 0.0f && this.mHelper.getViewDragState() != 0) {
            this.drawShadow(canvas, child);
        }
        return drawChild;
    }

    private void drawShadow(Canvas canvas, View child) {
        Rect childRect = this.mTmpRect;
        child.getHitRect(childRect);
        if ((this.orientation & 1) != 0) {
            this.mShadow.setBounds(childRect.left - this.mShadow.getIntrinsicWidth(), childRect.top, childRect.left, childRect.bottom);
            this.mShadow.setAlpha((int)(this.mScrimOpacity * 255.0f));
            this.mShadow.draw(canvas);
        }
    }

    public void computeScroll() {
        this.mScrimOpacity = 1.0f - this.mScrollPercent;
        if (this.mScrimOpacity >= 0.0f && this.mHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void attach(DismissCallback callback, View view) {
        if (this.getChildCount() > 0) {
            this.removeAllViews();
        }
        this.addView(view);
        this.callback = callback;
    }

    public void enableGesture(boolean enable) {
        this.mEnable = enable;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mEnable) {
            return super.onInterceptTouchEvent(ev);
        }
        return this.mHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnable) {
            return super.onTouchEvent(event);
        }
        this.mHelper.processTouchEvent(event);
        return true;
    }

    public static interface DismissCallback {
        public void onDismiss();
    }

    class ViewDragCallback
    extends ViewDragHelper.Callback {
        ViewDragCallback() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            boolean dragEnable = SwipeBackLayout.this.mHelper.isEdgeTouched(SwipeBackLayout.this.mEdgeFlag, pointerId);
            if (dragEnable && SwipeBackLayout.this.mHelper.isEdgeTouched(1, pointerId)) {
                SwipeBackLayout.this.orientation = 1;
            }
            return dragEnable;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            int ret = 0;
            if ((SwipeBackLayout.this.orientation & 1) != 0) {
                ret = Math.min(child.getWidth(), Math.max(left, 0));
            }
            return ret;
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if ((SwipeBackLayout.this.orientation & 1) != 0) {
                SwipeBackLayout.this.mScrollPercent = Math.abs((float)left / (float)(SwipeBackLayout.this.getWidth() + SwipeBackLayout.this.mShadow.getIntrinsicWidth()));
            }
            SwipeBackLayout.this.invalidate();
            if (SwipeBackLayout.this.mScrollPercent > 1.0f && SwipeBackLayout.this.callback != null) {
                SwipeBackLayout.this.callback.onDismiss();
            }
        }

        public int getViewHorizontalDragRange(View child) {
            return 1;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int childWidth = releasedChild.getWidth();
            int left = 0;
            int top = 0;
            if ((SwipeBackLayout.this.orientation & 1) != 0) {
                left = xvel > 0.0f || xvel == 0.0f && SwipeBackLayout.this.mScrollPercent > 0.4f ? childWidth + SwipeBackLayout.this.mShadow.getIntrinsicWidth() + 10 : 0;
            }
            SwipeBackLayout.this.mHelper.settleCapturedViewAt(left, top);
            SwipeBackLayout.this.invalidate();
        }

        public void onEdgeTouched(int edgeFlags, int pointerId) {
            super.onEdgeTouched(edgeFlags, pointerId);
            if ((SwipeBackLayout.this.mEdgeFlag & edgeFlags) != 0) {
                SwipeBackLayout.this.orientation = edgeFlags;
            }
        }
    }
}

