/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.inspector.OperableView;
import tech.linjiang.pandora.ui.fragment.BaseFragment;
import tech.linjiang.pandora.ui.fragment.HierarchyFragment;
import tech.linjiang.pandora.ui.fragment.ViewAttrFragment;
import tech.linjiang.pandora.ui.item.ViewItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class ViewFragment
extends BaseFragment
implements View.OnClickListener {
    private BottomSheetBehavior behavior;
    private OperableView operableView;
    private View targetView;
    private TextView tvType;
    private TextView tvClazz;
    private TextView tvPath;
    private TextView tvId;
    private TextView tvSize;
    private RecyclerView parentRv;
    private RecyclerView currentRv;
    private RecyclerView childRv;
    private UniversalAdapter parentAdapter = new UniversalAdapter();
    private UniversalAdapter currentAdapter = new UniversalAdapter();
    private UniversalAdapter childAdapter = new UniversalAdapter();
    private UniversalAdapter.OnItemClickListener clickListener = new UniversalAdapter.OnItemClickListener(){

        @Override
        public void onItemClick(int position, BaseItem item) {
            if (item instanceof ViewItem) {
                boolean success;
                View clickItem = (View)item.data;
                boolean selected = ((ViewItem)item).selected;
                if (!selected && !(success = ViewFragment.this.operableView.handleClick(clickItem))) {
                    Utils.toast("Alpha == 0 || Visibility != VISIBLE");
                }
            }
        }
    };

    @Override
    protected boolean enableToolbar() {
        return false;
    }

    @Override
    protected boolean enableSwipeBack() {
        return false;
    }

    @Override
    protected int getLayoutId() {
        return 0;
    }

    @Override
    protected View getLayoutView() {
        View panelView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pd_layout_view_panel, null);
        this.operableView = new OperableView(this.getContext());
        this.operableView.tryGetFrontView(Pandora.get().getBottomActivity());
        this.operableView.setOnClickListener(this);
        CoordinatorLayout layout2 = new CoordinatorLayout(this.getContext());
        CoordinatorLayout.LayoutParams selectViewParams = new CoordinatorLayout.LayoutParams(-1, -2);
        layout2.addView((View)this.operableView, (ViewGroup.LayoutParams)selectViewParams);
        CoordinatorLayout.LayoutParams panelViewParams = new CoordinatorLayout.LayoutParams(-1, -2);
        this.behavior = new BottomSheetBehavior();
        panelViewParams.setBehavior((CoordinatorLayout.Behavior)this.behavior);
        this.behavior.setPeekHeight(ViewKnife.dip2px(122.0f));
        this.behavior.setHideable(true);
        this.behavior.setState(5);
        layout2.addView(panelView, (ViewGroup.LayoutParams)panelViewParams);
        return layout2;
    }

    public void onClick(View v) {
        if (this.operableView.isSelectedEmpty()) {
            this.behavior.setState(5);
        } else if (this.behavior.getState() == 5) {
            this.behavior.setState(4);
        }
        this.targetView = v;
        this.refreshViewInfo(v);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            return;
        }
        view.findViewById(R.id.view_panel_wrapper).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewFragment.this.targetView.setTag(R.id.pd_view_tag_for_unique, new Object());
                ViewFragment.this.launch(ViewAttrFragment.class, null);
            }
        });
        view.findViewById(R.id.view_panel_hierarchy).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ViewFragment.this.targetView.setTag(R.id.pd_view_tag_for_unique, new Object());
                ViewFragment.this.launch(HierarchyFragment.class, null);
            }
        });
        this.tvType = (TextView)view.findViewById(R.id.view_panel_type);
        this.tvClazz = (TextView)view.findViewById(R.id.view_panel_clazz);
        this.tvPath = (TextView)view.findViewById(R.id.view_panel_path);
        this.tvId = (TextView)view.findViewById(R.id.view_panel_id);
        this.tvSize = (TextView)view.findViewById(R.id.view_panel_size);
        this.parentRv = (RecyclerView)view.findViewById(R.id.view_panel_parent);
        this.parentRv.setAdapter((RecyclerView.Adapter)this.parentAdapter);
        this.parentAdapter.setListener(this.clickListener);
        this.currentRv = (RecyclerView)view.findViewById(R.id.view_panel_current);
        this.currentRv.setAdapter((RecyclerView.Adapter)this.currentAdapter);
        this.currentAdapter.setListener(this.clickListener);
        this.childRv = (RecyclerView)view.findViewById(R.id.view_panel_child);
        this.childRv.setAdapter((RecyclerView.Adapter)this.childAdapter);
        this.childAdapter.setListener(this.clickListener);
    }

    private void refreshViewInfo(View target) {
        this.tvType.setText((CharSequence)(target instanceof ViewGroup ? "group" : "view"));
        this.tvClazz.setText((CharSequence)target.getClass().getSimpleName());
        this.tvPath.setText((CharSequence)target.getClass().getName());
        this.tvId.setText((CharSequence)ViewKnife.getIdString(target));
        int widthText = ViewKnife.px2dip(target.getWidth());
        int heightText = ViewKnife.px2dip(target.getHeight());
        this.tvSize.setText((CharSequence)String.format("%d x %d dp", widthText, heightText));
        this.parentAdapter.clearItems();
        this.currentAdapter.clearItems();
        this.childAdapter.clearItems();
        if (target instanceof ViewGroup) {
            ArrayList<ViewItem> childData = new ArrayList<ViewItem>();
            for (int i = 0; i < ((ViewGroup)target).getChildCount(); ++i) {
                View item = ((ViewGroup)target).getChildAt(i);
                childData.add(new ViewItem(item, false, true));
            }
            this.childAdapter.setItems(childData);
        }
        if (target.getParent() != null && target.getParent() instanceof ViewGroup) {
            ViewGroup parentGroup = (ViewGroup)target.getParent();
            ArrayList<ViewItem> parentGroupData = new ArrayList<ViewItem>();
            for (int i = 0; i < parentGroup.getChildCount(); ++i) {
                View item;
                parentGroupData.add(new ViewItem(item, (item = parentGroup.getChildAt(i)) == target, false));
            }
            this.currentAdapter.setItems(parentGroupData);
            if (parentGroup.getParent() != null && parentGroup.getParent() instanceof ViewGroup) {
                ViewGroup grandGroup = (ViewGroup)parentGroup.getParent();
                ArrayList<ViewItem> grandGroupData = new ArrayList<ViewItem>();
                for (int i = 0; i < grandGroup.getChildCount(); ++i) {
                    View item;
                    grandGroupData.add(new ViewItem(item, false, (item = grandGroup.getChildAt(i)) == target.getParent()));
                }
                this.parentAdapter.setItems(grandGroupData);
            }
        }
    }
}

