/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.inspector.model.Attribute;
import tech.linjiang.pandora.ui.connector.EditCallback;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.EditFragment;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.item.ViewAttrItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class ViewAttrFragment
extends BaseListFragment {
    private View targetView;
    private int editType;
    private EditCallback callback = new EditCallback(){

        @Override
        public void onValueChanged(String value) {
            try {
                block1 : switch (ViewAttrFragment.this.editType) {
                    case 8: {
                        float alpha = Float.valueOf(value).floatValue();
                        ViewAttrFragment.this.targetView.setAlpha(alpha);
                        break;
                    }
                    case 2: {
                        switch (value) {
                            case "WRAP_CONTENT": {
                                ((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams().height = -2;
                                break block1;
                            }
                            case "MATCH_PARENT": {
                                ((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams().height = -1;
                                break block1;
                            }
                        }
                        int height = Integer.valueOf(value);
                        ((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams().height = ViewKnife.dip2px(height);
                        break;
                    }
                    case 1: {
                        switch (value) {
                            case "WRAP_CONTENT": {
                                ((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams().width = -2;
                                break block1;
                            }
                            case "MATCH_PARENT": {
                                ((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams().width = -1;
                                break block1;
                            }
                        }
                        int width = Integer.valueOf(value);
                        ((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams().width = ViewKnife.dip2px(width);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 7: {
                        int pdBottom = Integer.valueOf(value);
                        ViewAttrFragment.this.targetView.setPadding(ViewAttrFragment.this.targetView.getPaddingLeft(), ViewAttrFragment.this.targetView.getPaddingTop(), ViewAttrFragment.this.targetView.getPaddingRight(), ViewKnife.dip2px(pdBottom));
                        break;
                    }
                    case 4: {
                        int pdLeft = Integer.valueOf(value);
                        ViewAttrFragment.this.targetView.setPadding(ViewKnife.dip2px(pdLeft), ViewAttrFragment.this.targetView.getPaddingTop(), ViewAttrFragment.this.targetView.getPaddingRight(), ViewAttrFragment.this.targetView.getPaddingBottom());
                        break;
                    }
                    case 5: {
                        int pdRight = Integer.valueOf(value);
                        ViewAttrFragment.this.targetView.setPadding(ViewAttrFragment.this.targetView.getPaddingLeft(), ViewAttrFragment.this.targetView.getPaddingTop(), ViewKnife.dip2px(pdRight), ViewAttrFragment.this.targetView.getPaddingBottom());
                        break;
                    }
                    case 6: {
                        int pdTop = Integer.valueOf(value);
                        ViewAttrFragment.this.targetView.setPadding(ViewAttrFragment.this.targetView.getPaddingLeft(), ViewKnife.dip2px(pdTop), ViewAttrFragment.this.targetView.getPaddingRight(), ViewAttrFragment.this.targetView.getPaddingBottom());
                        break;
                    }
                    case 19: {
                        ImageView.ScaleType scaleType = null;
                        switch (value) {
                            case "CENTER_INSIDE": {
                                scaleType = ImageView.ScaleType.CENTER_INSIDE;
                                break;
                            }
                            case "CENTER_CROP": {
                                scaleType = ImageView.ScaleType.CENTER_CROP;
                                break;
                            }
                            case "CENTER": {
                                scaleType = ImageView.ScaleType.CENTER;
                                break;
                            }
                            case "FIT_CENTER": {
                                scaleType = ImageView.ScaleType.FIT_CENTER;
                                break;
                            }
                            case "FIT_END": {
                                scaleType = ImageView.ScaleType.FIT_END;
                                break;
                            }
                            case "FIT_START": {
                                scaleType = ImageView.ScaleType.FIT_START;
                                break;
                            }
                            case "FIT_XY": {
                                scaleType = ImageView.ScaleType.FIT_XY;
                                break;
                            }
                            case "MATRIX": {
                                scaleType = ImageView.ScaleType.MATRIX;
                            }
                        }
                        if (scaleType == null) break;
                        ((ImageView)ViewAttrFragment.this.targetView).setScaleType(scaleType);
                        break;
                    }
                    case 17: {
                        int color2 = Color.parseColor((String)value);
                        ((TextView)ViewAttrFragment.this.targetView).setTextColor(color2);
                        break;
                    }
                    case 16: {
                        float size = Float.valueOf(value).floatValue();
                        ((TextView)ViewAttrFragment.this.targetView).setTextSize(size);
                        break;
                    }
                    case 18: {
                        ((TextView)ViewAttrFragment.this.targetView).setText((CharSequence)value);
                        break;
                    }
                    case 3: {
                        int visibility = -1;
                        switch (value) {
                            case "VISIBLE": {
                                visibility = 0;
                                break;
                            }
                            case "GONE": {
                                visibility = 8;
                                break;
                            }
                            case "INVISIBLE": {
                                visibility = 4;
                            }
                        }
                        ViewAttrFragment.this.targetView.setVisibility(visibility);
                        break;
                    }
                    case 23: {
                        int leftMargin = Integer.valueOf(value);
                        ((ViewGroup.MarginLayoutParams)((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams()).leftMargin = ViewKnife.dip2px(leftMargin);
                        break;
                    }
                    case 20: {
                        int rightMargin = Integer.valueOf(value);
                        ((ViewGroup.MarginLayoutParams)((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams()).rightMargin = ViewKnife.dip2px(rightMargin);
                        break;
                    }
                    case 21: {
                        int topMargin = Integer.valueOf(value);
                        ((ViewGroup.MarginLayoutParams)((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams()).topMargin = ViewKnife.dip2px(topMargin);
                        break;
                    }
                    case 22: {
                        int bottomMargin = Integer.valueOf(value);
                        ((ViewGroup.MarginLayoutParams)((ViewAttrFragment)ViewAttrFragment.this).targetView.getLayoutParams()).bottomMargin = ViewKnife.dip2px(bottomMargin);
                    }
                }
                ViewAttrFragment.this.targetView.requestLayout();
                ViewAttrFragment.this.targetView.post(new Runnable(){

                    @Override
                    public void run() {
                        ViewAttrFragment.this.loadData();
                    }
                });
            }
            catch (Throwable t) {
                Utils.toast(t.getMessage());
            }
        }
    };

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Pandora.get().getBottomActivity() != null) {
            this.targetView = this.findViewByDefaultTag(Pandora.get().getBottomActivity().getWindow().peekDecorView());
            if (this.targetView != null) {
                this.targetView.setTag(R.id.pd_view_tag_for_unique, null);
            }
        }
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.targetView == null) {
            return;
        }
        this.getToolbar().setTitle((CharSequence)this.targetView.getClass().getSimpleName());
        this.getToolbar().setSubtitle((CharSequence)("@" + ViewKnife.getIdString(this.targetView)));
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (item instanceof ViewAttrItem) {
                    ViewAttrFragment.this.editType = ((Attribute)((ViewAttrItem)item).data).attrType;
                    if (ViewAttrFragment.this.editType != 0) {
                        Bundle bundle = new Bundle();
                        bundle.putSerializable("param2", (Serializable)ViewAttrFragment.this.callback);
                        bundle.putStringArray("param3", ViewAttrFragment.this.assembleOption(ViewAttrFragment.this.editType));
                        ViewAttrFragment.this.launch(EditFragment.class, bundle);
                    } else {
                        Utils.toast(R.string.pd_can_not_edit);
                    }
                }
            }
        });
        this.loadData();
    }

    private View findViewByDefaultTag(View root) {
        if (root.getTag(R.id.pd_view_tag_for_unique) != null) {
            return root;
        }
        if (root instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)root;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                View view = this.findViewByDefaultTag(parent.getChildAt(i));
                if (view == null) continue;
                return view;
            }
        }
        return null;
    }

    private void loadData() {
        this.showLoading();
        new SimpleTask<Void, List<BaseItem>>(new SimpleTask.Callback<Void, List<BaseItem>>(){

            public List<BaseItem> doInBackground(Void[] params) {
                List<Attribute> attributes;
                ArrayList<BaseItem> data = new ArrayList<BaseItem>();
                Context context = ViewAttrFragment.this.targetView.getContext();
                if (context instanceof Activity) {
                    data.add(new TitleItem(context.getClass().getSimpleName()));
                    data.add(new ViewAttrItem(new Attribute("package", context.getClass().getPackage().getName())));
                    data.add(new ViewAttrItem(new Attribute("id", ViewAttrFragment.this.getToolbar().getSubtitle().toString())));
                }
                if (Utils.isNotEmpty(attributes = Pandora.get().getAttrFactory().parse(ViewAttrFragment.this.targetView))) {
                    String category = null;
                    for (Attribute attr : attributes) {
                        if (!TextUtils.equals(category, (CharSequence)attr.category)) {
                            category = attr.category;
                            data.add(new TitleItem(category));
                        }
                        data.add(new ViewAttrItem(attr));
                    }
                }
                return data;
            }

            @Override
            public void onPostExecute(List<BaseItem> data) {
                ViewAttrFragment.this.getAdapter().setItems(data);
                ViewAttrFragment.this.hideLoading();
            }
        }).execute(new Void[0]);
    }

    private String[] assembleOption(int type) {
        switch (type) {
            case 1: 
            case 2: {
                return Utils.newArray("MATCH_PARENT", "WRAP_CONTENT");
            }
            case 19: {
                return Utils.newArray("CENTER_INSIDE", "CENTER_CROP", "CENTER", "FIT_CENTER", "FIT_END", "FIT_START", "FIT_XY", "MATRIX");
            }
            case 3: {
                return Utils.newArray("VISIBLE", "INVISIBLE", "GONE");
            }
        }
        return null;
    }
}

