/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import tech.linjiang.pandora.sandbox.Sandbox;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.FileAttrFragment;
import tech.linjiang.pandora.ui.item.FileItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.Utils;

public class FileFragment
extends BaseListFragment {
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        File file = (File)this.getArguments().getSerializable("param1");
        this.getToolbar().setTitle((CharSequence)file.getName());
        List<File> files = Sandbox.getFiles(file);
        if (Utils.isNotEmpty(files)) {
            ArrayList<BaseItem> data = new ArrayList<BaseItem>();
            data.add(new TitleItem(String.format(Locale.getDefault(), "%d FILES", files.size())));
            for (int i = 0; i < files.size(); ++i) {
                data.add(new FileItem(files.get(i)));
            }
            this.getAdapter().setItems(data);
            this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

                @Override
                public void onItemClick(int position, BaseItem item) {
                    Bundle bundle = new Bundle();
                    if (item instanceof FileItem) {
                        bundle.putSerializable("param1", (Serializable)((File)item.data));
                        if (((File)item.data).isDirectory()) {
                            FileFragment.this.launch(FileFragment.class, bundle);
                        } else {
                            FileFragment.this.launch(FileAttrFragment.class, bundle);
                        }
                    }
                }
            });
        } else {
            this.showError(null);
        }
    }
}

