/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.network.CacheDbHelper;
import tech.linjiang.pandora.network.model.Content;
import tech.linjiang.pandora.ui.connector.SimpleOnActionExpandListener;
import tech.linjiang.pandora.ui.connector.SimpleOnQueryTextListener;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.item.ContentItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.JsonUtil;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class NetContentFragment
extends BaseListFragment {
    private boolean showResponse;
    private long id;
    private String originContent;
    private String filter;
    private Runnable filterTask = new Runnable(){

        @Override
        public void run() {
            if (Utils.isNotEmpty(NetContentFragment.this.getAdapter().getItems())) {
                int targetPos = -1;
                for (int i = 0; i < NetContentFragment.this.getAdapter().getItems().size(); ++i) {
                    BaseItem item = NetContentFragment.this.getAdapter().getItems().get(i);
                    if (!(item instanceof ContentItem)) continue;
                    ((ContentItem)item).setFocus(false);
                    if (TextUtils.isEmpty((CharSequence)NetContentFragment.this.filter) || !((String)item.data).toLowerCase().contains(NetContentFragment.this.filter.toLowerCase())) continue;
                    ((ContentItem)item).setFocus(true);
                    if (targetPos != -1) continue;
                    targetPos = i;
                }
                if (targetPos == -1) {
                    targetPos = 0;
                }
                NetContentFragment.this.getAdapter().notifyDataSetChanged();
                NetContentFragment.this.getRecyclerView().scrollToPosition(targetPos);
            }
        }
    };

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.showResponse = this.getArguments().getBoolean("param1", true);
        this.id = this.getArguments().getLong("param2");
    }

    @Override
    protected View getLayoutView() {
        HorizontalScrollView scrollView = new HorizontalScrollView(this.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        scrollView.setFillViewport(true);
        scrollView.addView(super.getLayoutView(), params);
        return scrollView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Content");
        this.getRecyclerView().removeItemDecoration(this.getRecyclerView().getItemDecorationAt(0));
        this.setSearchView();
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (item instanceof ContentItem) {
                    Utils.copy2ClipBoard((String)item.data);
                }
            }
        });
        this.loadData();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        Utils.cancelTask(this.filterTask);
        this.closeSoftInput();
    }

    private void setSearchView() {
        this.getToolbar().getMenu().findItem(R.id.menu_copy).setVisible(true);
        this.getToolbar().getMenu().findItem(R.id.menu_search).setVisible(true);
        this.getToolbar().getMenu().findItem(R.id.menu_share).setVisible(true);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (item.getItemId() == R.id.menu_copy) {
                    Utils.copy2ClipBoard(NetContentFragment.this.originContent);
                } else if (item.getItemId() == R.id.menu_share) {
                    Utils.shareText(NetContentFragment.this.originContent);
                }
                return true;
            }
        });
        MenuItem menuItem = this.getToolbar().getMenu().findItem(R.id.menu_search);
        SearchView searchView = (SearchView)menuItem.getActionView();
        searchView.setInputType(144);
        searchView.setQueryHint((CharSequence)ViewKnife.getString(R.string.pd_net_search_hint));
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)new SimpleOnQueryTextListener(){

            @Override
            public boolean onQueryTextChange(String newText) {
                NetContentFragment.this.filter = newText;
                NetContentFragment.this.readyFilter();
                return true;
            }
        });
        menuItem.setOnActionExpandListener((MenuItem.OnActionExpandListener)new SimpleOnActionExpandListener(){

            @Override
            public boolean onMenuItemActionCollapse(MenuItem item) {
                NetContentFragment.this.filter = null;
                NetContentFragment.this.readyFilter();
                return true;
            }
        });
    }

    private void loadData() {
        this.showLoading();
        new SimpleTask<Void, String>(new SimpleTask.Callback<Void, String>(){

            public String doInBackground(Void[] params) {
                Content content = CacheDbHelper.getContent(NetContentFragment.this.id);
                if (NetContentFragment.this.showResponse) {
                    return content.responseBody;
                }
                return content.requestBody;
            }

            @Override
            public void onPostExecute(String result) {
                NetContentFragment.this.hideLoading();
                try {
                    NetContentFragment.this.originContent = URLDecoder.decode(result, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    NetContentFragment.this.originContent = result;
                }
                NetContentFragment.this.tryFormatJson(NetContentFragment.this.originContent);
            }
        }).execute(new Void[0]);
    }

    private void tryFormatJson(final String content) {
        new SimpleTask<Void, List<String>>(new SimpleTask.Callback<Void, List<String>>(){

            public List<String> doInBackground(Void[] params) {
                return JsonUtil.print(content);
            }

            @Override
            public void onPostExecute(List<String> result) {
                if (Utils.isNotEmpty(result)) {
                    ArrayList<ContentItem> data = new ArrayList<ContentItem>(result.size());
                    for (int i = 0; i < result.size(); ++i) {
                        data.add(new ContentItem(result.get(i)));
                    }
                    NetContentFragment.this.getAdapter().setItems(data);
                } else {
                    NetContentFragment.this.getToolbar().getMenu().clear();
                    NetContentFragment.this.showError(null);
                }
            }
        }).execute(new Void[0]);
    }

    private void readyFilter() {
        Utils.cancelTask(this.filterTask);
        Utils.postDelayed(this.filterTask, 400L);
    }
}

