/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.view;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class EntranceView
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = "EntranceView";
    private float lastY;
    private View.OnClickListener clickListener;
    private boolean isOpen;
    private View.OnTouchListener touchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    EntranceView.this.lastY = event.getRawY();
                    break;
                }
                case 2: {
                    WindowManager.LayoutParams params = (WindowManager.LayoutParams)EntranceView.this.getLayoutParams();
                    params.y = (int)((float)params.y + (event.getRawY() - EntranceView.this.lastY));
                    params.y = Math.max(0, params.y);
                    EntranceView.this.getWindowManager().updateViewLayout((View)EntranceView.this, (ViewGroup.LayoutParams)params);
                    EntranceView.this.lastY = event.getRawY();
                    break;
                }
            }
            return true;
        }
    };
    private static final EntranceView instance = new EntranceView(Utils.getContext());

    public EntranceView(Context context) {
        super(context);
        this.initSelf();
        this.inflate();
    }

    private void initSelf() {
        this.setOrientation(0);
        this.setGravity(16);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(ViewKnife.getDrawable(R.drawable.pd_shadow_131124));
        } else {
            this.setBackgroundDrawable(ViewKnife.getDrawable(R.drawable.pd_shadow_131124));
        }
        ImageView dragView = new ImageView(this.getContext());
        dragView.setImageResource(R.drawable.pd_drag);
        dragView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        dragView.setOnTouchListener(this.touchListener);
        this.addView((View)dragView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(ViewKnife.dip2px(24.0f), -2));
    }

    private void inflate() {
        final View entranceWrapper = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pd_layout_entrance, null);
        final View inspectWrapper = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pd_layout_ui_inspect, null);
        entranceWrapper.findViewById(R.id.entrance_network).setOnClickListener((View.OnClickListener)this);
        entranceWrapper.findViewById(R.id.entrance_sandbox).setOnClickListener((View.OnClickListener)this);
        entranceWrapper.findViewById(R.id.ui_select).setOnClickListener((View.OnClickListener)this);
        entranceWrapper.findViewById(R.id.entrance_more).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                entranceWrapper.setVisibility(8);
                inspectWrapper.setVisibility(0);
            }
        });
        entranceWrapper.findViewById(R.id.entrance_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EntranceView.close();
            }
        });
        inspectWrapper.findViewById(R.id.ui_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                entranceWrapper.setVisibility(0);
                inspectWrapper.setVisibility(8);
            }
        });
        inspectWrapper.findViewById(R.id.entrance_config).setOnClickListener((View.OnClickListener)this);
        inspectWrapper.findViewById(R.id.ui_hierarchy).setOnClickListener((View.OnClickListener)this);
        inspectWrapper.findViewById(R.id.ui_grid).setOnClickListener((View.OnClickListener)this);
        inspectWrapper.findViewById(R.id.ui_window).setOnClickListener((View.OnClickListener)this);
        inspectWrapper.findViewById(R.id.ui_baseline).setOnClickListener((View.OnClickListener)this);
        this.addView(entranceWrapper);
        this.addView(inspectWrapper);
    }

    public void enableNetwork(boolean use) {
        this.findViewById(R.id.entrance_network).setVisibility(use ? 0 : 8);
    }

    public void enableSandbox(boolean use) {
        this.findViewById(R.id.entrance_sandbox).setVisibility(use ? 0 : 8);
    }

    public void enableUiInspect(boolean use) {
        this.findViewById(R.id.ui_select).setVisibility(use ? 0 : 8);
    }

    public static void open() {
        if (EntranceView.instance.isOpen) {
            return;
        }
        instance.getChildAt(1).setVisibility(0);
        instance.getChildAt(2).setVisibility(8);
        try {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = -2;
            params.height = -2;
            params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
            params.flags = 8;
            params.format = -3;
            params.gravity = 0x800033;
            params.x = 0;
            params.y = 0;
            instance.getWindowManager().addView((View)instance, (ViewGroup.LayoutParams)params);
            EntranceView.instance.isOpen = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close() {
        if (!EntranceView.instance.isOpen) {
            return;
        }
        try {
            instance.getWindowManager().removeView((View)instance);
            EntranceView.instance.isOpen = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void hide() {
        instance.setVisibility(8);
    }

    public static void show() {
        boolean netEnable = Config.getCOMMON_NETWORK_SWITCH();
        boolean sbEnable = Config.getCOMMON_SANDBOX_SWITCH();
        boolean uiEnable = Config.getCOMMON_UI_SWITCH();
        instance.enableNetwork(netEnable);
        instance.enableSandbox(sbEnable);
        instance.enableUiInspect(uiEnable);
        instance.setVisibility(0);
    }

    public static void setListener(@Nullable View.OnClickListener l) {
        EntranceView.instance.clickListener = l;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.clickListener = l;
    }

    public void onClick(View v) {
        if (this.clickListener != null) {
            this.clickListener.onClick(v);
        }
    }

    private WindowManager getWindowManager() {
        return (WindowManager)this.getContext().getSystemService("window");
    }
}

