/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.view;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.util.ViewKnife;

public class EntranceView
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = "EntranceView";
    private WindowManager windowManager;
    private WindowManager.LayoutParams params = new WindowManager.LayoutParams();
    private float lastY;
    private View entranceWrapper;
    private View inspectWrapper;
    private View.OnClickListener clickListener;
    private boolean isOpen;
    private View.OnTouchListener touchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    EntranceView.this.lastY = event.getRawY();
                    break;
                }
                case 2: {
                    ((EntranceView)EntranceView.this).params.y = (int)((float)((EntranceView)EntranceView.this).params.y + (event.getRawY() - EntranceView.this.lastY));
                    ((EntranceView)EntranceView.this).params.y = Math.max(0, ((EntranceView)EntranceView.this).params.y);
                    EntranceView.this.windowManager.updateViewLayout((View)EntranceView.this, (ViewGroup.LayoutParams)EntranceView.this.params);
                    EntranceView.this.lastY = event.getRawY();
                    break;
                }
            }
            return true;
        }
    };

    public EntranceView(Context context) {
        super(context);
        this.windowManager = (WindowManager)context.getSystemService("window");
        this.initSelf();
        this.inflate();
    }

    private void initSelf() {
        this.setOrientation(0);
        this.setGravity(16);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(ViewKnife.getDrawable(R.drawable.pd_shadow_131124));
        } else {
            this.setBackgroundDrawable(ViewKnife.getDrawable(R.drawable.pd_shadow_131124));
        }
        ImageView dragView = new ImageView(this.getContext());
        dragView.setImageResource(R.drawable.pd_drag);
        dragView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        dragView.setOnTouchListener(this.touchListener);
        this.addView((View)dragView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(ViewKnife.dip2px(24.0f), -2));
    }

    private void inflate() {
        this.entranceWrapper = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pd_layout_entrance, null);
        this.inspectWrapper = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pd_layout_ui_inspect, null);
        this.entranceWrapper.findViewById(R.id.entrance_network).setOnClickListener((View.OnClickListener)this);
        this.entranceWrapper.findViewById(R.id.entrance_sandbox).setOnClickListener((View.OnClickListener)this);
        this.entranceWrapper.findViewById(R.id.entrance_ui).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EntranceView.this.entranceWrapper.setVisibility(8);
                EntranceView.this.inspectWrapper.setVisibility(0);
            }
        });
        this.entranceWrapper.findViewById(R.id.entrance_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EntranceView.this.close();
            }
        });
        this.inspectWrapper.findViewById(R.id.ui_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EntranceView.this.entranceWrapper.setVisibility(0);
                EntranceView.this.inspectWrapper.setVisibility(8);
            }
        });
        this.inspectWrapper.findViewById(R.id.ui_hierarchy).setOnClickListener((View.OnClickListener)this);
        this.inspectWrapper.findViewById(R.id.ui_select).setOnClickListener((View.OnClickListener)this);
        this.inspectWrapper.findViewById(R.id.ui_info).setOnClickListener((View.OnClickListener)this);
        this.inspectWrapper.findViewById(R.id.ui_baseline).setOnClickListener((View.OnClickListener)this);
    }

    public void enableNetwork(boolean use) {
        this.entranceWrapper.findViewById(R.id.entrance_network).setVisibility(use ? 0 : 8);
    }

    public void enableSandbox(boolean use) {
        this.entranceWrapper.findViewById(R.id.entrance_sandbox).setVisibility(use ? 0 : 8);
    }

    public void enableUiInspect(boolean use) {
        this.entranceWrapper.findViewById(R.id.entrance_ui).setVisibility(use ? 0 : 8);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void open() {
        this.close();
        this.entranceWrapper.setVisibility(0);
        this.inspectWrapper.setVisibility(8);
        this.addView(this.entranceWrapper);
        this.addView(this.inspectWrapper);
        try {
            this.params.width = -2;
            this.params.height = -2;
            this.params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
            this.params.flags = 8;
            this.params.format = -3;
            this.params.gravity = 0x800033;
            this.params.x = 0;
            this.params.y = 0;
            this.windowManager.addView((View)this, (ViewGroup.LayoutParams)this.params);
            this.isOpen = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void close() {
        this.removeView(this.entranceWrapper);
        this.removeView(this.inspectWrapper);
        try {
            this.windowManager.removeView((View)this);
            this.isOpen = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void hide() {
        this.setVisibility(8);
    }

    public void show() {
        this.setVisibility(0);
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.clickListener = l;
    }

    public void onClick(View v) {
        if (this.clickListener != null) {
            this.clickListener.onClick(v);
        }
    }
}

